/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateResolverQueryLogConfigRequest extends Route53ResolverRequest implements
        ToCopyableBuilder<CreateResolverQueryLogConfigRequest.Builder, CreateResolverQueryLogConfigRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateResolverQueryLogConfigRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESTINATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationArn").getter(getter(CreateResolverQueryLogConfigRequest::destinationArn))
            .setter(setter(Builder::destinationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationArn").build()).build();

    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CreatorRequestId")
            .getter(getter(CreateResolverQueryLogConfigRequest::creatorRequestId))
            .setter(setter(Builder::creatorRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateResolverQueryLogConfigRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            DESTINATION_ARN_FIELD, CREATOR_REQUEST_ID_FIELD, TAGS_FIELD));

    private final String name;

    private final String destinationArn;

    private final String creatorRequestId;

    private final List<Tag> tags;

    private CreateResolverQueryLogConfigRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.destinationArn = builder.destinationArn;
        this.creatorRequestId = builder.creatorRequestId;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name that you want to give the query logging configuration
     * </p>
     * 
     * @return The name that you want to give the query logging configuration
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ARN of the resource that you want Resolver to send query logs. You can send query logs to an S3 bucket, a
     * CloudWatch Logs log group, or a Kinesis Data Firehose delivery stream. Examples of valid values include the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>S3 bucket</b>:
     * </p>
     * <p>
     * <code>arn:aws:s3:::examplebucket</code>
     * </p>
     * <p>
     * You can optionally append a file prefix to the end of the ARN.
     * </p>
     * <p>
     * <code>arn:aws:s3:::examplebucket/development/</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CloudWatch Logs log group</b>:
     * </p>
     * <p>
     * <code>arn:aws:logs:us-west-1:123456789012:log-group:/mystack-testgroup-12ABC1AB12A1:*</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Kinesis Data Firehose delivery stream</b>:
     * </p>
     * <p>
     * <code>arn:aws:kinesis:us-east-2:0123456789:stream/my_stream_name</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The ARN of the resource that you want Resolver to send query logs. You can send query logs to an S3
     *         bucket, a CloudWatch Logs log group, or a Kinesis Data Firehose delivery stream. Examples of valid values
     *         include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>S3 bucket</b>:
     *         </p>
     *         <p>
     *         <code>arn:aws:s3:::examplebucket</code>
     *         </p>
     *         <p>
     *         You can optionally append a file prefix to the end of the ARN.
     *         </p>
     *         <p>
     *         <code>arn:aws:s3:::examplebucket/development/</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>CloudWatch Logs log group</b>:
     *         </p>
     *         <p>
     *         <code>arn:aws:logs:us-west-1:123456789012:log-group:/mystack-testgroup-12ABC1AB12A1:*</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Kinesis Data Firehose delivery stream</b>:
     *         </p>
     *         <p>
     *         <code>arn:aws:kinesis:us-east-2:0123456789:stream/my_stream_name</code>
     *         </p>
     *         </li>
     */
    public final String destinationArn() {
        return destinationArn;
    }

    /**
     * <p>
     * A unique string that identifies the request and that allows failed requests to be retried without the risk of
     * executing the operation twice. <code>CreatorRequestId</code> can be any unique string, for example, a date/time
     * stamp.
     * </p>
     * 
     * @return A unique string that identifies the request and that allows failed requests to be retried without the
     *         risk of executing the operation twice. <code>CreatorRequestId</code> can be any unique string, for
     *         example, a date/time stamp.
     */
    public final String creatorRequestId() {
        return creatorRequestId;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the tag keys and values that you want to associate with the query logging configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the tag keys and values that you want to associate with the query logging configuration.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(destinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResolverQueryLogConfigRequest)) {
            return false;
        }
        CreateResolverQueryLogConfigRequest other = (CreateResolverQueryLogConfigRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(destinationArn(), other.destinationArn())
                && Objects.equals(creatorRequestId(), other.creatorRequestId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateResolverQueryLogConfigRequest").add("Name", name())
                .add("DestinationArn", destinationArn()).add("CreatorRequestId", creatorRequestId())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DestinationArn":
            return Optional.ofNullable(clazz.cast(destinationArn()));
        case "CreatorRequestId":
            return Optional.ofNullable(clazz.cast(creatorRequestId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateResolverQueryLogConfigRequest, T> g) {
        return obj -> g.apply((CreateResolverQueryLogConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateResolverQueryLogConfigRequest> {
        /**
         * <p>
         * The name that you want to give the query logging configuration
         * </p>
         * 
         * @param name
         *        The name that you want to give the query logging configuration
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN of the resource that you want Resolver to send query logs. You can send query logs to an S3 bucket, a
         * CloudWatch Logs log group, or a Kinesis Data Firehose delivery stream. Examples of valid values include the
         * following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>S3 bucket</b>:
         * </p>
         * <p>
         * <code>arn:aws:s3:::examplebucket</code>
         * </p>
         * <p>
         * You can optionally append a file prefix to the end of the ARN.
         * </p>
         * <p>
         * <code>arn:aws:s3:::examplebucket/development/</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>CloudWatch Logs log group</b>:
         * </p>
         * <p>
         * <code>arn:aws:logs:us-west-1:123456789012:log-group:/mystack-testgroup-12ABC1AB12A1:*</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Kinesis Data Firehose delivery stream</b>:
         * </p>
         * <p>
         * <code>arn:aws:kinesis:us-east-2:0123456789:stream/my_stream_name</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param destinationArn
         *        The ARN of the resource that you want Resolver to send query logs. You can send query logs to an S3
         *        bucket, a CloudWatch Logs log group, or a Kinesis Data Firehose delivery stream. Examples of valid
         *        values include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>S3 bucket</b>:
         *        </p>
         *        <p>
         *        <code>arn:aws:s3:::examplebucket</code>
         *        </p>
         *        <p>
         *        You can optionally append a file prefix to the end of the ARN.
         *        </p>
         *        <p>
         *        <code>arn:aws:s3:::examplebucket/development/</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>CloudWatch Logs log group</b>:
         *        </p>
         *        <p>
         *        <code>arn:aws:logs:us-west-1:123456789012:log-group:/mystack-testgroup-12ABC1AB12A1:*</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Kinesis Data Firehose delivery stream</b>:
         *        </p>
         *        <p>
         *        <code>arn:aws:kinesis:us-east-2:0123456789:stream/my_stream_name</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationArn(String destinationArn);

        /**
         * <p>
         * A unique string that identifies the request and that allows failed requests to be retried without the risk of
         * executing the operation twice. <code>CreatorRequestId</code> can be any unique string, for example, a
         * date/time stamp.
         * </p>
         * 
         * @param creatorRequestId
         *        A unique string that identifies the request and that allows failed requests to be retried without the
         *        risk of executing the operation twice. <code>CreatorRequestId</code> can be any unique string, for
         *        example, a date/time stamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);

        /**
         * <p>
         * A list of the tag keys and values that you want to associate with the query logging configuration.
         * </p>
         * 
         * @param tags
         *        A list of the tag keys and values that you want to associate with the query logging configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of the tag keys and values that you want to associate with the query logging configuration.
         * </p>
         * 
         * @param tags
         *        A list of the tag keys and values that you want to associate with the query logging configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of the tag keys and values that you want to associate with the query logging configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53ResolverRequest.BuilderImpl implements Builder {
        private String name;

        private String destinationArn;

        private String creatorRequestId;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResolverQueryLogConfigRequest model) {
            super(model);
            name(model.name);
            destinationArn(model.destinationArn);
            creatorRequestId(model.creatorRequestId);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDestinationArn() {
            return destinationArn;
        }

        @Override
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResolverQueryLogConfigRequest build() {
            return new CreateResolverQueryLogConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
