/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.route53resolver.model.AssociateResolverEndpointIpAddressRequest;
import software.amazon.awssdk.services.route53resolver.model.AssociateResolverEndpointIpAddressResponse;
import software.amazon.awssdk.services.route53resolver.model.AssociateResolverQueryLogConfigRequest;
import software.amazon.awssdk.services.route53resolver.model.AssociateResolverQueryLogConfigResponse;
import software.amazon.awssdk.services.route53resolver.model.AssociateResolverRuleRequest;
import software.amazon.awssdk.services.route53resolver.model.AssociateResolverRuleResponse;
import software.amazon.awssdk.services.route53resolver.model.CreateResolverEndpointRequest;
import software.amazon.awssdk.services.route53resolver.model.CreateResolverEndpointResponse;
import software.amazon.awssdk.services.route53resolver.model.CreateResolverQueryLogConfigRequest;
import software.amazon.awssdk.services.route53resolver.model.CreateResolverQueryLogConfigResponse;
import software.amazon.awssdk.services.route53resolver.model.CreateResolverRuleRequest;
import software.amazon.awssdk.services.route53resolver.model.CreateResolverRuleResponse;
import software.amazon.awssdk.services.route53resolver.model.DeleteResolverEndpointRequest;
import software.amazon.awssdk.services.route53resolver.model.DeleteResolverEndpointResponse;
import software.amazon.awssdk.services.route53resolver.model.DeleteResolverQueryLogConfigRequest;
import software.amazon.awssdk.services.route53resolver.model.DeleteResolverQueryLogConfigResponse;
import software.amazon.awssdk.services.route53resolver.model.DeleteResolverRuleRequest;
import software.amazon.awssdk.services.route53resolver.model.DeleteResolverRuleResponse;
import software.amazon.awssdk.services.route53resolver.model.DisassociateResolverEndpointIpAddressRequest;
import software.amazon.awssdk.services.route53resolver.model.DisassociateResolverEndpointIpAddressResponse;
import software.amazon.awssdk.services.route53resolver.model.DisassociateResolverQueryLogConfigRequest;
import software.amazon.awssdk.services.route53resolver.model.DisassociateResolverQueryLogConfigResponse;
import software.amazon.awssdk.services.route53resolver.model.DisassociateResolverRuleRequest;
import software.amazon.awssdk.services.route53resolver.model.DisassociateResolverRuleResponse;
import software.amazon.awssdk.services.route53resolver.model.GetResolverDnssecConfigRequest;
import software.amazon.awssdk.services.route53resolver.model.GetResolverDnssecConfigResponse;
import software.amazon.awssdk.services.route53resolver.model.GetResolverEndpointRequest;
import software.amazon.awssdk.services.route53resolver.model.GetResolverEndpointResponse;
import software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigAssociationRequest;
import software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigAssociationResponse;
import software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigPolicyRequest;
import software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigPolicyResponse;
import software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigRequest;
import software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigResponse;
import software.amazon.awssdk.services.route53resolver.model.GetResolverRuleAssociationRequest;
import software.amazon.awssdk.services.route53resolver.model.GetResolverRuleAssociationResponse;
import software.amazon.awssdk.services.route53resolver.model.GetResolverRulePolicyRequest;
import software.amazon.awssdk.services.route53resolver.model.GetResolverRulePolicyResponse;
import software.amazon.awssdk.services.route53resolver.model.GetResolverRuleRequest;
import software.amazon.awssdk.services.route53resolver.model.GetResolverRuleResponse;
import software.amazon.awssdk.services.route53resolver.model.ListResolverDnssecConfigsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverDnssecConfigsResponse;
import software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesResponse;
import software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsResponse;
import software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigAssociationsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigAssociationsResponse;
import software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigsResponse;
import software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsResponse;
import software.amazon.awssdk.services.route53resolver.model.ListResolverRulesRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverRulesResponse;
import software.amazon.awssdk.services.route53resolver.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.route53resolver.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.route53resolver.model.PutResolverQueryLogConfigPolicyRequest;
import software.amazon.awssdk.services.route53resolver.model.PutResolverQueryLogConfigPolicyResponse;
import software.amazon.awssdk.services.route53resolver.model.PutResolverRulePolicyRequest;
import software.amazon.awssdk.services.route53resolver.model.PutResolverRulePolicyResponse;
import software.amazon.awssdk.services.route53resolver.model.TagResourceRequest;
import software.amazon.awssdk.services.route53resolver.model.TagResourceResponse;
import software.amazon.awssdk.services.route53resolver.model.UntagResourceRequest;
import software.amazon.awssdk.services.route53resolver.model.UntagResourceResponse;
import software.amazon.awssdk.services.route53resolver.model.UpdateResolverDnssecConfigRequest;
import software.amazon.awssdk.services.route53resolver.model.UpdateResolverDnssecConfigResponse;
import software.amazon.awssdk.services.route53resolver.model.UpdateResolverEndpointRequest;
import software.amazon.awssdk.services.route53resolver.model.UpdateResolverEndpointResponse;
import software.amazon.awssdk.services.route53resolver.model.UpdateResolverRuleRequest;
import software.amazon.awssdk.services.route53resolver.model.UpdateResolverRuleResponse;
import software.amazon.awssdk.services.route53resolver.paginators.ListResolverDnssecConfigsPublisher;
import software.amazon.awssdk.services.route53resolver.paginators.ListResolverEndpointIpAddressesPublisher;
import software.amazon.awssdk.services.route53resolver.paginators.ListResolverEndpointsPublisher;
import software.amazon.awssdk.services.route53resolver.paginators.ListResolverQueryLogConfigAssociationsPublisher;
import software.amazon.awssdk.services.route53resolver.paginators.ListResolverQueryLogConfigsPublisher;
import software.amazon.awssdk.services.route53resolver.paginators.ListResolverRuleAssociationsPublisher;
import software.amazon.awssdk.services.route53resolver.paginators.ListResolverRulesPublisher;
import software.amazon.awssdk.services.route53resolver.paginators.ListTagsForResourcePublisher;

/**
 * Service client for accessing Route53Resolver asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * When you create a VPC using Amazon VPC, you automatically get DNS resolution within the VPC from Route 53 Resolver.
 * By default, Resolver answers DNS queries for VPC domain names such as domain names for EC2 instances or ELB load
 * balancers. Resolver performs recursive lookups against public name servers for all other domain names.
 * </p>
 * <p>
 * You can also configure DNS resolution between your VPC and your network over a Direct Connect or VPN connection:
 * </p>
 * <p>
 * <b>Forward DNS queries from resolvers on your network to Route 53 Resolver</b>
 * </p>
 * <p>
 * DNS resolvers on your network can forward DNS queries to Resolver in a specified VPC. This allows your DNS resolvers
 * to easily resolve domain names for AWS resources such as EC2 instances or records in a Route 53 private hosted zone.
 * For more information, see <a href=
 * "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/resolver.html#resolver-overview-forward-network-to-vpc"
 * >How DNS Resolvers on Your Network Forward DNS Queries to Route 53 Resolver</a> in the <i>Amazon Route 53 Developer
 * Guide</i>.
 * </p>
 * <p>
 * <b>Conditionally forward queries from a VPC to resolvers on your network</b>
 * </p>
 * <p>
 * You can configure Resolver to forward queries that it receives from EC2 instances in your VPCs to DNS resolvers on
 * your network. To forward selected queries, you create Resolver rules that specify the domain names for the DNS
 * queries that you want to forward (such as example.com), and the IP addresses of the DNS resolvers on your network
 * that you want to forward the queries to. If a query matches multiple rules (example.com, acme.example.com), Resolver
 * chooses the rule with the most specific match (acme.example.com) and forwards the query to the IP addresses that you
 * specified in that rule. For more information, see <a href=
 * "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/resolver.html#resolver-overview-forward-vpc-to-network"
 * >How Route 53 Resolver Forwards DNS Queries from Your VPCs to Your Network</a> in the <i>Amazon Route 53 Developer
 * Guide</i>.
 * </p>
 * <p>
 * Like Amazon VPC, Resolver is regional. In each region where you have VPCs, you can choose whether to forward queries
 * from your VPCs to your network (outbound queries), from your network to your VPCs (inbound queries), or both.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface Route53ResolverAsyncClient extends SdkClient {
    String SERVICE_NAME = "route53resolver";

    /**
     * Create a {@link Route53ResolverAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static Route53ResolverAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link Route53ResolverAsyncClient}.
     */
    static Route53ResolverAsyncClientBuilder builder() {
        return new DefaultRoute53ResolverAsyncClientBuilder();
    }

    /**
     * <p>
     * Adds IP addresses to an inbound or an outbound Resolver endpoint. If you want to add more than one IP address,
     * submit one <code>AssociateResolverEndpointIpAddress</code> request for each IP address.
     * </p>
     * <p>
     * To remove an IP address from an endpoint, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverEndpointIpAddress.html"
     * >DisassociateResolverEndpointIpAddress</a>.
     * </p>
     *
     * @param associateResolverEndpointIpAddressRequest
     * @return A Java Future containing the result of the AssociateResolverEndpointIpAddress operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceExistsException The resource that you tried to create already exists.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>LimitExceededException The request caused one or more limits to be exceeded.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.AssociateResolverEndpointIpAddress
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/AssociateResolverEndpointIpAddress"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateResolverEndpointIpAddressResponse> associateResolverEndpointIpAddress(
            AssociateResolverEndpointIpAddressRequest associateResolverEndpointIpAddressRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds IP addresses to an inbound or an outbound Resolver endpoint. If you want to add more than one IP address,
     * submit one <code>AssociateResolverEndpointIpAddress</code> request for each IP address.
     * </p>
     * <p>
     * To remove an IP address from an endpoint, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverEndpointIpAddress.html"
     * >DisassociateResolverEndpointIpAddress</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateResolverEndpointIpAddressRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateResolverEndpointIpAddressRequest#builder()}
     * </p>
     *
     * @param associateResolverEndpointIpAddressRequest
     *        A {@link Consumer} that will call methods on {@link AssociateResolverEndpointIpAddressRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AssociateResolverEndpointIpAddress operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceExistsException The resource that you tried to create already exists.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>LimitExceededException The request caused one or more limits to be exceeded.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.AssociateResolverEndpointIpAddress
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/AssociateResolverEndpointIpAddress"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateResolverEndpointIpAddressResponse> associateResolverEndpointIpAddress(
            Consumer<AssociateResolverEndpointIpAddressRequest.Builder> associateResolverEndpointIpAddressRequest) {
        return associateResolverEndpointIpAddress(AssociateResolverEndpointIpAddressRequest.builder()
                .applyMutation(associateResolverEndpointIpAddressRequest).build());
    }

    /**
     * <p>
     * Associates an Amazon VPC with a specified query logging configuration. Route 53 Resolver logs DNS queries that
     * originate in all of the Amazon VPCs that are associated with a specified query logging configuration. To
     * associate more than one VPC with a configuration, submit one <code>AssociateResolverQueryLogConfig</code> request
     * for each VPC.
     * </p>
     * <note>
     * <p>
     * The VPCs that you associate with a query logging configuration must be in the same Region as the configuration.
     * </p>
     * </note>
     * <p>
     * To remove a VPC from a query logging configuration, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html"
     * >DisassociateResolverQueryLogConfig</a>.
     * </p>
     *
     * @param associateResolverQueryLogConfigRequest
     * @return A Java Future containing the result of the AssociateResolverQueryLogConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceExistsException The resource that you tried to create already exists.</li>
     *         <li>LimitExceededException The request caused one or more limits to be exceeded.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.AssociateResolverQueryLogConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/AssociateResolverQueryLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateResolverQueryLogConfigResponse> associateResolverQueryLogConfig(
            AssociateResolverQueryLogConfigRequest associateResolverQueryLogConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an Amazon VPC with a specified query logging configuration. Route 53 Resolver logs DNS queries that
     * originate in all of the Amazon VPCs that are associated with a specified query logging configuration. To
     * associate more than one VPC with a configuration, submit one <code>AssociateResolverQueryLogConfig</code> request
     * for each VPC.
     * </p>
     * <note>
     * <p>
     * The VPCs that you associate with a query logging configuration must be in the same Region as the configuration.
     * </p>
     * </note>
     * <p>
     * To remove a VPC from a query logging configuration, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html"
     * >DisassociateResolverQueryLogConfig</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateResolverQueryLogConfigRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateResolverQueryLogConfigRequest#builder()}
     * </p>
     *
     * @param associateResolverQueryLogConfigRequest
     *        A {@link Consumer} that will call methods on {@link AssociateResolverQueryLogConfigRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AssociateResolverQueryLogConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceExistsException The resource that you tried to create already exists.</li>
     *         <li>LimitExceededException The request caused one or more limits to be exceeded.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.AssociateResolverQueryLogConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/AssociateResolverQueryLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateResolverQueryLogConfigResponse> associateResolverQueryLogConfig(
            Consumer<AssociateResolverQueryLogConfigRequest.Builder> associateResolverQueryLogConfigRequest) {
        return associateResolverQueryLogConfig(AssociateResolverQueryLogConfigRequest.builder()
                .applyMutation(associateResolverQueryLogConfigRequest).build());
    }

    /**
     * <p>
     * Associates a Resolver rule with a VPC. When you associate a rule with a VPC, Resolver forwards all DNS queries
     * for the domain name that is specified in the rule and that originate in the VPC. The queries are forwarded to the
     * IP addresses for the DNS resolvers that are specified in the rule. For more information about rules, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverRule.html"
     * >CreateResolverRule</a>.
     * </p>
     *
     * @param associateResolverRuleRequest
     * @return A Java Future containing the result of the AssociateResolverRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>LimitExceededException The request caused one or more limits to be exceeded.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>ResourceUnavailableException The specified resource isn't available.</li>
     *         <li>ResourceExistsException The resource that you tried to create already exists.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.AssociateResolverRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/AssociateResolverRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateResolverRuleResponse> associateResolverRule(
            AssociateResolverRuleRequest associateResolverRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a Resolver rule with a VPC. When you associate a rule with a VPC, Resolver forwards all DNS queries
     * for the domain name that is specified in the rule and that originate in the VPC. The queries are forwarded to the
     * IP addresses for the DNS resolvers that are specified in the rule. For more information about rules, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverRule.html"
     * >CreateResolverRule</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateResolverRuleRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateResolverRuleRequest#builder()}
     * </p>
     *
     * @param associateResolverRuleRequest
     *        A {@link Consumer} that will call methods on {@link AssociateResolverRuleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateResolverRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>LimitExceededException The request caused one or more limits to be exceeded.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>ResourceUnavailableException The specified resource isn't available.</li>
     *         <li>ResourceExistsException The resource that you tried to create already exists.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.AssociateResolverRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/AssociateResolverRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateResolverRuleResponse> associateResolverRule(
            Consumer<AssociateResolverRuleRequest.Builder> associateResolverRuleRequest) {
        return associateResolverRule(AssociateResolverRuleRequest.builder().applyMutation(associateResolverRuleRequest).build());
    }

    /**
     * <p>
     * Creates a Resolver endpoint. There are two types of Resolver endpoints, inbound and outbound:
     * </p>
     * <ul>
     * <li>
     * <p>
     * An <i>inbound Resolver endpoint</i> forwards DNS queries to the DNS service for a VPC from your network.
     * </p>
     * </li>
     * <li>
     * <p>
     * An <i>outbound Resolver endpoint</i> forwards DNS queries from the DNS service for a VPC to your network.
     * </p>
     * </li>
     * </ul>
     *
     * @param createResolverEndpointRequest
     * @return A Java Future containing the result of the CreateResolverEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceExistsException The resource that you tried to create already exists.</li>
     *         <li>LimitExceededException The request caused one or more limits to be exceeded.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.CreateResolverEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateResolverEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateResolverEndpointResponse> createResolverEndpoint(
            CreateResolverEndpointRequest createResolverEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Resolver endpoint. There are two types of Resolver endpoints, inbound and outbound:
     * </p>
     * <ul>
     * <li>
     * <p>
     * An <i>inbound Resolver endpoint</i> forwards DNS queries to the DNS service for a VPC from your network.
     * </p>
     * </li>
     * <li>
     * <p>
     * An <i>outbound Resolver endpoint</i> forwards DNS queries from the DNS service for a VPC to your network.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResolverEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link CreateResolverEndpointRequest#builder()}
     * </p>
     *
     * @param createResolverEndpointRequest
     *        A {@link Consumer} that will call methods on {@link CreateResolverEndpointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateResolverEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceExistsException The resource that you tried to create already exists.</li>
     *         <li>LimitExceededException The request caused one or more limits to be exceeded.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.CreateResolverEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateResolverEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateResolverEndpointResponse> createResolverEndpoint(
            Consumer<CreateResolverEndpointRequest.Builder> createResolverEndpointRequest) {
        return createResolverEndpoint(CreateResolverEndpointRequest.builder().applyMutation(createResolverEndpointRequest)
                .build());
    }

    /**
     * <p>
     * Creates a Resolver query logging configuration, which defines where you want Resolver to save DNS query logs that
     * originate in your VPCs. Resolver can log queries only for VPCs that are in the same Region as the query logging
     * configuration.
     * </p>
     * <p>
     * To specify which VPCs you want to log queries for, you use <code>AssociateResolverQueryLogConfig</code>. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverQueryLogConfig.html"
     * >AssociateResolverQueryLogConfig</a>.
     * </p>
     * <p>
     * You can optionally use AWS Resource Access Manager (AWS RAM) to share a query logging configuration with other
     * AWS accounts. The other accounts can then associate VPCs with the configuration. The query logs that Resolver
     * creates for a configuration include all DNS queries that originate in all VPCs that are associated with the
     * configuration.
     * </p>
     *
     * @param createResolverQueryLogConfigRequest
     * @return A Java Future containing the result of the CreateResolverQueryLogConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceExistsException The resource that you tried to create already exists.</li>
     *         <li>LimitExceededException The request caused one or more limits to be exceeded.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.CreateResolverQueryLogConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateResolverQueryLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateResolverQueryLogConfigResponse> createResolverQueryLogConfig(
            CreateResolverQueryLogConfigRequest createResolverQueryLogConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Resolver query logging configuration, which defines where you want Resolver to save DNS query logs that
     * originate in your VPCs. Resolver can log queries only for VPCs that are in the same Region as the query logging
     * configuration.
     * </p>
     * <p>
     * To specify which VPCs you want to log queries for, you use <code>AssociateResolverQueryLogConfig</code>. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverQueryLogConfig.html"
     * >AssociateResolverQueryLogConfig</a>.
     * </p>
     * <p>
     * You can optionally use AWS Resource Access Manager (AWS RAM) to share a query logging configuration with other
     * AWS accounts. The other accounts can then associate VPCs with the configuration. The query logs that Resolver
     * creates for a configuration include all DNS queries that originate in all VPCs that are associated with the
     * configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResolverQueryLogConfigRequest.Builder}
     * avoiding the need to create one manually via {@link CreateResolverQueryLogConfigRequest#builder()}
     * </p>
     *
     * @param createResolverQueryLogConfigRequest
     *        A {@link Consumer} that will call methods on {@link CreateResolverQueryLogConfigRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateResolverQueryLogConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceExistsException The resource that you tried to create already exists.</li>
     *         <li>LimitExceededException The request caused one or more limits to be exceeded.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.CreateResolverQueryLogConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateResolverQueryLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateResolverQueryLogConfigResponse> createResolverQueryLogConfig(
            Consumer<CreateResolverQueryLogConfigRequest.Builder> createResolverQueryLogConfigRequest) {
        return createResolverQueryLogConfig(CreateResolverQueryLogConfigRequest.builder()
                .applyMutation(createResolverQueryLogConfigRequest).build());
    }

    /**
     * <p>
     * For DNS queries that originate in your VPCs, specifies which Resolver endpoint the queries pass through, one
     * domain name that you want to forward to your network, and the IP addresses of the DNS resolvers in your network.
     * </p>
     *
     * @param createResolverRuleRequest
     * @return A Java Future containing the result of the CreateResolverRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>LimitExceededException The request caused one or more limits to be exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ResourceExistsException The resource that you tried to create already exists.</li>
     *         <li>ResourceUnavailableException The specified resource isn't available.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.CreateResolverRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateResolverRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateResolverRuleResponse> createResolverRule(CreateResolverRuleRequest createResolverRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For DNS queries that originate in your VPCs, specifies which Resolver endpoint the queries pass through, one
     * domain name that you want to forward to your network, and the IP addresses of the DNS resolvers in your network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResolverRuleRequest.Builder} avoiding the
     * need to create one manually via {@link CreateResolverRuleRequest#builder()}
     * </p>
     *
     * @param createResolverRuleRequest
     *        A {@link Consumer} that will call methods on {@link CreateResolverRuleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateResolverRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>LimitExceededException The request caused one or more limits to be exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ResourceExistsException The resource that you tried to create already exists.</li>
     *         <li>ResourceUnavailableException The specified resource isn't available.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.CreateResolverRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateResolverRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateResolverRuleResponse> createResolverRule(
            Consumer<CreateResolverRuleRequest.Builder> createResolverRuleRequest) {
        return createResolverRule(CreateResolverRuleRequest.builder().applyMutation(createResolverRuleRequest).build());
    }

    /**
     * <p>
     * Deletes a Resolver endpoint. The effect of deleting a Resolver endpoint depends on whether it's an inbound or an
     * outbound Resolver endpoint:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Inbound</b>: DNS queries from your network are no longer routed to the DNS service for the specified VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Outbound</b>: DNS queries from a VPC are no longer routed to your network.
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteResolverEndpointRequest
     * @return A Java Future containing the result of the DeleteResolverEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.DeleteResolverEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteResolverEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResolverEndpointResponse> deleteResolverEndpoint(
            DeleteResolverEndpointRequest deleteResolverEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Resolver endpoint. The effect of deleting a Resolver endpoint depends on whether it's an inbound or an
     * outbound Resolver endpoint:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Inbound</b>: DNS queries from your network are no longer routed to the DNS service for the specified VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Outbound</b>: DNS queries from a VPC are no longer routed to your network.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResolverEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResolverEndpointRequest#builder()}
     * </p>
     *
     * @param deleteResolverEndpointRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResolverEndpointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteResolverEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.DeleteResolverEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteResolverEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResolverEndpointResponse> deleteResolverEndpoint(
            Consumer<DeleteResolverEndpointRequest.Builder> deleteResolverEndpointRequest) {
        return deleteResolverEndpoint(DeleteResolverEndpointRequest.builder().applyMutation(deleteResolverEndpointRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a query logging configuration. When you delete a configuration, Resolver stops logging DNS queries for
     * all of the Amazon VPCs that are associated with the configuration. This also applies if the query logging
     * configuration is shared with other AWS accounts, and the other accounts have associated VPCs with the shared
     * configuration.
     * </p>
     * <p>
     * Before you can delete a query logging configuration, you must first disassociate all VPCs from the configuration.
     * See <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html"
     * >DisassociateResolverQueryLogConfig</a>.
     * </p>
     * <p>
     * If you used Resource Access Manager (RAM) to share a query logging configuration with other accounts, you must
     * stop sharing the configuration before you can delete a configuration. The accounts that you shared the
     * configuration with can first disassociate VPCs that they associated with the configuration, but that's not
     * necessary. If you stop sharing the configuration, those VPCs are automatically disassociated from the
     * configuration.
     * </p>
     *
     * @param deleteResolverQueryLogConfigRequest
     * @return A Java Future containing the result of the DeleteResolverQueryLogConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.DeleteResolverQueryLogConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteResolverQueryLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResolverQueryLogConfigResponse> deleteResolverQueryLogConfig(
            DeleteResolverQueryLogConfigRequest deleteResolverQueryLogConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a query logging configuration. When you delete a configuration, Resolver stops logging DNS queries for
     * all of the Amazon VPCs that are associated with the configuration. This also applies if the query logging
     * configuration is shared with other AWS accounts, and the other accounts have associated VPCs with the shared
     * configuration.
     * </p>
     * <p>
     * Before you can delete a query logging configuration, you must first disassociate all VPCs from the configuration.
     * See <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html"
     * >DisassociateResolverQueryLogConfig</a>.
     * </p>
     * <p>
     * If you used Resource Access Manager (RAM) to share a query logging configuration with other accounts, you must
     * stop sharing the configuration before you can delete a configuration. The accounts that you shared the
     * configuration with can first disassociate VPCs that they associated with the configuration, but that's not
     * necessary. If you stop sharing the configuration, those VPCs are automatically disassociated from the
     * configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResolverQueryLogConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteResolverQueryLogConfigRequest#builder()}
     * </p>
     *
     * @param deleteResolverQueryLogConfigRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResolverQueryLogConfigRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteResolverQueryLogConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.DeleteResolverQueryLogConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteResolverQueryLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResolverQueryLogConfigResponse> deleteResolverQueryLogConfig(
            Consumer<DeleteResolverQueryLogConfigRequest.Builder> deleteResolverQueryLogConfigRequest) {
        return deleteResolverQueryLogConfig(DeleteResolverQueryLogConfigRequest.builder()
                .applyMutation(deleteResolverQueryLogConfigRequest).build());
    }

    /**
     * <p>
     * Deletes a Resolver rule. Before you can delete a Resolver rule, you must disassociate it from all the VPCs that
     * you associated the Resolver rule with. For more information, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverRule.html"
     * >DisassociateResolverRule</a>.
     * </p>
     *
     * @param deleteResolverRuleRequest
     * @return A Java Future containing the result of the DeleteResolverRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ResourceInUseException The resource that you tried to update or delete is currently in use.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.DeleteResolverRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteResolverRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResolverRuleResponse> deleteResolverRule(DeleteResolverRuleRequest deleteResolverRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Resolver rule. Before you can delete a Resolver rule, you must disassociate it from all the VPCs that
     * you associated the Resolver rule with. For more information, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverRule.html"
     * >DisassociateResolverRule</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResolverRuleRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResolverRuleRequest#builder()}
     * </p>
     *
     * @param deleteResolverRuleRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResolverRuleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteResolverRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ResourceInUseException The resource that you tried to update or delete is currently in use.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.DeleteResolverRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteResolverRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResolverRuleResponse> deleteResolverRule(
            Consumer<DeleteResolverRuleRequest.Builder> deleteResolverRuleRequest) {
        return deleteResolverRule(DeleteResolverRuleRequest.builder().applyMutation(deleteResolverRuleRequest).build());
    }

    /**
     * <p>
     * Removes IP addresses from an inbound or an outbound Resolver endpoint. If you want to remove more than one IP
     * address, submit one <code>DisassociateResolverEndpointIpAddress</code> request for each IP address.
     * </p>
     * <p>
     * To add an IP address to an endpoint, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverEndpointIpAddress.html"
     * >AssociateResolverEndpointIpAddress</a>.
     * </p>
     *
     * @param disassociateResolverEndpointIpAddressRequest
     * @return A Java Future containing the result of the DisassociateResolverEndpointIpAddress operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceExistsException The resource that you tried to create already exists.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.DisassociateResolverEndpointIpAddress
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DisassociateResolverEndpointIpAddress"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateResolverEndpointIpAddressResponse> disassociateResolverEndpointIpAddress(
            DisassociateResolverEndpointIpAddressRequest disassociateResolverEndpointIpAddressRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes IP addresses from an inbound or an outbound Resolver endpoint. If you want to remove more than one IP
     * address, submit one <code>DisassociateResolverEndpointIpAddress</code> request for each IP address.
     * </p>
     * <p>
     * To add an IP address to an endpoint, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverEndpointIpAddress.html"
     * >AssociateResolverEndpointIpAddress</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateResolverEndpointIpAddressRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateResolverEndpointIpAddressRequest#builder()}
     * </p>
     *
     * @param disassociateResolverEndpointIpAddressRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateResolverEndpointIpAddressRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DisassociateResolverEndpointIpAddress operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceExistsException The resource that you tried to create already exists.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.DisassociateResolverEndpointIpAddress
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DisassociateResolverEndpointIpAddress"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateResolverEndpointIpAddressResponse> disassociateResolverEndpointIpAddress(
            Consumer<DisassociateResolverEndpointIpAddressRequest.Builder> disassociateResolverEndpointIpAddressRequest) {
        return disassociateResolverEndpointIpAddress(DisassociateResolverEndpointIpAddressRequest.builder()
                .applyMutation(disassociateResolverEndpointIpAddressRequest).build());
    }

    /**
     * <p>
     * Disassociates a VPC from a query logging configuration.
     * </p>
     * <note>
     * <p>
     * Before you can delete a query logging configuration, you must first disassociate all VPCs from the configuration.
     * If you used Resource Access Manager (RAM) to share a query logging configuration with other accounts, VPCs can be
     * disassociated from the configuration in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The accounts that you shared the configuration with can disassociate VPCs from the configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can stop sharing the configuration.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param disassociateResolverQueryLogConfigRequest
     * @return A Java Future containing the result of the DisassociateResolverQueryLogConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.DisassociateResolverQueryLogConfig
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DisassociateResolverQueryLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateResolverQueryLogConfigResponse> disassociateResolverQueryLogConfig(
            DisassociateResolverQueryLogConfigRequest disassociateResolverQueryLogConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a VPC from a query logging configuration.
     * </p>
     * <note>
     * <p>
     * Before you can delete a query logging configuration, you must first disassociate all VPCs from the configuration.
     * If you used Resource Access Manager (RAM) to share a query logging configuration with other accounts, VPCs can be
     * disassociated from the configuration in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The accounts that you shared the configuration with can disassociate VPCs from the configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can stop sharing the configuration.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateResolverQueryLogConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateResolverQueryLogConfigRequest#builder()}
     * </p>
     *
     * @param disassociateResolverQueryLogConfigRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateResolverQueryLogConfigRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateResolverQueryLogConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.DisassociateResolverQueryLogConfig
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DisassociateResolverQueryLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateResolverQueryLogConfigResponse> disassociateResolverQueryLogConfig(
            Consumer<DisassociateResolverQueryLogConfigRequest.Builder> disassociateResolverQueryLogConfigRequest) {
        return disassociateResolverQueryLogConfig(DisassociateResolverQueryLogConfigRequest.builder()
                .applyMutation(disassociateResolverQueryLogConfigRequest).build());
    }

    /**
     * <p>
     * Removes the association between a specified Resolver rule and a specified VPC.
     * </p>
     * <important>
     * <p>
     * If you disassociate a Resolver rule from a VPC, Resolver stops forwarding DNS queries for the domain name that
     * you specified in the Resolver rule.
     * </p>
     * </important>
     *
     * @param disassociateResolverRuleRequest
     * @return A Java Future containing the result of the DisassociateResolverRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.DisassociateResolverRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DisassociateResolverRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateResolverRuleResponse> disassociateResolverRule(
            DisassociateResolverRuleRequest disassociateResolverRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the association between a specified Resolver rule and a specified VPC.
     * </p>
     * <important>
     * <p>
     * If you disassociate a Resolver rule from a VPC, Resolver stops forwarding DNS queries for the domain name that
     * you specified in the Resolver rule.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateResolverRuleRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateResolverRuleRequest#builder()}
     * </p>
     *
     * @param disassociateResolverRuleRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateResolverRuleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateResolverRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.DisassociateResolverRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DisassociateResolverRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateResolverRuleResponse> disassociateResolverRule(
            Consumer<DisassociateResolverRuleRequest.Builder> disassociateResolverRuleRequest) {
        return disassociateResolverRule(DisassociateResolverRuleRequest.builder().applyMutation(disassociateResolverRuleRequest)
                .build());
    }

    /**
     * <p>
     * Gets DNSSEC validation information for a specified resource.
     * </p>
     *
     * @param getResolverDnssecConfigRequest
     * @return A Java Future containing the result of the GetResolverDnssecConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.GetResolverDnssecConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverDnssecConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResolverDnssecConfigResponse> getResolverDnssecConfig(
            GetResolverDnssecConfigRequest getResolverDnssecConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets DNSSEC validation information for a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResolverDnssecConfigRequest.Builder} avoiding
     * the need to create one manually via {@link GetResolverDnssecConfigRequest#builder()}
     * </p>
     *
     * @param getResolverDnssecConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetResolverDnssecConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetResolverDnssecConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.GetResolverDnssecConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverDnssecConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResolverDnssecConfigResponse> getResolverDnssecConfig(
            Consumer<GetResolverDnssecConfigRequest.Builder> getResolverDnssecConfigRequest) {
        return getResolverDnssecConfig(GetResolverDnssecConfigRequest.builder().applyMutation(getResolverDnssecConfigRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about a specified Resolver endpoint, such as whether it's an inbound or an outbound Resolver
     * endpoint, and the current status of the endpoint.
     * </p>
     *
     * @param getResolverEndpointRequest
     * @return A Java Future containing the result of the GetResolverEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.GetResolverEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResolverEndpointResponse> getResolverEndpoint(
            GetResolverEndpointRequest getResolverEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specified Resolver endpoint, such as whether it's an inbound or an outbound Resolver
     * endpoint, and the current status of the endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResolverEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link GetResolverEndpointRequest#builder()}
     * </p>
     *
     * @param getResolverEndpointRequest
     *        A {@link Consumer} that will call methods on {@link GetResolverEndpointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetResolverEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.GetResolverEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResolverEndpointResponse> getResolverEndpoint(
            Consumer<GetResolverEndpointRequest.Builder> getResolverEndpointRequest) {
        return getResolverEndpoint(GetResolverEndpointRequest.builder().applyMutation(getResolverEndpointRequest).build());
    }

    /**
     * <p>
     * Gets information about a specified Resolver query logging configuration, such as the number of VPCs that the
     * configuration is logging queries for and the location that logs are sent to.
     * </p>
     *
     * @param getResolverQueryLogConfigRequest
     * @return A Java Future containing the result of the GetResolverQueryLogConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.GetResolverQueryLogConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverQueryLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResolverQueryLogConfigResponse> getResolverQueryLogConfig(
            GetResolverQueryLogConfigRequest getResolverQueryLogConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specified Resolver query logging configuration, such as the number of VPCs that the
     * configuration is logging queries for and the location that logs are sent to.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResolverQueryLogConfigRequest.Builder} avoiding
     * the need to create one manually via {@link GetResolverQueryLogConfigRequest#builder()}
     * </p>
     *
     * @param getResolverQueryLogConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetResolverQueryLogConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetResolverQueryLogConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.GetResolverQueryLogConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverQueryLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResolverQueryLogConfigResponse> getResolverQueryLogConfig(
            Consumer<GetResolverQueryLogConfigRequest.Builder> getResolverQueryLogConfigRequest) {
        return getResolverQueryLogConfig(GetResolverQueryLogConfigRequest.builder()
                .applyMutation(getResolverQueryLogConfigRequest).build());
    }

    /**
     * <p>
     * Gets information about a specified association between a Resolver query logging configuration and an Amazon VPC.
     * When you associate a VPC with a query logging configuration, Resolver logs DNS queries that originate in that
     * VPC.
     * </p>
     *
     * @param getResolverQueryLogConfigAssociationRequest
     * @return A Java Future containing the result of the GetResolverQueryLogConfigAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.GetResolverQueryLogConfigAssociation
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverQueryLogConfigAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResolverQueryLogConfigAssociationResponse> getResolverQueryLogConfigAssociation(
            GetResolverQueryLogConfigAssociationRequest getResolverQueryLogConfigAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specified association between a Resolver query logging configuration and an Amazon VPC.
     * When you associate a VPC with a query logging configuration, Resolver logs DNS queries that originate in that
     * VPC.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetResolverQueryLogConfigAssociationRequest.Builder} avoiding the need to create one manually via
     * {@link GetResolverQueryLogConfigAssociationRequest#builder()}
     * </p>
     *
     * @param getResolverQueryLogConfigAssociationRequest
     *        A {@link Consumer} that will call methods on {@link GetResolverQueryLogConfigAssociationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetResolverQueryLogConfigAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.GetResolverQueryLogConfigAssociation
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverQueryLogConfigAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResolverQueryLogConfigAssociationResponse> getResolverQueryLogConfigAssociation(
            Consumer<GetResolverQueryLogConfigAssociationRequest.Builder> getResolverQueryLogConfigAssociationRequest) {
        return getResolverQueryLogConfigAssociation(GetResolverQueryLogConfigAssociationRequest.builder()
                .applyMutation(getResolverQueryLogConfigAssociationRequest).build());
    }

    /**
     * <p>
     * Gets information about a query logging policy. A query logging policy specifies the Resolver query logging
     * operations and resources that you want to allow another AWS account to be able to use.
     * </p>
     *
     * @param getResolverQueryLogConfigPolicyRequest
     * @return A Java Future containing the result of the GetResolverQueryLogConfigPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>UnknownResourceException The specified resource doesn't exist.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.GetResolverQueryLogConfigPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverQueryLogConfigPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResolverQueryLogConfigPolicyResponse> getResolverQueryLogConfigPolicy(
            GetResolverQueryLogConfigPolicyRequest getResolverQueryLogConfigPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a query logging policy. A query logging policy specifies the Resolver query logging
     * operations and resources that you want to allow another AWS account to be able to use.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResolverQueryLogConfigPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link GetResolverQueryLogConfigPolicyRequest#builder()}
     * </p>
     *
     * @param getResolverQueryLogConfigPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetResolverQueryLogConfigPolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetResolverQueryLogConfigPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>UnknownResourceException The specified resource doesn't exist.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.GetResolverQueryLogConfigPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverQueryLogConfigPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResolverQueryLogConfigPolicyResponse> getResolverQueryLogConfigPolicy(
            Consumer<GetResolverQueryLogConfigPolicyRequest.Builder> getResolverQueryLogConfigPolicyRequest) {
        return getResolverQueryLogConfigPolicy(GetResolverQueryLogConfigPolicyRequest.builder()
                .applyMutation(getResolverQueryLogConfigPolicyRequest).build());
    }

    /**
     * <p>
     * Gets information about a specified Resolver rule, such as the domain name that the rule forwards DNS queries for
     * and the ID of the outbound Resolver endpoint that the rule is associated with.
     * </p>
     *
     * @param getResolverRuleRequest
     * @return A Java Future containing the result of the GetResolverRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.GetResolverRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResolverRuleResponse> getResolverRule(GetResolverRuleRequest getResolverRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specified Resolver rule, such as the domain name that the rule forwards DNS queries for
     * and the ID of the outbound Resolver endpoint that the rule is associated with.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResolverRuleRequest.Builder} avoiding the need
     * to create one manually via {@link GetResolverRuleRequest#builder()}
     * </p>
     *
     * @param getResolverRuleRequest
     *        A {@link Consumer} that will call methods on {@link GetResolverRuleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetResolverRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.GetResolverRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResolverRuleResponse> getResolverRule(
            Consumer<GetResolverRuleRequest.Builder> getResolverRuleRequest) {
        return getResolverRule(GetResolverRuleRequest.builder().applyMutation(getResolverRuleRequest).build());
    }

    /**
     * <p>
     * Gets information about an association between a specified Resolver rule and a VPC. You associate a Resolver rule
     * and a VPC using <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html"
     * >AssociateResolverRule</a>.
     * </p>
     *
     * @param getResolverRuleAssociationRequest
     * @return A Java Future containing the result of the GetResolverRuleAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.GetResolverRuleAssociation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRuleAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResolverRuleAssociationResponse> getResolverRuleAssociation(
            GetResolverRuleAssociationRequest getResolverRuleAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an association between a specified Resolver rule and a VPC. You associate a Resolver rule
     * and a VPC using <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html"
     * >AssociateResolverRule</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResolverRuleAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link GetResolverRuleAssociationRequest#builder()}
     * </p>
     *
     * @param getResolverRuleAssociationRequest
     *        A {@link Consumer} that will call methods on {@link GetResolverRuleAssociationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetResolverRuleAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.GetResolverRuleAssociation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRuleAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResolverRuleAssociationResponse> getResolverRuleAssociation(
            Consumer<GetResolverRuleAssociationRequest.Builder> getResolverRuleAssociationRequest) {
        return getResolverRuleAssociation(GetResolverRuleAssociationRequest.builder()
                .applyMutation(getResolverRuleAssociationRequest).build());
    }

    /**
     * <p>
     * Gets information about the Resolver rule policy for a specified rule. A Resolver rule policy includes the rule
     * that you want to share with another account, the account that you want to share the rule with, and the Resolver
     * operations that you want to allow the account to use.
     * </p>
     *
     * @param getResolverRulePolicyRequest
     * @return A Java Future containing the result of the GetResolverRulePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>UnknownResourceException The specified resource doesn't exist.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.GetResolverRulePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRulePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResolverRulePolicyResponse> getResolverRulePolicy(
            GetResolverRulePolicyRequest getResolverRulePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the Resolver rule policy for a specified rule. A Resolver rule policy includes the rule
     * that you want to share with another account, the account that you want to share the rule with, and the Resolver
     * operations that you want to allow the account to use.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResolverRulePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetResolverRulePolicyRequest#builder()}
     * </p>
     *
     * @param getResolverRulePolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetResolverRulePolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetResolverRulePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>UnknownResourceException The specified resource doesn't exist.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.GetResolverRulePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRulePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResolverRulePolicyResponse> getResolverRulePolicy(
            Consumer<GetResolverRulePolicyRequest.Builder> getResolverRulePolicyRequest) {
        return getResolverRulePolicy(GetResolverRulePolicyRequest.builder().applyMutation(getResolverRulePolicyRequest).build());
    }

    /**
     * <p>
     * Lists the configurations for DNSSEC validation that are associated with the current AWS account.
     * </p>
     *
     * @param listResolverDnssecConfigsRequest
     * @return A Java Future containing the result of the ListResolverDnssecConfigs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverDnssecConfigs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverDnssecConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResolverDnssecConfigsResponse> listResolverDnssecConfigs(
            ListResolverDnssecConfigsRequest listResolverDnssecConfigsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the configurations for DNSSEC validation that are associated with the current AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResolverDnssecConfigsRequest.Builder} avoiding
     * the need to create one manually via {@link ListResolverDnssecConfigsRequest#builder()}
     * </p>
     *
     * @param listResolverDnssecConfigsRequest
     *        A {@link Consumer} that will call methods on {@link ListResolverDnssecConfigsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListResolverDnssecConfigs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverDnssecConfigs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverDnssecConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResolverDnssecConfigsResponse> listResolverDnssecConfigs(
            Consumer<ListResolverDnssecConfigsRequest.Builder> listResolverDnssecConfigsRequest) {
        return listResolverDnssecConfigs(ListResolverDnssecConfigsRequest.builder()
                .applyMutation(listResolverDnssecConfigsRequest).build());
    }

    /**
     * <p>
     * Lists the configurations for DNSSEC validation that are associated with the current AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResolverDnssecConfigs(software.amazon.awssdk.services.route53resolver.model.ListResolverDnssecConfigsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverDnssecConfigsPublisher publisher = client.listResolverDnssecConfigsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverDnssecConfigsPublisher publisher = client.listResolverDnssecConfigsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53resolver.model.ListResolverDnssecConfigsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53resolver.model.ListResolverDnssecConfigsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolverDnssecConfigs(software.amazon.awssdk.services.route53resolver.model.ListResolverDnssecConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResolverDnssecConfigsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverDnssecConfigs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverDnssecConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverDnssecConfigsPublisher listResolverDnssecConfigsPaginator(
            ListResolverDnssecConfigsRequest listResolverDnssecConfigsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the configurations for DNSSEC validation that are associated with the current AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResolverDnssecConfigs(software.amazon.awssdk.services.route53resolver.model.ListResolverDnssecConfigsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverDnssecConfigsPublisher publisher = client.listResolverDnssecConfigsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverDnssecConfigsPublisher publisher = client.listResolverDnssecConfigsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53resolver.model.ListResolverDnssecConfigsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53resolver.model.ListResolverDnssecConfigsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolverDnssecConfigs(software.amazon.awssdk.services.route53resolver.model.ListResolverDnssecConfigsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResolverDnssecConfigsRequest.Builder} avoiding
     * the need to create one manually via {@link ListResolverDnssecConfigsRequest#builder()}
     * </p>
     *
     * @param listResolverDnssecConfigsRequest
     *        A {@link Consumer} that will call methods on {@link ListResolverDnssecConfigsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverDnssecConfigs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverDnssecConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverDnssecConfigsPublisher listResolverDnssecConfigsPaginator(
            Consumer<ListResolverDnssecConfigsRequest.Builder> listResolverDnssecConfigsRequest) {
        return listResolverDnssecConfigsPaginator(ListResolverDnssecConfigsRequest.builder()
                .applyMutation(listResolverDnssecConfigsRequest).build());
    }

    /**
     * <p>
     * Gets the IP addresses for a specified Resolver endpoint.
     * </p>
     *
     * @param listResolverEndpointIpAddressesRequest
     * @return A Java Future containing the result of the ListResolverEndpointIpAddresses operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverEndpointIpAddresses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverEndpointIpAddresses"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResolverEndpointIpAddressesResponse> listResolverEndpointIpAddresses(
            ListResolverEndpointIpAddressesRequest listResolverEndpointIpAddressesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the IP addresses for a specified Resolver endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResolverEndpointIpAddressesRequest.Builder}
     * avoiding the need to create one manually via {@link ListResolverEndpointIpAddressesRequest#builder()}
     * </p>
     *
     * @param listResolverEndpointIpAddressesRequest
     *        A {@link Consumer} that will call methods on {@link ListResolverEndpointIpAddressesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListResolverEndpointIpAddresses operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverEndpointIpAddresses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverEndpointIpAddresses"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResolverEndpointIpAddressesResponse> listResolverEndpointIpAddresses(
            Consumer<ListResolverEndpointIpAddressesRequest.Builder> listResolverEndpointIpAddressesRequest) {
        return listResolverEndpointIpAddresses(ListResolverEndpointIpAddressesRequest.builder()
                .applyMutation(listResolverEndpointIpAddressesRequest).build());
    }

    /**
     * <p>
     * Gets the IP addresses for a specified Resolver endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResolverEndpointIpAddresses(software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverEndpointIpAddressesPublisher publisher = client.listResolverEndpointIpAddressesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverEndpointIpAddressesPublisher publisher = client.listResolverEndpointIpAddressesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolverEndpointIpAddresses(software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResolverEndpointIpAddressesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverEndpointIpAddresses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverEndpointIpAddresses"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverEndpointIpAddressesPublisher listResolverEndpointIpAddressesPaginator(
            ListResolverEndpointIpAddressesRequest listResolverEndpointIpAddressesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the IP addresses for a specified Resolver endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResolverEndpointIpAddresses(software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverEndpointIpAddressesPublisher publisher = client.listResolverEndpointIpAddressesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverEndpointIpAddressesPublisher publisher = client.listResolverEndpointIpAddressesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolverEndpointIpAddresses(software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResolverEndpointIpAddressesRequest.Builder}
     * avoiding the need to create one manually via {@link ListResolverEndpointIpAddressesRequest#builder()}
     * </p>
     *
     * @param listResolverEndpointIpAddressesRequest
     *        A {@link Consumer} that will call methods on {@link ListResolverEndpointIpAddressesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverEndpointIpAddresses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverEndpointIpAddresses"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverEndpointIpAddressesPublisher listResolverEndpointIpAddressesPaginator(
            Consumer<ListResolverEndpointIpAddressesRequest.Builder> listResolverEndpointIpAddressesRequest) {
        return listResolverEndpointIpAddressesPaginator(ListResolverEndpointIpAddressesRequest.builder()
                .applyMutation(listResolverEndpointIpAddressesRequest).build());
    }

    /**
     * <p>
     * Lists all the Resolver endpoints that were created using the current AWS account.
     * </p>
     *
     * @param listResolverEndpointsRequest
     * @return A Java Future containing the result of the ListResolverEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResolverEndpointsResponse> listResolverEndpoints(
            ListResolverEndpointsRequest listResolverEndpointsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the Resolver endpoints that were created using the current AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResolverEndpointsRequest.Builder} avoiding the
     * need to create one manually via {@link ListResolverEndpointsRequest#builder()}
     * </p>
     *
     * @param listResolverEndpointsRequest
     *        A {@link Consumer} that will call methods on {@link ListResolverEndpointsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListResolverEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResolverEndpointsResponse> listResolverEndpoints(
            Consumer<ListResolverEndpointsRequest.Builder> listResolverEndpointsRequest) {
        return listResolverEndpoints(ListResolverEndpointsRequest.builder().applyMutation(listResolverEndpointsRequest).build());
    }

    /**
     * <p>
     * Lists all the Resolver endpoints that were created using the current AWS account.
     * </p>
     *
     * @return A Java Future containing the result of the ListResolverEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResolverEndpointsResponse> listResolverEndpoints() {
        return listResolverEndpoints(ListResolverEndpointsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all the Resolver endpoints that were created using the current AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResolverEndpoints(software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverEndpointsPublisher publisher = client.listResolverEndpointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverEndpointsPublisher publisher = client.listResolverEndpointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolverEndpoints(software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverEndpointsPublisher listResolverEndpointsPaginator() {
        return listResolverEndpointsPaginator(ListResolverEndpointsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all the Resolver endpoints that were created using the current AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResolverEndpoints(software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverEndpointsPublisher publisher = client.listResolverEndpointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverEndpointsPublisher publisher = client.listResolverEndpointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolverEndpoints(software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResolverEndpointsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverEndpointsPublisher listResolverEndpointsPaginator(
            ListResolverEndpointsRequest listResolverEndpointsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the Resolver endpoints that were created using the current AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResolverEndpoints(software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverEndpointsPublisher publisher = client.listResolverEndpointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverEndpointsPublisher publisher = client.listResolverEndpointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolverEndpoints(software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResolverEndpointsRequest.Builder} avoiding the
     * need to create one manually via {@link ListResolverEndpointsRequest#builder()}
     * </p>
     *
     * @param listResolverEndpointsRequest
     *        A {@link Consumer} that will call methods on {@link ListResolverEndpointsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverEndpointsPublisher listResolverEndpointsPaginator(
            Consumer<ListResolverEndpointsRequest.Builder> listResolverEndpointsRequest) {
        return listResolverEndpointsPaginator(ListResolverEndpointsRequest.builder().applyMutation(listResolverEndpointsRequest)
                .build());
    }

    /**
     * <p>
     * Lists information about associations between Amazon VPCs and query logging configurations.
     * </p>
     *
     * @param listResolverQueryLogConfigAssociationsRequest
     * @return A Java Future containing the result of the ListResolverQueryLogConfigAssociations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>LimitExceededException The request caused one or more limits to be exceeded.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverQueryLogConfigAssociations
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverQueryLogConfigAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResolverQueryLogConfigAssociationsResponse> listResolverQueryLogConfigAssociations(
            ListResolverQueryLogConfigAssociationsRequest listResolverQueryLogConfigAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about associations between Amazon VPCs and query logging configurations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListResolverQueryLogConfigAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListResolverQueryLogConfigAssociationsRequest#builder()}
     * </p>
     *
     * @param listResolverQueryLogConfigAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link ListResolverQueryLogConfigAssociationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListResolverQueryLogConfigAssociations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>LimitExceededException The request caused one or more limits to be exceeded.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverQueryLogConfigAssociations
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverQueryLogConfigAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResolverQueryLogConfigAssociationsResponse> listResolverQueryLogConfigAssociations(
            Consumer<ListResolverQueryLogConfigAssociationsRequest.Builder> listResolverQueryLogConfigAssociationsRequest) {
        return listResolverQueryLogConfigAssociations(ListResolverQueryLogConfigAssociationsRequest.builder()
                .applyMutation(listResolverQueryLogConfigAssociationsRequest).build());
    }

    /**
     * <p>
     * Lists information about associations between Amazon VPCs and query logging configurations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResolverQueryLogConfigAssociations(software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverQueryLogConfigAssociationsPublisher publisher = client.listResolverQueryLogConfigAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverQueryLogConfigAssociationsPublisher publisher = client.listResolverQueryLogConfigAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolverQueryLogConfigAssociations(software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResolverQueryLogConfigAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>LimitExceededException The request caused one or more limits to be exceeded.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverQueryLogConfigAssociations
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverQueryLogConfigAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverQueryLogConfigAssociationsPublisher listResolverQueryLogConfigAssociationsPaginator(
            ListResolverQueryLogConfigAssociationsRequest listResolverQueryLogConfigAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about associations between Amazon VPCs and query logging configurations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResolverQueryLogConfigAssociations(software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverQueryLogConfigAssociationsPublisher publisher = client.listResolverQueryLogConfigAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverQueryLogConfigAssociationsPublisher publisher = client.listResolverQueryLogConfigAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolverQueryLogConfigAssociations(software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigAssociationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListResolverQueryLogConfigAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListResolverQueryLogConfigAssociationsRequest#builder()}
     * </p>
     *
     * @param listResolverQueryLogConfigAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link ListResolverQueryLogConfigAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>LimitExceededException The request caused one or more limits to be exceeded.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverQueryLogConfigAssociations
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverQueryLogConfigAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverQueryLogConfigAssociationsPublisher listResolverQueryLogConfigAssociationsPaginator(
            Consumer<ListResolverQueryLogConfigAssociationsRequest.Builder> listResolverQueryLogConfigAssociationsRequest) {
        return listResolverQueryLogConfigAssociationsPaginator(ListResolverQueryLogConfigAssociationsRequest.builder()
                .applyMutation(listResolverQueryLogConfigAssociationsRequest).build());
    }

    /**
     * <p>
     * Lists information about the specified query logging configurations. Each configuration defines where you want
     * Resolver to save DNS query logs and specifies the VPCs that you want to log queries for.
     * </p>
     *
     * @param listResolverQueryLogConfigsRequest
     * @return A Java Future containing the result of the ListResolverQueryLogConfigs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverQueryLogConfigs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverQueryLogConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResolverQueryLogConfigsResponse> listResolverQueryLogConfigs(
            ListResolverQueryLogConfigsRequest listResolverQueryLogConfigsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about the specified query logging configurations. Each configuration defines where you want
     * Resolver to save DNS query logs and specifies the VPCs that you want to log queries for.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResolverQueryLogConfigsRequest.Builder}
     * avoiding the need to create one manually via {@link ListResolverQueryLogConfigsRequest#builder()}
     * </p>
     *
     * @param listResolverQueryLogConfigsRequest
     *        A {@link Consumer} that will call methods on {@link ListResolverQueryLogConfigsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListResolverQueryLogConfigs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverQueryLogConfigs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverQueryLogConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResolverQueryLogConfigsResponse> listResolverQueryLogConfigs(
            Consumer<ListResolverQueryLogConfigsRequest.Builder> listResolverQueryLogConfigsRequest) {
        return listResolverQueryLogConfigs(ListResolverQueryLogConfigsRequest.builder()
                .applyMutation(listResolverQueryLogConfigsRequest).build());
    }

    /**
     * <p>
     * Lists information about the specified query logging configurations. Each configuration defines where you want
     * Resolver to save DNS query logs and specifies the VPCs that you want to log queries for.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResolverQueryLogConfigs(software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverQueryLogConfigsPublisher publisher = client.listResolverQueryLogConfigsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverQueryLogConfigsPublisher publisher = client.listResolverQueryLogConfigsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolverQueryLogConfigs(software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResolverQueryLogConfigsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverQueryLogConfigs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverQueryLogConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverQueryLogConfigsPublisher listResolverQueryLogConfigsPaginator(
            ListResolverQueryLogConfigsRequest listResolverQueryLogConfigsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about the specified query logging configurations. Each configuration defines where you want
     * Resolver to save DNS query logs and specifies the VPCs that you want to log queries for.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResolverQueryLogConfigs(software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverQueryLogConfigsPublisher publisher = client.listResolverQueryLogConfigsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverQueryLogConfigsPublisher publisher = client.listResolverQueryLogConfigsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolverQueryLogConfigs(software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResolverQueryLogConfigsRequest.Builder}
     * avoiding the need to create one manually via {@link ListResolverQueryLogConfigsRequest#builder()}
     * </p>
     *
     * @param listResolverQueryLogConfigsRequest
     *        A {@link Consumer} that will call methods on {@link ListResolverQueryLogConfigsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverQueryLogConfigs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverQueryLogConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverQueryLogConfigsPublisher listResolverQueryLogConfigsPaginator(
            Consumer<ListResolverQueryLogConfigsRequest.Builder> listResolverQueryLogConfigsRequest) {
        return listResolverQueryLogConfigsPaginator(ListResolverQueryLogConfigsRequest.builder()
                .applyMutation(listResolverQueryLogConfigsRequest).build());
    }

    /**
     * <p>
     * Lists the associations that were created between Resolver rules and VPCs using the current AWS account.
     * </p>
     *
     * @param listResolverRuleAssociationsRequest
     * @return A Java Future containing the result of the ListResolverRuleAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverRuleAssociations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRuleAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResolverRuleAssociationsResponse> listResolverRuleAssociations(
            ListResolverRuleAssociationsRequest listResolverRuleAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the associations that were created between Resolver rules and VPCs using the current AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResolverRuleAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListResolverRuleAssociationsRequest#builder()}
     * </p>
     *
     * @param listResolverRuleAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link ListResolverRuleAssociationsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListResolverRuleAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverRuleAssociations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRuleAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResolverRuleAssociationsResponse> listResolverRuleAssociations(
            Consumer<ListResolverRuleAssociationsRequest.Builder> listResolverRuleAssociationsRequest) {
        return listResolverRuleAssociations(ListResolverRuleAssociationsRequest.builder()
                .applyMutation(listResolverRuleAssociationsRequest).build());
    }

    /**
     * <p>
     * Lists the associations that were created between Resolver rules and VPCs using the current AWS account.
     * </p>
     *
     * @return A Java Future containing the result of the ListResolverRuleAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverRuleAssociations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRuleAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResolverRuleAssociationsResponse> listResolverRuleAssociations() {
        return listResolverRuleAssociations(ListResolverRuleAssociationsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the associations that were created between Resolver rules and VPCs using the current AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResolverRuleAssociations(software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverRuleAssociationsPublisher publisher = client.listResolverRuleAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverRuleAssociationsPublisher publisher = client.listResolverRuleAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolverRuleAssociations(software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverRuleAssociations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRuleAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverRuleAssociationsPublisher listResolverRuleAssociationsPaginator() {
        return listResolverRuleAssociationsPaginator(ListResolverRuleAssociationsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the associations that were created between Resolver rules and VPCs using the current AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResolverRuleAssociations(software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverRuleAssociationsPublisher publisher = client.listResolverRuleAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverRuleAssociationsPublisher publisher = client.listResolverRuleAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolverRuleAssociations(software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResolverRuleAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverRuleAssociations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRuleAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverRuleAssociationsPublisher listResolverRuleAssociationsPaginator(
            ListResolverRuleAssociationsRequest listResolverRuleAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the associations that were created between Resolver rules and VPCs using the current AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResolverRuleAssociations(software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverRuleAssociationsPublisher publisher = client.listResolverRuleAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverRuleAssociationsPublisher publisher = client.listResolverRuleAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolverRuleAssociations(software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResolverRuleAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListResolverRuleAssociationsRequest#builder()}
     * </p>
     *
     * @param listResolverRuleAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link ListResolverRuleAssociationsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverRuleAssociations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRuleAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverRuleAssociationsPublisher listResolverRuleAssociationsPaginator(
            Consumer<ListResolverRuleAssociationsRequest.Builder> listResolverRuleAssociationsRequest) {
        return listResolverRuleAssociationsPaginator(ListResolverRuleAssociationsRequest.builder()
                .applyMutation(listResolverRuleAssociationsRequest).build());
    }

    /**
     * <p>
     * Lists the Resolver rules that were created using the current AWS account.
     * </p>
     *
     * @param listResolverRulesRequest
     * @return A Java Future containing the result of the ListResolverRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverRules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResolverRulesResponse> listResolverRules(ListResolverRulesRequest listResolverRulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Resolver rules that were created using the current AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResolverRulesRequest.Builder} avoiding the need
     * to create one manually via {@link ListResolverRulesRequest#builder()}
     * </p>
     *
     * @param listResolverRulesRequest
     *        A {@link Consumer} that will call methods on {@link ListResolverRulesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListResolverRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverRules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResolverRulesResponse> listResolverRules(
            Consumer<ListResolverRulesRequest.Builder> listResolverRulesRequest) {
        return listResolverRules(ListResolverRulesRequest.builder().applyMutation(listResolverRulesRequest).build());
    }

    /**
     * <p>
     * Lists the Resolver rules that were created using the current AWS account.
     * </p>
     *
     * @return A Java Future containing the result of the ListResolverRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverRules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResolverRulesResponse> listResolverRules() {
        return listResolverRules(ListResolverRulesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the Resolver rules that were created using the current AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResolverRules(software.amazon.awssdk.services.route53resolver.model.ListResolverRulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverRulesPublisher publisher = client.listResolverRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverRulesPublisher publisher = client.listResolverRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53resolver.model.ListResolverRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53resolver.model.ListResolverRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolverRules(software.amazon.awssdk.services.route53resolver.model.ListResolverRulesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverRules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverRulesPublisher listResolverRulesPaginator() {
        return listResolverRulesPaginator(ListResolverRulesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the Resolver rules that were created using the current AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResolverRules(software.amazon.awssdk.services.route53resolver.model.ListResolverRulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverRulesPublisher publisher = client.listResolverRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverRulesPublisher publisher = client.listResolverRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53resolver.model.ListResolverRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53resolver.model.ListResolverRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolverRules(software.amazon.awssdk.services.route53resolver.model.ListResolverRulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResolverRulesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverRules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverRulesPublisher listResolverRulesPaginator(ListResolverRulesRequest listResolverRulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Resolver rules that were created using the current AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResolverRules(software.amazon.awssdk.services.route53resolver.model.ListResolverRulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverRulesPublisher publisher = client.listResolverRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverRulesPublisher publisher = client.listResolverRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53resolver.model.ListResolverRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53resolver.model.ListResolverRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolverRules(software.amazon.awssdk.services.route53resolver.model.ListResolverRulesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResolverRulesRequest.Builder} avoiding the need
     * to create one manually via {@link ListResolverRulesRequest#builder()}
     * </p>
     *
     * @param listResolverRulesRequest
     *        A {@link Consumer} that will call methods on {@link ListResolverRulesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverRules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverRulesPublisher listResolverRulesPaginator(
            Consumer<ListResolverRulesRequest.Builder> listResolverRulesRequest) {
        return listResolverRulesPaginator(ListResolverRulesRequest.builder().applyMutation(listResolverRulesRequest).build());
    }

    /**
     * <p>
     * Lists the tags that you associated with the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags that you associated with the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the tags that you associated with the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.route53resolver.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53resolver.model.ListTagsForResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53resolver.model.ListTagsForResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.route53resolver.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourcePublisher listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags that you associated with the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.route53resolver.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53resolver.model.ListTagsForResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53resolver.model.ListTagsForResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.route53resolver.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourcePublisher listTagsForResourcePaginator(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResourcePaginator(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)
                .build());
    }

    /**
     * <p>
     * Specifies an AWS account that you want to share a query logging configuration with, the query logging
     * configuration that you want to share, and the operations that you want the account to be able to perform on the
     * configuration.
     * </p>
     *
     * @param putResolverQueryLogConfigPolicyRequest
     * @return A Java Future containing the result of the PutResolverQueryLogConfigPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidPolicyDocumentException The specified Resolver rule policy is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>UnknownResourceException The specified resource doesn't exist.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.PutResolverQueryLogConfigPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/PutResolverQueryLogConfigPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutResolverQueryLogConfigPolicyResponse> putResolverQueryLogConfigPolicy(
            PutResolverQueryLogConfigPolicyRequest putResolverQueryLogConfigPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specifies an AWS account that you want to share a query logging configuration with, the query logging
     * configuration that you want to share, and the operations that you want the account to be able to perform on the
     * configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutResolverQueryLogConfigPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link PutResolverQueryLogConfigPolicyRequest#builder()}
     * </p>
     *
     * @param putResolverQueryLogConfigPolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutResolverQueryLogConfigPolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the PutResolverQueryLogConfigPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidPolicyDocumentException The specified Resolver rule policy is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>UnknownResourceException The specified resource doesn't exist.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.PutResolverQueryLogConfigPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/PutResolverQueryLogConfigPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutResolverQueryLogConfigPolicyResponse> putResolverQueryLogConfigPolicy(
            Consumer<PutResolverQueryLogConfigPolicyRequest.Builder> putResolverQueryLogConfigPolicyRequest) {
        return putResolverQueryLogConfigPolicy(PutResolverQueryLogConfigPolicyRequest.builder()
                .applyMutation(putResolverQueryLogConfigPolicyRequest).build());
    }

    /**
     * <p>
     * Specifies an AWS rule that you want to share with another account, the account that you want to share the rule
     * with, and the operations that you want the account to be able to perform on the rule.
     * </p>
     *
     * @param putResolverRulePolicyRequest
     * @return A Java Future containing the result of the PutResolverRulePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidPolicyDocumentException The specified Resolver rule policy is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>UnknownResourceException The specified resource doesn't exist.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.PutResolverRulePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/PutResolverRulePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutResolverRulePolicyResponse> putResolverRulePolicy(
            PutResolverRulePolicyRequest putResolverRulePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specifies an AWS rule that you want to share with another account, the account that you want to share the rule
     * with, and the operations that you want the account to be able to perform on the rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutResolverRulePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link PutResolverRulePolicyRequest#builder()}
     * </p>
     *
     * @param putResolverRulePolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutResolverRulePolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutResolverRulePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidPolicyDocumentException The specified Resolver rule policy is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>UnknownResourceException The specified resource doesn't exist.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.PutResolverRulePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/PutResolverRulePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutResolverRulePolicyResponse> putResolverRulePolicy(
            Consumer<PutResolverRulePolicyRequest.Builder> putResolverRulePolicyRequest) {
        return putResolverRulePolicy(PutResolverRulePolicyRequest.builder().applyMutation(putResolverRulePolicyRequest).build());
    }

    /**
     * <p>
     * Adds one or more tags to a specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The request caused one or more limits to be exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidTagException The specified tag is invalid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more tags to a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The request caused one or more limits to be exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidTagException The specified tag is invalid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from a specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing DNSSEC validation configuration. If there is no existing DNSSEC validation configuration, one
     * is created.
     * </p>
     *
     * @param updateResolverDnssecConfigRequest
     * @return A Java Future containing the result of the UpdateResolverDnssecConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.UpdateResolverDnssecConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateResolverDnssecConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateResolverDnssecConfigResponse> updateResolverDnssecConfig(
            UpdateResolverDnssecConfigRequest updateResolverDnssecConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing DNSSEC validation configuration. If there is no existing DNSSEC validation configuration, one
     * is created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResolverDnssecConfigRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateResolverDnssecConfigRequest#builder()}
     * </p>
     *
     * @param updateResolverDnssecConfigRequest
     *        A {@link Consumer} that will call methods on {@link UpdateResolverDnssecConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateResolverDnssecConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.UpdateResolverDnssecConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateResolverDnssecConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateResolverDnssecConfigResponse> updateResolverDnssecConfig(
            Consumer<UpdateResolverDnssecConfigRequest.Builder> updateResolverDnssecConfigRequest) {
        return updateResolverDnssecConfig(UpdateResolverDnssecConfigRequest.builder()
                .applyMutation(updateResolverDnssecConfigRequest).build());
    }

    /**
     * <p>
     * Updates the name of an inbound or an outbound Resolver endpoint.
     * </p>
     *
     * @param updateResolverEndpointRequest
     * @return A Java Future containing the result of the UpdateResolverEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.UpdateResolverEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateResolverEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateResolverEndpointResponse> updateResolverEndpoint(
            UpdateResolverEndpointRequest updateResolverEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the name of an inbound or an outbound Resolver endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResolverEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateResolverEndpointRequest#builder()}
     * </p>
     *
     * @param updateResolverEndpointRequest
     *        A {@link Consumer} that will call methods on {@link UpdateResolverEndpointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateResolverEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.UpdateResolverEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateResolverEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateResolverEndpointResponse> updateResolverEndpoint(
            Consumer<UpdateResolverEndpointRequest.Builder> updateResolverEndpointRequest) {
        return updateResolverEndpoint(UpdateResolverEndpointRequest.builder().applyMutation(updateResolverEndpointRequest)
                .build());
    }

    /**
     * <p>
     * Updates settings for a specified Resolver rule. <code>ResolverRuleId</code> is required, and all other parameters
     * are optional. If you don't specify a parameter, it retains its current value.
     * </p>
     *
     * @param updateResolverRuleRequest
     * @return A Java Future containing the result of the UpdateResolverRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ResourceUnavailableException The specified resource isn't available.</li>
     *         <li>LimitExceededException The request caused one or more limits to be exceeded.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.UpdateResolverRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateResolverRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateResolverRuleResponse> updateResolverRule(UpdateResolverRuleRequest updateResolverRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates settings for a specified Resolver rule. <code>ResolverRuleId</code> is required, and all other parameters
     * are optional. If you don't specify a parameter, it retains its current value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResolverRuleRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateResolverRuleRequest#builder()}
     * </p>
     *
     * @param updateResolverRuleRequest
     *        A {@link Consumer} that will call methods on {@link UpdateResolverRuleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateResolverRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ResourceUnavailableException The specified resource isn't available.</li>
     *         <li>LimitExceededException The request caused one or more limits to be exceeded.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.UpdateResolverRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateResolverRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateResolverRuleResponse> updateResolverRule(
            Consumer<UpdateResolverRuleRequest.Builder> updateResolverRuleRequest) {
        return updateResolverRule(UpdateResolverRuleRequest.builder().applyMutation(updateResolverRuleRequest).build());
    }
}
