/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTrafficPolicyCommentRequest
extends Route53Request
implements ToCopyableBuilder<Builder, UpdateTrafficPolicyCommentRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateTrafficPolicyCommentRequest.getter(UpdateTrafficPolicyCommentRequest::id)).setter(UpdateTrafficPolicyCommentRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<Integer> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(UpdateTrafficPolicyCommentRequest.getter(UpdateTrafficPolicyCommentRequest::version)).setter(UpdateTrafficPolicyCommentRequest.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Version").unmarshallLocationName("Version").build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateTrafficPolicyCommentRequest.getter(UpdateTrafficPolicyCommentRequest::comment)).setter(UpdateTrafficPolicyCommentRequest.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").unmarshallLocationName("Comment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, VERSION_FIELD, COMMENT_FIELD));
    private final String id;
    private final Integer version;
    private final String comment;

    private UpdateTrafficPolicyCommentRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.version = builder.version;
        this.comment = builder.comment;
    }

    public String id() {
        return this.id;
    }

    public Integer version() {
        return this.version;
    }

    public String comment() {
        return this.comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrafficPolicyCommentRequest)) {
            return false;
        }
        UpdateTrafficPolicyCommentRequest other = (UpdateTrafficPolicyCommentRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.comment(), other.comment());
    }

    public String toString() {
        return ToString.builder((String)"UpdateTrafficPolicyCommentRequest").add("Id", (Object)this.id()).add("Version", (Object)this.version()).add("Comment", (Object)this.comment()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "Comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTrafficPolicyCommentRequest, T> g) {
        return obj -> g.apply((UpdateTrafficPolicyCommentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Request.BuilderImpl
    implements Builder {
        private String id;
        private Integer version;
        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTrafficPolicyCommentRequest model) {
            super(model);
            this.id(model.id);
            this.version(model.version);
            this.comment(model.comment);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Integer getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTrafficPolicyCommentRequest build() {
            return new UpdateTrafficPolicyCommentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTrafficPolicyCommentRequest> {
        public Builder id(String var1);

        public Builder version(Integer var1);

        public Builder comment(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

