/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.HostedZoneConfig;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.services.route53.model.VPC;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateHostedZoneRequest
extends Route53Request
implements ToCopyableBuilder<Builder, CreateHostedZoneRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateHostedZoneRequest.getter(CreateHostedZoneRequest::name)).setter(CreateHostedZoneRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<VPC> VPC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateHostedZoneRequest.getter(CreateHostedZoneRequest::vpc)).setter(CreateHostedZoneRequest.setter(Builder::vpc)).constructor(VPC::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPC").unmarshallLocationName("VPC").build()}).build();
    private static final SdkField<String> CALLER_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateHostedZoneRequest.getter(CreateHostedZoneRequest::callerReference)).setter(CreateHostedZoneRequest.setter(Builder::callerReference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallerReference").unmarshallLocationName("CallerReference").build()}).build();
    private static final SdkField<HostedZoneConfig> HOSTED_ZONE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateHostedZoneRequest.getter(CreateHostedZoneRequest::hostedZoneConfig)).setter(CreateHostedZoneRequest.setter(Builder::hostedZoneConfig)).constructor(HostedZoneConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZoneConfig").unmarshallLocationName("HostedZoneConfig").build()}).build();
    private static final SdkField<String> DELEGATION_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateHostedZoneRequest.getter(CreateHostedZoneRequest::delegationSetId)).setter(CreateHostedZoneRequest.setter(Builder::delegationSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DelegationSetId").unmarshallLocationName("DelegationSetId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VPC_FIELD, CALLER_REFERENCE_FIELD, HOSTED_ZONE_CONFIG_FIELD, DELEGATION_SET_ID_FIELD));
    private final String name;
    private final VPC vpc;
    private final String callerReference;
    private final HostedZoneConfig hostedZoneConfig;
    private final String delegationSetId;

    private CreateHostedZoneRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.vpc = builder.vpc;
        this.callerReference = builder.callerReference;
        this.hostedZoneConfig = builder.hostedZoneConfig;
        this.delegationSetId = builder.delegationSetId;
    }

    public String name() {
        return this.name;
    }

    public VPC vpc() {
        return this.vpc;
    }

    public String callerReference() {
        return this.callerReference;
    }

    public HostedZoneConfig hostedZoneConfig() {
        return this.hostedZoneConfig;
    }

    public String delegationSetId() {
        return this.delegationSetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpc());
        hashCode = 31 * hashCode + Objects.hashCode(this.callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.delegationSetId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHostedZoneRequest)) {
            return false;
        }
        CreateHostedZoneRequest other = (CreateHostedZoneRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.vpc(), other.vpc()) && Objects.equals(this.callerReference(), other.callerReference()) && Objects.equals(this.hostedZoneConfig(), other.hostedZoneConfig()) && Objects.equals(this.delegationSetId(), other.delegationSetId());
    }

    public String toString() {
        return ToString.builder((String)"CreateHostedZoneRequest").add("Name", (Object)this.name()).add("VPC", (Object)this.vpc()).add("CallerReference", (Object)this.callerReference()).add("HostedZoneConfig", (Object)this.hostedZoneConfig()).add("DelegationSetId", (Object)this.delegationSetId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "VPC": {
                return Optional.ofNullable(clazz.cast(this.vpc()));
            }
            case "CallerReference": {
                return Optional.ofNullable(clazz.cast(this.callerReference()));
            }
            case "HostedZoneConfig": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneConfig()));
            }
            case "DelegationSetId": {
                return Optional.ofNullable(clazz.cast(this.delegationSetId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateHostedZoneRequest, T> g) {
        return obj -> g.apply((CreateHostedZoneRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Request.BuilderImpl
    implements Builder {
        private String name;
        private VPC vpc;
        private String callerReference;
        private HostedZoneConfig hostedZoneConfig;
        private String delegationSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHostedZoneRequest model) {
            super(model);
            this.name(model.name);
            this.vpc(model.vpc);
            this.callerReference(model.callerReference);
            this.hostedZoneConfig(model.hostedZoneConfig);
            this.delegationSetId(model.delegationSetId);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final VPC.Builder getVpc() {
            return this.vpc != null ? this.vpc.toBuilder() : null;
        }

        @Override
        public final Builder vpc(VPC vpc) {
            this.vpc = vpc;
            return this;
        }

        public final void setVpc(VPC.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        public final String getCallerReference() {
            return this.callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        public final HostedZoneConfig.Builder getHostedZoneConfig() {
            return this.hostedZoneConfig != null ? this.hostedZoneConfig.toBuilder() : null;
        }

        @Override
        public final Builder hostedZoneConfig(HostedZoneConfig hostedZoneConfig) {
            this.hostedZoneConfig = hostedZoneConfig;
            return this;
        }

        public final void setHostedZoneConfig(HostedZoneConfig.BuilderImpl hostedZoneConfig) {
            this.hostedZoneConfig = hostedZoneConfig != null ? hostedZoneConfig.build() : null;
        }

        public final String getDelegationSetId() {
            return this.delegationSetId;
        }

        @Override
        public final Builder delegationSetId(String delegationSetId) {
            this.delegationSetId = delegationSetId;
            return this;
        }

        public final void setDelegationSetId(String delegationSetId) {
            this.delegationSetId = delegationSetId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateHostedZoneRequest build() {
            return new CreateHostedZoneRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateHostedZoneRequest> {
        public Builder name(String var1);

        public Builder vpc(VPC var1);

        default public Builder vpc(Consumer<VPC.Builder> vpc) {
            return this.vpc((VPC)((VPC.Builder)VPC.builder().applyMutation(vpc)).build());
        }

        public Builder callerReference(String var1);

        public Builder hostedZoneConfig(HostedZoneConfig var1);

        default public Builder hostedZoneConfig(Consumer<HostedZoneConfig.Builder> hostedZoneConfig) {
            return this.hostedZoneConfig((HostedZoneConfig)((HostedZoneConfig.Builder)HostedZoneConfig.builder().applyMutation(hostedZoneConfig)).build());
        }

        public Builder delegationSetId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

