/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.robomaker.RoboMakerClient;
import software.amazon.awssdk.services.robomaker.model.ListFleetsRequest;
import software.amazon.awssdk.services.robomaker.model.ListFleetsResponse;

public class ListFleetsIterable
implements SdkIterable<ListFleetsResponse> {
    private final RoboMakerClient client;
    private final ListFleetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFleetsIterable(RoboMakerClient client, ListFleetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListFleetsResponseFetcher();
    }

    public Iterator<ListFleetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListFleetsResponseFetcher
    implements SyncPageFetcher<ListFleetsResponse> {
        private ListFleetsResponseFetcher() {
        }

        public boolean hasNextPage(ListFleetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFleetsResponse nextPage(ListFleetsResponse previousPage) {
            if (previousPage == null) {
                return ListFleetsIterable.this.client.listFleets(ListFleetsIterable.this.firstRequest);
            }
            return ListFleetsIterable.this.client.listFleets((ListFleetsRequest)((Object)ListFleetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

