/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.robomaker.model.FailureBehavior;
import software.amazon.awssdk.services.robomaker.model.OutputLocation;
import software.amazon.awssdk.services.robomaker.model.RoboMakerRequest;
import software.amazon.awssdk.services.robomaker.model.RobotApplicationConfig;
import software.amazon.awssdk.services.robomaker.model.RobotApplicationConfigsCopier;
import software.amazon.awssdk.services.robomaker.model.SimulationApplicationConfig;
import software.amazon.awssdk.services.robomaker.model.SimulationApplicationConfigsCopier;
import software.amazon.awssdk.services.robomaker.model.TagMapCopier;
import software.amazon.awssdk.services.robomaker.model.VPCConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSimulationJobRequest
extends RoboMakerRequest
implements ToCopyableBuilder<Builder, CreateSimulationJobRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateSimulationJobRequest.getter(CreateSimulationJobRequest::clientRequestToken)).setter(CreateSimulationJobRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<OutputLocation> OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateSimulationJobRequest.getter(CreateSimulationJobRequest::outputLocation)).setter(CreateSimulationJobRequest.setter(Builder::outputLocation)).constructor(OutputLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputLocation").build()}).build();
    private static final SdkField<Long> MAX_JOB_DURATION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(CreateSimulationJobRequest.getter(CreateSimulationJobRequest::maxJobDurationInSeconds)).setter(CreateSimulationJobRequest.setter(Builder::maxJobDurationInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxJobDurationInSeconds").build()}).build();
    private static final SdkField<String> IAM_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateSimulationJobRequest.getter(CreateSimulationJobRequest::iamRole)).setter(CreateSimulationJobRequest.setter(Builder::iamRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRole").build()}).build();
    private static final SdkField<String> FAILURE_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateSimulationJobRequest.getter(CreateSimulationJobRequest::failureBehaviorAsString)).setter(CreateSimulationJobRequest.setter(Builder::failureBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureBehavior").build()}).build();
    private static final SdkField<List<RobotApplicationConfig>> ROBOT_APPLICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateSimulationJobRequest.getter(CreateSimulationJobRequest::robotApplications)).setter(CreateSimulationJobRequest.setter(Builder::robotApplications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("robotApplications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RobotApplicationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SimulationApplicationConfig>> SIMULATION_APPLICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateSimulationJobRequest.getter(CreateSimulationJobRequest::simulationApplications)).setter(CreateSimulationJobRequest.setter(Builder::simulationApplications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("simulationApplications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SimulationApplicationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(CreateSimulationJobRequest.getter(CreateSimulationJobRequest::tags)).setter(CreateSimulationJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<VPCConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateSimulationJobRequest.getter(CreateSimulationJobRequest::vpcConfig)).setter(CreateSimulationJobRequest.setter(Builder::vpcConfig)).constructor(VPCConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD, OUTPUT_LOCATION_FIELD, MAX_JOB_DURATION_IN_SECONDS_FIELD, IAM_ROLE_FIELD, FAILURE_BEHAVIOR_FIELD, ROBOT_APPLICATIONS_FIELD, SIMULATION_APPLICATIONS_FIELD, TAGS_FIELD, VPC_CONFIG_FIELD));
    private final String clientRequestToken;
    private final OutputLocation outputLocation;
    private final Long maxJobDurationInSeconds;
    private final String iamRole;
    private final String failureBehavior;
    private final List<RobotApplicationConfig> robotApplications;
    private final List<SimulationApplicationConfig> simulationApplications;
    private final Map<String, String> tags;
    private final VPCConfig vpcConfig;

    private CreateSimulationJobRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.outputLocation = builder.outputLocation;
        this.maxJobDurationInSeconds = builder.maxJobDurationInSeconds;
        this.iamRole = builder.iamRole;
        this.failureBehavior = builder.failureBehavior;
        this.robotApplications = builder.robotApplications;
        this.simulationApplications = builder.simulationApplications;
        this.tags = builder.tags;
        this.vpcConfig = builder.vpcConfig;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public OutputLocation outputLocation() {
        return this.outputLocation;
    }

    public Long maxJobDurationInSeconds() {
        return this.maxJobDurationInSeconds;
    }

    public String iamRole() {
        return this.iamRole;
    }

    public FailureBehavior failureBehavior() {
        return FailureBehavior.fromValue(this.failureBehavior);
    }

    public String failureBehaviorAsString() {
        return this.failureBehavior;
    }

    public List<RobotApplicationConfig> robotApplications() {
        return this.robotApplications;
    }

    public List<SimulationApplicationConfig> simulationApplications() {
        return this.simulationApplications;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public VPCConfig vpcConfig() {
        return this.vpcConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxJobDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.robotApplications());
        hashCode = 31 * hashCode + Objects.hashCode(this.simulationApplications());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSimulationJobRequest)) {
            return false;
        }
        CreateSimulationJobRequest other = (CreateSimulationJobRequest)((Object)obj);
        return Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.outputLocation(), other.outputLocation()) && Objects.equals(this.maxJobDurationInSeconds(), other.maxJobDurationInSeconds()) && Objects.equals(this.iamRole(), other.iamRole()) && Objects.equals(this.failureBehaviorAsString(), other.failureBehaviorAsString()) && Objects.equals(this.robotApplications(), other.robotApplications()) && Objects.equals(this.simulationApplications(), other.simulationApplications()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.vpcConfig(), other.vpcConfig());
    }

    public String toString() {
        return ToString.builder((String)"CreateSimulationJobRequest").add("ClientRequestToken", (Object)this.clientRequestToken()).add("OutputLocation", (Object)this.outputLocation()).add("MaxJobDurationInSeconds", (Object)this.maxJobDurationInSeconds()).add("IamRole", (Object)this.iamRole()).add("FailureBehavior", (Object)this.failureBehaviorAsString()).add("RobotApplications", this.robotApplications()).add("SimulationApplications", this.simulationApplications()).add("Tags", this.tags()).add("VpcConfig", (Object)this.vpcConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "outputLocation": {
                return Optional.ofNullable(clazz.cast(this.outputLocation()));
            }
            case "maxJobDurationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.maxJobDurationInSeconds()));
            }
            case "iamRole": {
                return Optional.ofNullable(clazz.cast(this.iamRole()));
            }
            case "failureBehavior": {
                return Optional.ofNullable(clazz.cast(this.failureBehaviorAsString()));
            }
            case "robotApplications": {
                return Optional.ofNullable(clazz.cast(this.robotApplications()));
            }
            case "simulationApplications": {
                return Optional.ofNullable(clazz.cast(this.simulationApplications()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "vpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSimulationJobRequest, T> g) {
        return obj -> g.apply((CreateSimulationJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RoboMakerRequest.BuilderImpl
    implements Builder {
        private String clientRequestToken;
        private OutputLocation outputLocation;
        private Long maxJobDurationInSeconds;
        private String iamRole;
        private String failureBehavior;
        private List<RobotApplicationConfig> robotApplications = DefaultSdkAutoConstructList.getInstance();
        private List<SimulationApplicationConfig> simulationApplications = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private VPCConfig vpcConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSimulationJobRequest model) {
            super(model);
            this.clientRequestToken(model.clientRequestToken);
            this.outputLocation(model.outputLocation);
            this.maxJobDurationInSeconds(model.maxJobDurationInSeconds);
            this.iamRole(model.iamRole);
            this.failureBehavior(model.failureBehavior);
            this.robotApplications(model.robotApplications);
            this.simulationApplications(model.simulationApplications);
            this.tags(model.tags);
            this.vpcConfig(model.vpcConfig);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final OutputLocation.Builder getOutputLocation() {
            return this.outputLocation != null ? this.outputLocation.toBuilder() : null;
        }

        @Override
        public final Builder outputLocation(OutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final void setOutputLocation(OutputLocation.BuilderImpl outputLocation) {
            this.outputLocation = outputLocation != null ? outputLocation.build() : null;
        }

        public final Long getMaxJobDurationInSeconds() {
            return this.maxJobDurationInSeconds;
        }

        @Override
        public final Builder maxJobDurationInSeconds(Long maxJobDurationInSeconds) {
            this.maxJobDurationInSeconds = maxJobDurationInSeconds;
            return this;
        }

        public final void setMaxJobDurationInSeconds(Long maxJobDurationInSeconds) {
            this.maxJobDurationInSeconds = maxJobDurationInSeconds;
        }

        public final String getIamRole() {
            return this.iamRole;
        }

        @Override
        public final Builder iamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        public final String getFailureBehaviorAsString() {
            return this.failureBehavior;
        }

        @Override
        public final Builder failureBehavior(String failureBehavior) {
            this.failureBehavior = failureBehavior;
            return this;
        }

        @Override
        public final Builder failureBehavior(FailureBehavior failureBehavior) {
            this.failureBehavior(failureBehavior.toString());
            return this;
        }

        public final void setFailureBehavior(String failureBehavior) {
            this.failureBehavior = failureBehavior;
        }

        public final Collection<RobotApplicationConfig.Builder> getRobotApplications() {
            return this.robotApplications != null ? (Collection)this.robotApplications.stream().map(RobotApplicationConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder robotApplications(Collection<RobotApplicationConfig> robotApplications) {
            this.robotApplications = RobotApplicationConfigsCopier.copy(robotApplications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder robotApplications(RobotApplicationConfig ... robotApplications) {
            this.robotApplications(Arrays.asList(robotApplications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder robotApplications(Consumer<RobotApplicationConfig.Builder> ... robotApplications) {
            this.robotApplications(Stream.of(robotApplications).map(c -> (RobotApplicationConfig)((RobotApplicationConfig.Builder)RobotApplicationConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRobotApplications(Collection<RobotApplicationConfig.BuilderImpl> robotApplications) {
            this.robotApplications = RobotApplicationConfigsCopier.copyFromBuilder(robotApplications);
        }

        public final Collection<SimulationApplicationConfig.Builder> getSimulationApplications() {
            return this.simulationApplications != null ? (Collection)this.simulationApplications.stream().map(SimulationApplicationConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder simulationApplications(Collection<SimulationApplicationConfig> simulationApplications) {
            this.simulationApplications = SimulationApplicationConfigsCopier.copy(simulationApplications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder simulationApplications(SimulationApplicationConfig ... simulationApplications) {
            this.simulationApplications(Arrays.asList(simulationApplications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder simulationApplications(Consumer<SimulationApplicationConfig.Builder> ... simulationApplications) {
            this.simulationApplications(Stream.of(simulationApplications).map(c -> (SimulationApplicationConfig)((SimulationApplicationConfig.Builder)SimulationApplicationConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSimulationApplications(Collection<SimulationApplicationConfig.BuilderImpl> simulationApplications) {
            this.simulationApplications = SimulationApplicationConfigsCopier.copyFromBuilder(simulationApplications);
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public final VPCConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VPCConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VPCConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSimulationJobRequest build() {
            return new CreateSimulationJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RoboMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSimulationJobRequest> {
        public Builder clientRequestToken(String var1);

        public Builder outputLocation(OutputLocation var1);

        default public Builder outputLocation(Consumer<OutputLocation.Builder> outputLocation) {
            return this.outputLocation((OutputLocation)((OutputLocation.Builder)OutputLocation.builder().applyMutation(outputLocation)).build());
        }

        public Builder maxJobDurationInSeconds(Long var1);

        public Builder iamRole(String var1);

        public Builder failureBehavior(String var1);

        public Builder failureBehavior(FailureBehavior var1);

        public Builder robotApplications(Collection<RobotApplicationConfig> var1);

        public Builder robotApplications(RobotApplicationConfig ... var1);

        public Builder robotApplications(Consumer<RobotApplicationConfig.Builder> ... var1);

        public Builder simulationApplications(Collection<SimulationApplicationConfig> var1);

        public Builder simulationApplications(SimulationApplicationConfig ... var1);

        public Builder simulationApplications(Consumer<SimulationApplicationConfig.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder vpcConfig(VPCConfig var1);

        default public Builder vpcConfig(Consumer<VPCConfig.Builder> vpcConfig) {
            return this.vpcConfig((VPCConfig)((VPCConfig.Builder)VPCConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

