/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.robomaker.model.EnvironmentVariableMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentLaunchConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeploymentLaunchConfig> {
    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeploymentLaunchConfig.getter(DeploymentLaunchConfig::packageName)).setter(DeploymentLaunchConfig.setter(Builder::packageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageName").build()}).build();
    private static final SdkField<String> PRE_LAUNCH_FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeploymentLaunchConfig.getter(DeploymentLaunchConfig::preLaunchFile)).setter(DeploymentLaunchConfig.setter(Builder::preLaunchFile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preLaunchFile").build()}).build();
    private static final SdkField<String> LAUNCH_FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeploymentLaunchConfig.getter(DeploymentLaunchConfig::launchFile)).setter(DeploymentLaunchConfig.setter(Builder::launchFile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchFile").build()}).build();
    private static final SdkField<String> POST_LAUNCH_FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeploymentLaunchConfig.getter(DeploymentLaunchConfig::postLaunchFile)).setter(DeploymentLaunchConfig.setter(Builder::postLaunchFile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postLaunchFile").build()}).build();
    private static final SdkField<Map<String, String>> ENVIRONMENT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(DeploymentLaunchConfig.getter(DeploymentLaunchConfig::environmentVariables)).setter(DeploymentLaunchConfig.setter(Builder::environmentVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVariables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_NAME_FIELD, PRE_LAUNCH_FILE_FIELD, LAUNCH_FILE_FIELD, POST_LAUNCH_FILE_FIELD, ENVIRONMENT_VARIABLES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String packageName;
    private final String preLaunchFile;
    private final String launchFile;
    private final String postLaunchFile;
    private final Map<String, String> environmentVariables;

    private DeploymentLaunchConfig(BuilderImpl builder) {
        this.packageName = builder.packageName;
        this.preLaunchFile = builder.preLaunchFile;
        this.launchFile = builder.launchFile;
        this.postLaunchFile = builder.postLaunchFile;
        this.environmentVariables = builder.environmentVariables;
    }

    public String packageName() {
        return this.packageName;
    }

    public String preLaunchFile() {
        return this.preLaunchFile;
    }

    public String launchFile() {
        return this.launchFile;
    }

    public String postLaunchFile() {
        return this.postLaunchFile;
    }

    public Map<String, String> environmentVariables() {
        return this.environmentVariables;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.packageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.preLaunchFile());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchFile());
        hashCode = 31 * hashCode + Objects.hashCode(this.postLaunchFile());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentVariables());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentLaunchConfig)) {
            return false;
        }
        DeploymentLaunchConfig other = (DeploymentLaunchConfig)obj;
        return Objects.equals(this.packageName(), other.packageName()) && Objects.equals(this.preLaunchFile(), other.preLaunchFile()) && Objects.equals(this.launchFile(), other.launchFile()) && Objects.equals(this.postLaunchFile(), other.postLaunchFile()) && Objects.equals(this.environmentVariables(), other.environmentVariables());
    }

    public String toString() {
        return ToString.builder((String)"DeploymentLaunchConfig").add("PackageName", (Object)this.packageName()).add("PreLaunchFile", (Object)this.preLaunchFile()).add("LaunchFile", (Object)this.launchFile()).add("PostLaunchFile", (Object)this.postLaunchFile()).add("EnvironmentVariables", this.environmentVariables()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "packageName": {
                return Optional.ofNullable(clazz.cast(this.packageName()));
            }
            case "preLaunchFile": {
                return Optional.ofNullable(clazz.cast(this.preLaunchFile()));
            }
            case "launchFile": {
                return Optional.ofNullable(clazz.cast(this.launchFile()));
            }
            case "postLaunchFile": {
                return Optional.ofNullable(clazz.cast(this.postLaunchFile()));
            }
            case "environmentVariables": {
                return Optional.ofNullable(clazz.cast(this.environmentVariables()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentLaunchConfig, T> g) {
        return obj -> g.apply((DeploymentLaunchConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String packageName;
        private String preLaunchFile;
        private String launchFile;
        private String postLaunchFile;
        private Map<String, String> environmentVariables = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentLaunchConfig model) {
            this.packageName(model.packageName);
            this.preLaunchFile(model.preLaunchFile);
            this.launchFile(model.launchFile);
            this.postLaunchFile(model.postLaunchFile);
            this.environmentVariables(model.environmentVariables);
        }

        public final String getPackageName() {
            return this.packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public final String getPreLaunchFile() {
            return this.preLaunchFile;
        }

        @Override
        public final Builder preLaunchFile(String preLaunchFile) {
            this.preLaunchFile = preLaunchFile;
            return this;
        }

        public final void setPreLaunchFile(String preLaunchFile) {
            this.preLaunchFile = preLaunchFile;
        }

        public final String getLaunchFile() {
            return this.launchFile;
        }

        @Override
        public final Builder launchFile(String launchFile) {
            this.launchFile = launchFile;
            return this;
        }

        public final void setLaunchFile(String launchFile) {
            this.launchFile = launchFile;
        }

        public final String getPostLaunchFile() {
            return this.postLaunchFile;
        }

        @Override
        public final Builder postLaunchFile(String postLaunchFile) {
            this.postLaunchFile = postLaunchFile;
            return this;
        }

        public final void setPostLaunchFile(String postLaunchFile) {
            this.postLaunchFile = postLaunchFile;
        }

        public final Map<String, String> getEnvironmentVariables() {
            return this.environmentVariables;
        }

        @Override
        public final Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariableMapCopier.copy(environmentVariables);
            return this;
        }

        public final void setEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariableMapCopier.copy(environmentVariables);
        }

        public DeploymentLaunchConfig build() {
            return new DeploymentLaunchConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeploymentLaunchConfig> {
        public Builder packageName(String var1);

        public Builder preLaunchFile(String var1);

        public Builder launchFile(String var1);

        public Builder postLaunchFile(String var1);

        public Builder environmentVariables(Map<String, String> var1);
    }
}

