/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.robomaker.model.DeploymentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Fleet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Fleet> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Fleet.getter(Fleet::name)).setter(Fleet.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Fleet.getter(Fleet::arn)).setter(Fleet.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Fleet.getter(Fleet::createdAt)).setter(Fleet.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> LAST_DEPLOYMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastDeploymentStatus").getter(Fleet.getter(Fleet::lastDeploymentStatusAsString)).setter(Fleet.setter(Builder::lastDeploymentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDeploymentStatus").build()}).build();
    private static final SdkField<String> LAST_DEPLOYMENT_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastDeploymentJob").getter(Fleet.getter(Fleet::lastDeploymentJob)).setter(Fleet.setter(Builder::lastDeploymentJob)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDeploymentJob").build()}).build();
    private static final SdkField<Instant> LAST_DEPLOYMENT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastDeploymentTime").getter(Fleet.getter(Fleet::lastDeploymentTime)).setter(Fleet.setter(Builder::lastDeploymentTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDeploymentTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, CREATED_AT_FIELD, LAST_DEPLOYMENT_STATUS_FIELD, LAST_DEPLOYMENT_JOB_FIELD, LAST_DEPLOYMENT_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Fleet.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final Instant createdAt;
    private final String lastDeploymentStatus;
    private final String lastDeploymentJob;
    private final Instant lastDeploymentTime;

    private Fleet(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.lastDeploymentStatus = builder.lastDeploymentStatus;
        this.lastDeploymentJob = builder.lastDeploymentJob;
        this.lastDeploymentTime = builder.lastDeploymentTime;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final DeploymentStatus lastDeploymentStatus() {
        return DeploymentStatus.fromValue(this.lastDeploymentStatus);
    }

    public final String lastDeploymentStatusAsString() {
        return this.lastDeploymentStatus;
    }

    public final String lastDeploymentJob() {
        return this.lastDeploymentJob;
    }

    public final Instant lastDeploymentTime() {
        return this.lastDeploymentTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastDeploymentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastDeploymentJob());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastDeploymentTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Fleet)) {
            return false;
        }
        Fleet other = (Fleet)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastDeploymentStatusAsString(), other.lastDeploymentStatusAsString()) && Objects.equals(this.lastDeploymentJob(), other.lastDeploymentJob()) && Objects.equals(this.lastDeploymentTime(), other.lastDeploymentTime());
    }

    public final String toString() {
        return ToString.builder((String)"Fleet").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("LastDeploymentStatus", (Object)this.lastDeploymentStatusAsString()).add("LastDeploymentJob", (Object)this.lastDeploymentJob()).add("LastDeploymentTime", (Object)this.lastDeploymentTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "lastDeploymentStatus": {
                return Optional.ofNullable(clazz.cast(this.lastDeploymentStatusAsString()));
            }
            case "lastDeploymentJob": {
                return Optional.ofNullable(clazz.cast(this.lastDeploymentJob()));
            }
            case "lastDeploymentTime": {
                return Optional.ofNullable(clazz.cast(this.lastDeploymentTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastDeploymentStatus", LAST_DEPLOYMENT_STATUS_FIELD);
        map.put("lastDeploymentJob", LAST_DEPLOYMENT_JOB_FIELD);
        map.put("lastDeploymentTime", LAST_DEPLOYMENT_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Fleet, T> g) {
        return obj -> g.apply((Fleet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private Instant createdAt;
        private String lastDeploymentStatus;
        private String lastDeploymentJob;
        private Instant lastDeploymentTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Fleet model) {
            this.name(model.name);
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.lastDeploymentStatus(model.lastDeploymentStatus);
            this.lastDeploymentJob(model.lastDeploymentJob);
            this.lastDeploymentTime(model.lastDeploymentTime);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getLastDeploymentStatus() {
            return this.lastDeploymentStatus;
        }

        public final void setLastDeploymentStatus(String lastDeploymentStatus) {
            this.lastDeploymentStatus = lastDeploymentStatus;
        }

        @Override
        public final Builder lastDeploymentStatus(String lastDeploymentStatus) {
            this.lastDeploymentStatus = lastDeploymentStatus;
            return this;
        }

        @Override
        public final Builder lastDeploymentStatus(DeploymentStatus lastDeploymentStatus) {
            this.lastDeploymentStatus(lastDeploymentStatus == null ? null : lastDeploymentStatus.toString());
            return this;
        }

        public final String getLastDeploymentJob() {
            return this.lastDeploymentJob;
        }

        public final void setLastDeploymentJob(String lastDeploymentJob) {
            this.lastDeploymentJob = lastDeploymentJob;
        }

        @Override
        public final Builder lastDeploymentJob(String lastDeploymentJob) {
            this.lastDeploymentJob = lastDeploymentJob;
            return this;
        }

        public final Instant getLastDeploymentTime() {
            return this.lastDeploymentTime;
        }

        public final void setLastDeploymentTime(Instant lastDeploymentTime) {
            this.lastDeploymentTime = lastDeploymentTime;
        }

        @Override
        public final Builder lastDeploymentTime(Instant lastDeploymentTime) {
            this.lastDeploymentTime = lastDeploymentTime;
            return this;
        }

        public Fleet build() {
            return new Fleet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Fleet> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder lastDeploymentStatus(String var1);

        public Builder lastDeploymentStatus(DeploymentStatus var1);

        public Builder lastDeploymentJob(String var1);

        public Builder lastDeploymentTime(Instant var1);
    }
}

