/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.robomaker.RoboMakerAsyncClient;
import software.amazon.awssdk.services.robomaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.robomaker.model.DeploymentJob;
import software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsRequest;
import software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsResponse;

public class ListDeploymentJobsPublisher
implements SdkPublisher<ListDeploymentJobsResponse> {
    private final RoboMakerAsyncClient client;
    private final ListDeploymentJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDeploymentJobsPublisher(RoboMakerAsyncClient client, ListDeploymentJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDeploymentJobsPublisher(RoboMakerAsyncClient client, ListDeploymentJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDeploymentJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDeploymentJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DeploymentJob> deploymentJobs() {
        Function<ListDeploymentJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.deploymentJobs() != null) {
                return response.deploymentJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDeploymentJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDeploymentJobsResponseFetcher
    implements AsyncPageFetcher<ListDeploymentJobsResponse> {
        private ListDeploymentJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListDeploymentJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDeploymentJobsResponse> nextPage(ListDeploymentJobsResponse previousPage) {
            if (previousPage == null) {
                return ListDeploymentJobsPublisher.this.client.listDeploymentJobs(ListDeploymentJobsPublisher.this.firstRequest);
            }
            return ListDeploymentJobsPublisher.this.client.listDeploymentJobs((ListDeploymentJobsRequest)((Object)ListDeploymentJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

