/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.robomaker.model.Environment;
import software.amazon.awssdk.services.robomaker.model.RenderingEngine;
import software.amazon.awssdk.services.robomaker.model.RoboMakerRequest;
import software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuite;
import software.amazon.awssdk.services.robomaker.model.SimulationSoftwareSuite;
import software.amazon.awssdk.services.robomaker.model.SourceConfig;
import software.amazon.awssdk.services.robomaker.model.SourceConfigsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSimulationApplicationRequest
extends RoboMakerRequest
implements ToCopyableBuilder<Builder, UpdateSimulationApplicationRequest> {
    private static final SdkField<String> APPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("application").getter(UpdateSimulationApplicationRequest.getter(UpdateSimulationApplicationRequest::application)).setter(UpdateSimulationApplicationRequest.setter(Builder::application)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("application").build()}).build();
    private static final SdkField<List<SourceConfig>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sources").getter(UpdateSimulationApplicationRequest.getter(UpdateSimulationApplicationRequest::sources)).setter(UpdateSimulationApplicationRequest.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SimulationSoftwareSuite> SIMULATION_SOFTWARE_SUITE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("simulationSoftwareSuite").getter(UpdateSimulationApplicationRequest.getter(UpdateSimulationApplicationRequest::simulationSoftwareSuite)).setter(UpdateSimulationApplicationRequest.setter(Builder::simulationSoftwareSuite)).constructor(SimulationSoftwareSuite::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("simulationSoftwareSuite").build()}).build();
    private static final SdkField<RobotSoftwareSuite> ROBOT_SOFTWARE_SUITE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("robotSoftwareSuite").getter(UpdateSimulationApplicationRequest.getter(UpdateSimulationApplicationRequest::robotSoftwareSuite)).setter(UpdateSimulationApplicationRequest.setter(Builder::robotSoftwareSuite)).constructor(RobotSoftwareSuite::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("robotSoftwareSuite").build()}).build();
    private static final SdkField<RenderingEngine> RENDERING_ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("renderingEngine").getter(UpdateSimulationApplicationRequest.getter(UpdateSimulationApplicationRequest::renderingEngine)).setter(UpdateSimulationApplicationRequest.setter(Builder::renderingEngine)).constructor(RenderingEngine::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renderingEngine").build()}).build();
    private static final SdkField<String> CURRENT_REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currentRevisionId").getter(UpdateSimulationApplicationRequest.getter(UpdateSimulationApplicationRequest::currentRevisionId)).setter(UpdateSimulationApplicationRequest.setter(Builder::currentRevisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentRevisionId").build()}).build();
    private static final SdkField<Environment> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("environment").getter(UpdateSimulationApplicationRequest.getter(UpdateSimulationApplicationRequest::environment)).setter(UpdateSimulationApplicationRequest.setter(Builder::environment)).constructor(Environment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_FIELD, SOURCES_FIELD, SIMULATION_SOFTWARE_SUITE_FIELD, ROBOT_SOFTWARE_SUITE_FIELD, RENDERING_ENGINE_FIELD, CURRENT_REVISION_ID_FIELD, ENVIRONMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateSimulationApplicationRequest.memberNameToFieldInitializer();
    private final String application;
    private final List<SourceConfig> sources;
    private final SimulationSoftwareSuite simulationSoftwareSuite;
    private final RobotSoftwareSuite robotSoftwareSuite;
    private final RenderingEngine renderingEngine;
    private final String currentRevisionId;
    private final Environment environment;

    private UpdateSimulationApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.application = builder.application;
        this.sources = builder.sources;
        this.simulationSoftwareSuite = builder.simulationSoftwareSuite;
        this.robotSoftwareSuite = builder.robotSoftwareSuite;
        this.renderingEngine = builder.renderingEngine;
        this.currentRevisionId = builder.currentRevisionId;
        this.environment = builder.environment;
    }

    public final String application() {
        return this.application;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<SourceConfig> sources() {
        return this.sources;
    }

    public final SimulationSoftwareSuite simulationSoftwareSuite() {
        return this.simulationSoftwareSuite;
    }

    public final RobotSoftwareSuite robotSoftwareSuite() {
        return this.robotSoftwareSuite;
    }

    public final RenderingEngine renderingEngine() {
        return this.renderingEngine;
    }

    public final String currentRevisionId() {
        return this.currentRevisionId;
    }

    public final Environment environment() {
        return this.environment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.application());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.simulationSoftwareSuite());
        hashCode = 31 * hashCode + Objects.hashCode(this.robotSoftwareSuite());
        hashCode = 31 * hashCode + Objects.hashCode(this.renderingEngine());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentRevisionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.environment());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSimulationApplicationRequest)) {
            return false;
        }
        UpdateSimulationApplicationRequest other = (UpdateSimulationApplicationRequest)((Object)obj);
        return Objects.equals(this.application(), other.application()) && this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources()) && Objects.equals(this.simulationSoftwareSuite(), other.simulationSoftwareSuite()) && Objects.equals(this.robotSoftwareSuite(), other.robotSoftwareSuite()) && Objects.equals(this.renderingEngine(), other.renderingEngine()) && Objects.equals(this.currentRevisionId(), other.currentRevisionId()) && Objects.equals(this.environment(), other.environment());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSimulationApplicationRequest").add("Application", (Object)this.application()).add("Sources", this.hasSources() ? this.sources() : null).add("SimulationSoftwareSuite", (Object)this.simulationSoftwareSuite()).add("RobotSoftwareSuite", (Object)this.robotSoftwareSuite()).add("RenderingEngine", (Object)this.renderingEngine()).add("CurrentRevisionId", (Object)this.currentRevisionId()).add("Environment", (Object)this.environment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "application": {
                return Optional.ofNullable(clazz.cast(this.application()));
            }
            case "sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
            case "simulationSoftwareSuite": {
                return Optional.ofNullable(clazz.cast(this.simulationSoftwareSuite()));
            }
            case "robotSoftwareSuite": {
                return Optional.ofNullable(clazz.cast(this.robotSoftwareSuite()));
            }
            case "renderingEngine": {
                return Optional.ofNullable(clazz.cast(this.renderingEngine()));
            }
            case "currentRevisionId": {
                return Optional.ofNullable(clazz.cast(this.currentRevisionId()));
            }
            case "environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("application", APPLICATION_FIELD);
        map.put("sources", SOURCES_FIELD);
        map.put("simulationSoftwareSuite", SIMULATION_SOFTWARE_SUITE_FIELD);
        map.put("robotSoftwareSuite", ROBOT_SOFTWARE_SUITE_FIELD);
        map.put("renderingEngine", RENDERING_ENGINE_FIELD);
        map.put("currentRevisionId", CURRENT_REVISION_ID_FIELD);
        map.put("environment", ENVIRONMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSimulationApplicationRequest, T> g) {
        return obj -> g.apply((UpdateSimulationApplicationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RoboMakerRequest.BuilderImpl
    implements Builder {
        private String application;
        private List<SourceConfig> sources = DefaultSdkAutoConstructList.getInstance();
        private SimulationSoftwareSuite simulationSoftwareSuite;
        private RobotSoftwareSuite robotSoftwareSuite;
        private RenderingEngine renderingEngine;
        private String currentRevisionId;
        private Environment environment;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSimulationApplicationRequest model) {
            super(model);
            this.application(model.application);
            this.sources(model.sources);
            this.simulationSoftwareSuite(model.simulationSoftwareSuite);
            this.robotSoftwareSuite(model.robotSoftwareSuite);
            this.renderingEngine(model.renderingEngine);
            this.currentRevisionId(model.currentRevisionId);
            this.environment(model.environment);
        }

        public final String getApplication() {
            return this.application;
        }

        public final void setApplication(String application) {
            this.application = application;
        }

        @Override
        public final Builder application(String application) {
            this.application = application;
            return this;
        }

        public final List<SourceConfig.Builder> getSources() {
            List<SourceConfig.Builder> result = SourceConfigsCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<SourceConfig.BuilderImpl> sources) {
            this.sources = SourceConfigsCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<SourceConfig> sources) {
            this.sources = SourceConfigsCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(SourceConfig ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<SourceConfig.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (SourceConfig)((SourceConfig.Builder)SourceConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final SimulationSoftwareSuite.Builder getSimulationSoftwareSuite() {
            return this.simulationSoftwareSuite != null ? this.simulationSoftwareSuite.toBuilder() : null;
        }

        public final void setSimulationSoftwareSuite(SimulationSoftwareSuite.BuilderImpl simulationSoftwareSuite) {
            this.simulationSoftwareSuite = simulationSoftwareSuite != null ? simulationSoftwareSuite.build() : null;
        }

        @Override
        public final Builder simulationSoftwareSuite(SimulationSoftwareSuite simulationSoftwareSuite) {
            this.simulationSoftwareSuite = simulationSoftwareSuite;
            return this;
        }

        public final RobotSoftwareSuite.Builder getRobotSoftwareSuite() {
            return this.robotSoftwareSuite != null ? this.robotSoftwareSuite.toBuilder() : null;
        }

        public final void setRobotSoftwareSuite(RobotSoftwareSuite.BuilderImpl robotSoftwareSuite) {
            this.robotSoftwareSuite = robotSoftwareSuite != null ? robotSoftwareSuite.build() : null;
        }

        @Override
        public final Builder robotSoftwareSuite(RobotSoftwareSuite robotSoftwareSuite) {
            this.robotSoftwareSuite = robotSoftwareSuite;
            return this;
        }

        public final RenderingEngine.Builder getRenderingEngine() {
            return this.renderingEngine != null ? this.renderingEngine.toBuilder() : null;
        }

        public final void setRenderingEngine(RenderingEngine.BuilderImpl renderingEngine) {
            this.renderingEngine = renderingEngine != null ? renderingEngine.build() : null;
        }

        @Override
        public final Builder renderingEngine(RenderingEngine renderingEngine) {
            this.renderingEngine = renderingEngine;
            return this;
        }

        public final String getCurrentRevisionId() {
            return this.currentRevisionId;
        }

        public final void setCurrentRevisionId(String currentRevisionId) {
            this.currentRevisionId = currentRevisionId;
        }

        @Override
        public final Builder currentRevisionId(String currentRevisionId) {
            this.currentRevisionId = currentRevisionId;
            return this;
        }

        public final Environment.Builder getEnvironment() {
            return this.environment != null ? this.environment.toBuilder() : null;
        }

        public final void setEnvironment(Environment.BuilderImpl environment) {
            this.environment = environment != null ? environment.build() : null;
        }

        @Override
        public final Builder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSimulationApplicationRequest build() {
            return new UpdateSimulationApplicationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RoboMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSimulationApplicationRequest> {
        public Builder application(String var1);

        public Builder sources(Collection<SourceConfig> var1);

        public Builder sources(SourceConfig ... var1);

        public Builder sources(Consumer<SourceConfig.Builder> ... var1);

        public Builder simulationSoftwareSuite(SimulationSoftwareSuite var1);

        default public Builder simulationSoftwareSuite(Consumer<SimulationSoftwareSuite.Builder> simulationSoftwareSuite) {
            return this.simulationSoftwareSuite((SimulationSoftwareSuite)((SimulationSoftwareSuite.Builder)SimulationSoftwareSuite.builder().applyMutation(simulationSoftwareSuite)).build());
        }

        public Builder robotSoftwareSuite(RobotSoftwareSuite var1);

        default public Builder robotSoftwareSuite(Consumer<RobotSoftwareSuite.Builder> robotSoftwareSuite) {
            return this.robotSoftwareSuite((RobotSoftwareSuite)((RobotSoftwareSuite.Builder)RobotSoftwareSuite.builder().applyMutation(robotSoftwareSuite)).build());
        }

        public Builder renderingEngine(RenderingEngine var1);

        default public Builder renderingEngine(Consumer<RenderingEngine.Builder> renderingEngine) {
            return this.renderingEngine((RenderingEngine)((RenderingEngine.Builder)RenderingEngine.builder().applyMutation(renderingEngine)).build());
        }

        public Builder currentRevisionId(String var1);

        public Builder environment(Environment var1);

        default public Builder environment(Consumer<Environment.Builder> environment) {
            return this.environment((Environment)((Environment.Builder)Environment.builder().applyMutation(environment)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

