/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuite;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RobotApplicationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RobotApplicationSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(RobotApplicationSummary.getter(RobotApplicationSummary::name)).setter(RobotApplicationSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(RobotApplicationSummary.getter(RobotApplicationSummary::arn)).setter(RobotApplicationSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(RobotApplicationSummary.getter(RobotApplicationSummary::version)).setter(RobotApplicationSummary.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(RobotApplicationSummary.getter(RobotApplicationSummary::lastUpdatedAt)).setter(RobotApplicationSummary.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final SdkField<RobotSoftwareSuite> ROBOT_SOFTWARE_SUITE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("robotSoftwareSuite").getter(RobotApplicationSummary.getter(RobotApplicationSummary::robotSoftwareSuite)).setter(RobotApplicationSummary.setter(Builder::robotSoftwareSuite)).constructor(RobotSoftwareSuite::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("robotSoftwareSuite").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, VERSION_FIELD, LAST_UPDATED_AT_FIELD, ROBOT_SOFTWARE_SUITE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RobotApplicationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final String version;
    private final Instant lastUpdatedAt;
    private final RobotSoftwareSuite robotSoftwareSuite;

    private RobotApplicationSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.version = builder.version;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.robotSoftwareSuite = builder.robotSoftwareSuite;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final String version() {
        return this.version;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final RobotSoftwareSuite robotSoftwareSuite() {
        return this.robotSoftwareSuite;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.robotSoftwareSuite());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RobotApplicationSummary)) {
            return false;
        }
        RobotApplicationSummary other = (RobotApplicationSummary)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.robotSoftwareSuite(), other.robotSoftwareSuite());
    }

    public final String toString() {
        return ToString.builder((String)"RobotApplicationSummary").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("Version", (Object)this.version()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("RobotSoftwareSuite", (Object)this.robotSoftwareSuite()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "robotSoftwareSuite": {
                return Optional.ofNullable(clazz.cast(this.robotSoftwareSuite()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("robotSoftwareSuite", ROBOT_SOFTWARE_SUITE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RobotApplicationSummary, T> g) {
        return obj -> g.apply((RobotApplicationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String version;
        private Instant lastUpdatedAt;
        private RobotSoftwareSuite robotSoftwareSuite;

        private BuilderImpl() {
        }

        private BuilderImpl(RobotApplicationSummary model) {
            this.name(model.name);
            this.arn(model.arn);
            this.version(model.version);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.robotSoftwareSuite(model.robotSoftwareSuite);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final RobotSoftwareSuite.Builder getRobotSoftwareSuite() {
            return this.robotSoftwareSuite != null ? this.robotSoftwareSuite.toBuilder() : null;
        }

        public final void setRobotSoftwareSuite(RobotSoftwareSuite.BuilderImpl robotSoftwareSuite) {
            this.robotSoftwareSuite = robotSoftwareSuite != null ? robotSoftwareSuite.build() : null;
        }

        @Override
        public final Builder robotSoftwareSuite(RobotSoftwareSuite robotSoftwareSuite) {
            this.robotSoftwareSuite = robotSoftwareSuite;
            return this;
        }

        public RobotApplicationSummary build() {
            return new RobotApplicationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RobotApplicationSummary> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder version(String var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder robotSoftwareSuite(RobotSoftwareSuite var1);

        default public Builder robotSoftwareSuite(Consumer<RobotSoftwareSuite.Builder> robotSoftwareSuite) {
            return this.robotSoftwareSuite((RobotSoftwareSuite)((RobotSoftwareSuite.Builder)RobotSoftwareSuite.builder().applyMutation(robotSoftwareSuite)).build());
        }
    }
}

