/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.robomaker.model.Environment;
import software.amazon.awssdk.services.robomaker.model.RoboMakerResponse;
import software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuite;
import software.amazon.awssdk.services.robomaker.model.Source;
import software.amazon.awssdk.services.robomaker.model.SourcesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRobotApplicationResponse
extends RoboMakerResponse
implements ToCopyableBuilder<Builder, UpdateRobotApplicationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(UpdateRobotApplicationResponse.getter(UpdateRobotApplicationResponse::arn)).setter(UpdateRobotApplicationResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateRobotApplicationResponse.getter(UpdateRobotApplicationResponse::name)).setter(UpdateRobotApplicationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(UpdateRobotApplicationResponse.getter(UpdateRobotApplicationResponse::version)).setter(UpdateRobotApplicationResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<List<Source>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sources").getter(UpdateRobotApplicationResponse.getter(UpdateRobotApplicationResponse::sources)).setter(UpdateRobotApplicationResponse.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Source::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RobotSoftwareSuite> ROBOT_SOFTWARE_SUITE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("robotSoftwareSuite").getter(UpdateRobotApplicationResponse.getter(UpdateRobotApplicationResponse::robotSoftwareSuite)).setter(UpdateRobotApplicationResponse.setter(Builder::robotSoftwareSuite)).constructor(RobotSoftwareSuite::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("robotSoftwareSuite").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(UpdateRobotApplicationResponse.getter(UpdateRobotApplicationResponse::lastUpdatedAt)).setter(UpdateRobotApplicationResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revisionId").getter(UpdateRobotApplicationResponse.getter(UpdateRobotApplicationResponse::revisionId)).setter(UpdateRobotApplicationResponse.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()}).build();
    private static final SdkField<Environment> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("environment").getter(UpdateRobotApplicationResponse.getter(UpdateRobotApplicationResponse::environment)).setter(UpdateRobotApplicationResponse.setter(Builder::environment)).constructor(Environment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, VERSION_FIELD, SOURCES_FIELD, ROBOT_SOFTWARE_SUITE_FIELD, LAST_UPDATED_AT_FIELD, REVISION_ID_FIELD, ENVIRONMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateRobotApplicationResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String name;
    private final String version;
    private final List<Source> sources;
    private final RobotSoftwareSuite robotSoftwareSuite;
    private final Instant lastUpdatedAt;
    private final String revisionId;
    private final Environment environment;

    private UpdateRobotApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.version = builder.version;
        this.sources = builder.sources;
        this.robotSoftwareSuite = builder.robotSoftwareSuite;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.revisionId = builder.revisionId;
        this.environment = builder.environment;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String version() {
        return this.version;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<Source> sources() {
        return this.sources;
    }

    public final RobotSoftwareSuite robotSoftwareSuite() {
        return this.robotSoftwareSuite;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final String revisionId() {
        return this.revisionId;
    }

    public final Environment environment() {
        return this.environment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.robotSoftwareSuite());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.environment());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRobotApplicationResponse)) {
            return false;
        }
        UpdateRobotApplicationResponse other = (UpdateRobotApplicationResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.version(), other.version()) && this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources()) && Objects.equals(this.robotSoftwareSuite(), other.robotSoftwareSuite()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.revisionId(), other.revisionId()) && Objects.equals(this.environment(), other.environment());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRobotApplicationResponse").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Version", (Object)this.version()).add("Sources", this.hasSources() ? this.sources() : null).add("RobotSoftwareSuite", (Object)this.robotSoftwareSuite()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("RevisionId", (Object)this.revisionId()).add("Environment", (Object)this.environment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
            case "robotSoftwareSuite": {
                return Optional.ofNullable(clazz.cast(this.robotSoftwareSuite()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "revisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
            case "environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("sources", SOURCES_FIELD);
        map.put("robotSoftwareSuite", ROBOT_SOFTWARE_SUITE_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("revisionId", REVISION_ID_FIELD);
        map.put("environment", ENVIRONMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateRobotApplicationResponse, T> g) {
        return obj -> g.apply((UpdateRobotApplicationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RoboMakerResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String version;
        private List<Source> sources = DefaultSdkAutoConstructList.getInstance();
        private RobotSoftwareSuite robotSoftwareSuite;
        private Instant lastUpdatedAt;
        private String revisionId;
        private Environment environment;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRobotApplicationResponse model) {
            super(model);
            this.arn(model.arn);
            this.name(model.name);
            this.version(model.version);
            this.sources(model.sources);
            this.robotSoftwareSuite(model.robotSoftwareSuite);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.revisionId(model.revisionId);
            this.environment(model.environment);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final List<Source.Builder> getSources() {
            List<Source.Builder> result = SourcesCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<Source.BuilderImpl> sources) {
            this.sources = SourcesCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<Source> sources) {
            this.sources = SourcesCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Source ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<Source.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (Source)((Source.Builder)Source.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final RobotSoftwareSuite.Builder getRobotSoftwareSuite() {
            return this.robotSoftwareSuite != null ? this.robotSoftwareSuite.toBuilder() : null;
        }

        public final void setRobotSoftwareSuite(RobotSoftwareSuite.BuilderImpl robotSoftwareSuite) {
            this.robotSoftwareSuite = robotSoftwareSuite != null ? robotSoftwareSuite.build() : null;
        }

        @Override
        public final Builder robotSoftwareSuite(RobotSoftwareSuite robotSoftwareSuite) {
            this.robotSoftwareSuite = robotSoftwareSuite;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final Environment.Builder getEnvironment() {
            return this.environment != null ? this.environment.toBuilder() : null;
        }

        public final void setEnvironment(Environment.BuilderImpl environment) {
            this.environment = environment != null ? environment.build() : null;
        }

        @Override
        public final Builder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        @Override
        public UpdateRobotApplicationResponse build() {
            return new UpdateRobotApplicationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RoboMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRobotApplicationResponse> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder version(String var1);

        public Builder sources(Collection<Source> var1);

        public Builder sources(Source ... var1);

        public Builder sources(Consumer<Source.Builder> ... var1);

        public Builder robotSoftwareSuite(RobotSoftwareSuite var1);

        default public Builder robotSoftwareSuite(Consumer<RobotSoftwareSuite.Builder> robotSoftwareSuite) {
            return this.robotSoftwareSuite((RobotSoftwareSuite)((RobotSoftwareSuite.Builder)RobotSoftwareSuite.builder().applyMutation(robotSoftwareSuite)).build());
        }

        public Builder lastUpdatedAt(Instant var1);

        public Builder revisionId(String var1);

        public Builder environment(Environment var1);

        default public Builder environment(Consumer<Environment.Builder> environment) {
            return this.environment((Environment)((Environment.Builder)Environment.builder().applyMutation(environment)).build());
        }
    }
}

