/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.robomaker.model.LaunchConfig;
import software.amazon.awssdk.services.robomaker.model.Tool;
import software.amazon.awssdk.services.robomaker.model.ToolsCopier;
import software.amazon.awssdk.services.robomaker.model.UploadConfiguration;
import software.amazon.awssdk.services.robomaker.model.UploadConfigurationsCopier;
import software.amazon.awssdk.services.robomaker.model.WorldConfig;
import software.amazon.awssdk.services.robomaker.model.WorldConfigsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SimulationApplicationConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SimulationApplicationConfig> {
    private static final SdkField<String> APPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("application").getter(SimulationApplicationConfig.getter(SimulationApplicationConfig::application)).setter(SimulationApplicationConfig.setter(Builder::application)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("application").build()}).build();
    private static final SdkField<String> APPLICATION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationVersion").getter(SimulationApplicationConfig.getter(SimulationApplicationConfig::applicationVersion)).setter(SimulationApplicationConfig.setter(Builder::applicationVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationVersion").build()}).build();
    private static final SdkField<LaunchConfig> LAUNCH_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("launchConfig").getter(SimulationApplicationConfig.getter(SimulationApplicationConfig::launchConfig)).setter(SimulationApplicationConfig.setter(Builder::launchConfig)).constructor(LaunchConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchConfig").build()}).build();
    private static final SdkField<List<UploadConfiguration>> UPLOAD_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("uploadConfigurations").getter(SimulationApplicationConfig.getter(SimulationApplicationConfig::uploadConfigurations)).setter(SimulationApplicationConfig.setter(Builder::uploadConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UploadConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<WorldConfig>> WORLD_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("worldConfigs").getter(SimulationApplicationConfig.getter(SimulationApplicationConfig::worldConfigs)).setter(SimulationApplicationConfig.setter(Builder::worldConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("worldConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorldConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> USE_DEFAULT_UPLOAD_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("useDefaultUploadConfigurations").getter(SimulationApplicationConfig.getter(SimulationApplicationConfig::useDefaultUploadConfigurations)).setter(SimulationApplicationConfig.setter(Builder::useDefaultUploadConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useDefaultUploadConfigurations").build()}).build();
    private static final SdkField<List<Tool>> TOOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tools").getter(SimulationApplicationConfig.getter(SimulationApplicationConfig::tools)).setter(SimulationApplicationConfig.setter(Builder::tools)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tools").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tool::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> USE_DEFAULT_TOOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("useDefaultTools").getter(SimulationApplicationConfig.getter(SimulationApplicationConfig::useDefaultTools)).setter(SimulationApplicationConfig.setter(Builder::useDefaultTools)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useDefaultTools").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_FIELD, APPLICATION_VERSION_FIELD, LAUNCH_CONFIG_FIELD, UPLOAD_CONFIGURATIONS_FIELD, WORLD_CONFIGS_FIELD, USE_DEFAULT_UPLOAD_CONFIGURATIONS_FIELD, TOOLS_FIELD, USE_DEFAULT_TOOLS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SimulationApplicationConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String application;
    private final String applicationVersion;
    private final LaunchConfig launchConfig;
    private final List<UploadConfiguration> uploadConfigurations;
    private final List<WorldConfig> worldConfigs;
    private final Boolean useDefaultUploadConfigurations;
    private final List<Tool> tools;
    private final Boolean useDefaultTools;

    private SimulationApplicationConfig(BuilderImpl builder) {
        this.application = builder.application;
        this.applicationVersion = builder.applicationVersion;
        this.launchConfig = builder.launchConfig;
        this.uploadConfigurations = builder.uploadConfigurations;
        this.worldConfigs = builder.worldConfigs;
        this.useDefaultUploadConfigurations = builder.useDefaultUploadConfigurations;
        this.tools = builder.tools;
        this.useDefaultTools = builder.useDefaultTools;
    }

    public final String application() {
        return this.application;
    }

    public final String applicationVersion() {
        return this.applicationVersion;
    }

    public final LaunchConfig launchConfig() {
        return this.launchConfig;
    }

    public final boolean hasUploadConfigurations() {
        return this.uploadConfigurations != null && !(this.uploadConfigurations instanceof SdkAutoConstructList);
    }

    public final List<UploadConfiguration> uploadConfigurations() {
        return this.uploadConfigurations;
    }

    public final boolean hasWorldConfigs() {
        return this.worldConfigs != null && !(this.worldConfigs instanceof SdkAutoConstructList);
    }

    public final List<WorldConfig> worldConfigs() {
        return this.worldConfigs;
    }

    @Deprecated
    public final Boolean useDefaultUploadConfigurations() {
        return this.useDefaultUploadConfigurations;
    }

    public final boolean hasTools() {
        return this.tools != null && !(this.tools instanceof SdkAutoConstructList);
    }

    public final List<Tool> tools() {
        return this.tools;
    }

    @Deprecated
    public final Boolean useDefaultTools() {
        return this.useDefaultTools;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.application());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUploadConfigurations() ? this.uploadConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorldConfigs() ? this.worldConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.useDefaultUploadConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTools() ? this.tools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.useDefaultTools());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimulationApplicationConfig)) {
            return false;
        }
        SimulationApplicationConfig other = (SimulationApplicationConfig)obj;
        return Objects.equals(this.application(), other.application()) && Objects.equals(this.applicationVersion(), other.applicationVersion()) && Objects.equals(this.launchConfig(), other.launchConfig()) && this.hasUploadConfigurations() == other.hasUploadConfigurations() && Objects.equals(this.uploadConfigurations(), other.uploadConfigurations()) && this.hasWorldConfigs() == other.hasWorldConfigs() && Objects.equals(this.worldConfigs(), other.worldConfigs()) && Objects.equals(this.useDefaultUploadConfigurations(), other.useDefaultUploadConfigurations()) && this.hasTools() == other.hasTools() && Objects.equals(this.tools(), other.tools()) && Objects.equals(this.useDefaultTools(), other.useDefaultTools());
    }

    public final String toString() {
        return ToString.builder((String)"SimulationApplicationConfig").add("Application", (Object)this.application()).add("ApplicationVersion", (Object)this.applicationVersion()).add("LaunchConfig", (Object)this.launchConfig()).add("UploadConfigurations", this.hasUploadConfigurations() ? this.uploadConfigurations() : null).add("WorldConfigs", this.hasWorldConfigs() ? this.worldConfigs() : null).add("UseDefaultUploadConfigurations", (Object)this.useDefaultUploadConfigurations()).add("Tools", this.hasTools() ? this.tools() : null).add("UseDefaultTools", (Object)this.useDefaultTools()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "application": {
                return Optional.ofNullable(clazz.cast(this.application()));
            }
            case "applicationVersion": {
                return Optional.ofNullable(clazz.cast(this.applicationVersion()));
            }
            case "launchConfig": {
                return Optional.ofNullable(clazz.cast(this.launchConfig()));
            }
            case "uploadConfigurations": {
                return Optional.ofNullable(clazz.cast(this.uploadConfigurations()));
            }
            case "worldConfigs": {
                return Optional.ofNullable(clazz.cast(this.worldConfigs()));
            }
            case "useDefaultUploadConfigurations": {
                return Optional.ofNullable(clazz.cast(this.useDefaultUploadConfigurations()));
            }
            case "tools": {
                return Optional.ofNullable(clazz.cast(this.tools()));
            }
            case "useDefaultTools": {
                return Optional.ofNullable(clazz.cast(this.useDefaultTools()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("application", APPLICATION_FIELD);
        map.put("applicationVersion", APPLICATION_VERSION_FIELD);
        map.put("launchConfig", LAUNCH_CONFIG_FIELD);
        map.put("uploadConfigurations", UPLOAD_CONFIGURATIONS_FIELD);
        map.put("worldConfigs", WORLD_CONFIGS_FIELD);
        map.put("useDefaultUploadConfigurations", USE_DEFAULT_UPLOAD_CONFIGURATIONS_FIELD);
        map.put("tools", TOOLS_FIELD);
        map.put("useDefaultTools", USE_DEFAULT_TOOLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SimulationApplicationConfig, T> g) {
        return obj -> g.apply((SimulationApplicationConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String application;
        private String applicationVersion;
        private LaunchConfig launchConfig;
        private List<UploadConfiguration> uploadConfigurations = DefaultSdkAutoConstructList.getInstance();
        private List<WorldConfig> worldConfigs = DefaultSdkAutoConstructList.getInstance();
        private Boolean useDefaultUploadConfigurations;
        private List<Tool> tools = DefaultSdkAutoConstructList.getInstance();
        private Boolean useDefaultTools;

        private BuilderImpl() {
        }

        private BuilderImpl(SimulationApplicationConfig model) {
            this.application(model.application);
            this.applicationVersion(model.applicationVersion);
            this.launchConfig(model.launchConfig);
            this.uploadConfigurations(model.uploadConfigurations);
            this.worldConfigs(model.worldConfigs);
            this.useDefaultUploadConfigurations(model.useDefaultUploadConfigurations);
            this.tools(model.tools);
            this.useDefaultTools(model.useDefaultTools);
        }

        public final String getApplication() {
            return this.application;
        }

        public final void setApplication(String application) {
            this.application = application;
        }

        @Override
        public final Builder application(String application) {
            this.application = application;
            return this;
        }

        public final String getApplicationVersion() {
            return this.applicationVersion;
        }

        public final void setApplicationVersion(String applicationVersion) {
            this.applicationVersion = applicationVersion;
        }

        @Override
        public final Builder applicationVersion(String applicationVersion) {
            this.applicationVersion = applicationVersion;
            return this;
        }

        public final LaunchConfig.Builder getLaunchConfig() {
            return this.launchConfig != null ? this.launchConfig.toBuilder() : null;
        }

        public final void setLaunchConfig(LaunchConfig.BuilderImpl launchConfig) {
            this.launchConfig = launchConfig != null ? launchConfig.build() : null;
        }

        @Override
        public final Builder launchConfig(LaunchConfig launchConfig) {
            this.launchConfig = launchConfig;
            return this;
        }

        public final List<UploadConfiguration.Builder> getUploadConfigurations() {
            List<UploadConfiguration.Builder> result = UploadConfigurationsCopier.copyToBuilder(this.uploadConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUploadConfigurations(Collection<UploadConfiguration.BuilderImpl> uploadConfigurations) {
            this.uploadConfigurations = UploadConfigurationsCopier.copyFromBuilder(uploadConfigurations);
        }

        @Override
        public final Builder uploadConfigurations(Collection<UploadConfiguration> uploadConfigurations) {
            this.uploadConfigurations = UploadConfigurationsCopier.copy(uploadConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder uploadConfigurations(UploadConfiguration ... uploadConfigurations) {
            this.uploadConfigurations(Arrays.asList(uploadConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder uploadConfigurations(Consumer<UploadConfiguration.Builder> ... uploadConfigurations) {
            this.uploadConfigurations(Stream.of(uploadConfigurations).map(c -> (UploadConfiguration)((UploadConfiguration.Builder)UploadConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<WorldConfig.Builder> getWorldConfigs() {
            List<WorldConfig.Builder> result = WorldConfigsCopier.copyToBuilder(this.worldConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorldConfigs(Collection<WorldConfig.BuilderImpl> worldConfigs) {
            this.worldConfigs = WorldConfigsCopier.copyFromBuilder(worldConfigs);
        }

        @Override
        public final Builder worldConfigs(Collection<WorldConfig> worldConfigs) {
            this.worldConfigs = WorldConfigsCopier.copy(worldConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder worldConfigs(WorldConfig ... worldConfigs) {
            this.worldConfigs(Arrays.asList(worldConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder worldConfigs(Consumer<WorldConfig.Builder> ... worldConfigs) {
            this.worldConfigs(Stream.of(worldConfigs).map(c -> (WorldConfig)((WorldConfig.Builder)WorldConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Deprecated
        public final Boolean getUseDefaultUploadConfigurations() {
            return this.useDefaultUploadConfigurations;
        }

        @Deprecated
        public final void setUseDefaultUploadConfigurations(Boolean useDefaultUploadConfigurations) {
            this.useDefaultUploadConfigurations = useDefaultUploadConfigurations;
        }

        @Override
        @Deprecated
        public final Builder useDefaultUploadConfigurations(Boolean useDefaultUploadConfigurations) {
            this.useDefaultUploadConfigurations = useDefaultUploadConfigurations;
            return this;
        }

        public final List<Tool.Builder> getTools() {
            List<Tool.Builder> result = ToolsCopier.copyToBuilder(this.tools);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTools(Collection<Tool.BuilderImpl> tools) {
            this.tools = ToolsCopier.copyFromBuilder(tools);
        }

        @Override
        public final Builder tools(Collection<Tool> tools) {
            this.tools = ToolsCopier.copy(tools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tools(Tool ... tools) {
            this.tools(Arrays.asList(tools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tools(Consumer<Tool.Builder> ... tools) {
            this.tools(Stream.of(tools).map(c -> (Tool)((Tool.Builder)Tool.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Deprecated
        public final Boolean getUseDefaultTools() {
            return this.useDefaultTools;
        }

        @Deprecated
        public final void setUseDefaultTools(Boolean useDefaultTools) {
            this.useDefaultTools = useDefaultTools;
        }

        @Override
        @Deprecated
        public final Builder useDefaultTools(Boolean useDefaultTools) {
            this.useDefaultTools = useDefaultTools;
            return this;
        }

        public SimulationApplicationConfig build() {
            return new SimulationApplicationConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SimulationApplicationConfig> {
        public Builder application(String var1);

        public Builder applicationVersion(String var1);

        public Builder launchConfig(LaunchConfig var1);

        default public Builder launchConfig(Consumer<LaunchConfig.Builder> launchConfig) {
            return this.launchConfig((LaunchConfig)((LaunchConfig.Builder)LaunchConfig.builder().applyMutation(launchConfig)).build());
        }

        public Builder uploadConfigurations(Collection<UploadConfiguration> var1);

        public Builder uploadConfigurations(UploadConfiguration ... var1);

        public Builder uploadConfigurations(Consumer<UploadConfiguration.Builder> ... var1);

        public Builder worldConfigs(Collection<WorldConfig> var1);

        public Builder worldConfigs(WorldConfig ... var1);

        public Builder worldConfigs(Consumer<WorldConfig.Builder> ... var1);

        @Deprecated
        public Builder useDefaultUploadConfigurations(Boolean var1);

        public Builder tools(Collection<Tool> var1);

        public Builder tools(Tool ... var1);

        public Builder tools(Consumer<Tool.Builder> ... var1);

        @Deprecated
        public Builder useDefaultTools(Boolean var1);
    }
}

