/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.robomaker.model.WorldFailure;
import software.amazon.awssdk.services.robomaker.model.WorldFailuresCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FailureSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FailureSummary> {
    private static final SdkField<Integer> TOTAL_FAILURE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("totalFailureCount").getter(FailureSummary.getter(FailureSummary::totalFailureCount)).setter(FailureSummary.setter(Builder::totalFailureCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalFailureCount").build()}).build();
    private static final SdkField<List<WorldFailure>> FAILURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failures").getter(FailureSummary.getter(FailureSummary::failures)).setter(FailureSummary.setter(Builder::failures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorldFailure::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_FAILURE_COUNT_FIELD, FAILURES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("totalFailureCount", TOTAL_FAILURE_COUNT_FIELD);
            this.put("failures", FAILURES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer totalFailureCount;
    private final List<WorldFailure> failures;

    private FailureSummary(BuilderImpl builder) {
        this.totalFailureCount = builder.totalFailureCount;
        this.failures = builder.failures;
    }

    public final Integer totalFailureCount() {
        return this.totalFailureCount;
    }

    public final boolean hasFailures() {
        return this.failures != null && !(this.failures instanceof SdkAutoConstructList);
    }

    public final List<WorldFailure> failures() {
        return this.failures;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.totalFailureCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailures() ? this.failures() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailureSummary)) {
            return false;
        }
        FailureSummary other = (FailureSummary)obj;
        return Objects.equals(this.totalFailureCount(), other.totalFailureCount()) && this.hasFailures() == other.hasFailures() && Objects.equals(this.failures(), other.failures());
    }

    public final String toString() {
        return ToString.builder((String)"FailureSummary").add("TotalFailureCount", (Object)this.totalFailureCount()).add("Failures", this.hasFailures() ? this.failures() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "totalFailureCount": {
                return Optional.ofNullable(clazz.cast(this.totalFailureCount()));
            }
            case "failures": {
                return Optional.ofNullable(clazz.cast(this.failures()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FailureSummary, T> g) {
        return obj -> g.apply((FailureSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer totalFailureCount;
        private List<WorldFailure> failures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FailureSummary model) {
            this.totalFailureCount(model.totalFailureCount);
            this.failures(model.failures);
        }

        public final Integer getTotalFailureCount() {
            return this.totalFailureCount;
        }

        public final void setTotalFailureCount(Integer totalFailureCount) {
            this.totalFailureCount = totalFailureCount;
        }

        @Override
        public final Builder totalFailureCount(Integer totalFailureCount) {
            this.totalFailureCount = totalFailureCount;
            return this;
        }

        public final List<WorldFailure.Builder> getFailures() {
            List<WorldFailure.Builder> result = WorldFailuresCopier.copyToBuilder(this.failures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailures(Collection<WorldFailure.BuilderImpl> failures) {
            this.failures = WorldFailuresCopier.copyFromBuilder(failures);
        }

        @Override
        public final Builder failures(Collection<WorldFailure> failures) {
            this.failures = WorldFailuresCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(WorldFailure ... failures) {
            this.failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Consumer<WorldFailure.Builder> ... failures) {
            this.failures(Stream.of(failures).map(c -> (WorldFailure)((WorldFailure.Builder)WorldFailure.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public FailureSummary build() {
            return new FailureSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FailureSummary> {
        public Builder totalFailureCount(Integer var1);

        public Builder failures(Collection<WorldFailure> var1);

        public Builder failures(WorldFailure ... var1);

        public Builder failures(Consumer<WorldFailure.Builder> ... var1);
    }
}

