/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.robomaker.model.ComputeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Compute
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Compute> {
    private static final SdkField<Integer> SIMULATION_UNIT_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("simulationUnitLimit").getter(Compute.getter(Compute::simulationUnitLimit)).setter(Compute.setter(Builder::simulationUnitLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("simulationUnitLimit").build()}).build();
    private static final SdkField<String> COMPUTE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computeType").getter(Compute.getter(Compute::computeTypeAsString)).setter(Compute.setter(Builder::computeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeType").build()}).build();
    private static final SdkField<Integer> GPU_UNIT_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("gpuUnitLimit").getter(Compute.getter(Compute::gpuUnitLimit)).setter(Compute.setter(Builder::gpuUnitLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gpuUnitLimit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIMULATION_UNIT_LIMIT_FIELD, COMPUTE_TYPE_FIELD, GPU_UNIT_LIMIT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Compute.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer simulationUnitLimit;
    private final String computeType;
    private final Integer gpuUnitLimit;

    private Compute(BuilderImpl builder) {
        this.simulationUnitLimit = builder.simulationUnitLimit;
        this.computeType = builder.computeType;
        this.gpuUnitLimit = builder.gpuUnitLimit;
    }

    public final Integer simulationUnitLimit() {
        return this.simulationUnitLimit;
    }

    public final ComputeType computeType() {
        return ComputeType.fromValue(this.computeType);
    }

    public final String computeTypeAsString() {
        return this.computeType;
    }

    public final Integer gpuUnitLimit() {
        return this.gpuUnitLimit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.simulationUnitLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.gpuUnitLimit());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Compute)) {
            return false;
        }
        Compute other = (Compute)obj;
        return Objects.equals(this.simulationUnitLimit(), other.simulationUnitLimit()) && Objects.equals(this.computeTypeAsString(), other.computeTypeAsString()) && Objects.equals(this.gpuUnitLimit(), other.gpuUnitLimit());
    }

    public final String toString() {
        return ToString.builder((String)"Compute").add("SimulationUnitLimit", (Object)this.simulationUnitLimit()).add("ComputeType", (Object)this.computeTypeAsString()).add("GpuUnitLimit", (Object)this.gpuUnitLimit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "simulationUnitLimit": {
                return Optional.ofNullable(clazz.cast(this.simulationUnitLimit()));
            }
            case "computeType": {
                return Optional.ofNullable(clazz.cast(this.computeTypeAsString()));
            }
            case "gpuUnitLimit": {
                return Optional.ofNullable(clazz.cast(this.gpuUnitLimit()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("simulationUnitLimit", SIMULATION_UNIT_LIMIT_FIELD);
        map.put("computeType", COMPUTE_TYPE_FIELD);
        map.put("gpuUnitLimit", GPU_UNIT_LIMIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Compute, T> g) {
        return obj -> g.apply((Compute)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer simulationUnitLimit;
        private String computeType;
        private Integer gpuUnitLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(Compute model) {
            this.simulationUnitLimit(model.simulationUnitLimit);
            this.computeType(model.computeType);
            this.gpuUnitLimit(model.gpuUnitLimit);
        }

        public final Integer getSimulationUnitLimit() {
            return this.simulationUnitLimit;
        }

        public final void setSimulationUnitLimit(Integer simulationUnitLimit) {
            this.simulationUnitLimit = simulationUnitLimit;
        }

        @Override
        public final Builder simulationUnitLimit(Integer simulationUnitLimit) {
            this.simulationUnitLimit = simulationUnitLimit;
            return this;
        }

        public final String getComputeType() {
            return this.computeType;
        }

        public final void setComputeType(String computeType) {
            this.computeType = computeType;
        }

        @Override
        public final Builder computeType(String computeType) {
            this.computeType = computeType;
            return this;
        }

        @Override
        public final Builder computeType(ComputeType computeType) {
            this.computeType(computeType == null ? null : computeType.toString());
            return this;
        }

        public final Integer getGpuUnitLimit() {
            return this.gpuUnitLimit;
        }

        public final void setGpuUnitLimit(Integer gpuUnitLimit) {
            this.gpuUnitLimit = gpuUnitLimit;
        }

        @Override
        public final Builder gpuUnitLimit(Integer gpuUnitLimit) {
            this.gpuUnitLimit = gpuUnitLimit;
            return this;
        }

        public Compute build() {
            return new Compute(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Compute> {
        public Builder simulationUnitLimit(Integer var1);

        public Builder computeType(String var1);

        public Builder computeType(ComputeType var1);

        public Builder gpuUnitLimit(Integer var1);
    }
}

