/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.robomaker.model.RoboMakerRequest;
import software.amazon.awssdk.services.robomaker.model.TagMapCopier;
import software.amazon.awssdk.services.robomaker.model.TemplateLocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWorldTemplateRequest
extends RoboMakerRequest
implements ToCopyableBuilder<Builder, CreateWorldTemplateRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(CreateWorldTemplateRequest.getter(CreateWorldTemplateRequest::clientRequestToken)).setter(CreateWorldTemplateRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateWorldTemplateRequest.getter(CreateWorldTemplateRequest::name)).setter(CreateWorldTemplateRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateBody").getter(CreateWorldTemplateRequest.getter(CreateWorldTemplateRequest::templateBody)).setter(CreateWorldTemplateRequest.setter(Builder::templateBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateBody").build()}).build();
    private static final SdkField<TemplateLocation> TEMPLATE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("templateLocation").getter(CreateWorldTemplateRequest.getter(CreateWorldTemplateRequest::templateLocation)).setter(CreateWorldTemplateRequest.setter(Builder::templateLocation)).constructor(TemplateLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateLocation").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateWorldTemplateRequest.getter(CreateWorldTemplateRequest::tags)).setter(CreateWorldTemplateRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD, NAME_FIELD, TEMPLATE_BODY_FIELD, TEMPLATE_LOCATION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
            this.put("name", NAME_FIELD);
            this.put("templateBody", TEMPLATE_BODY_FIELD);
            this.put("templateLocation", TEMPLATE_LOCATION_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String clientRequestToken;
    private final String name;
    private final String templateBody;
    private final TemplateLocation templateLocation;
    private final Map<String, String> tags;

    private CreateWorldTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.name = builder.name;
        this.templateBody = builder.templateBody;
        this.templateLocation = builder.templateLocation;
        this.tags = builder.tags;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String name() {
        return this.name;
    }

    public final String templateBody() {
        return this.templateBody;
    }

    public final TemplateLocation templateLocation() {
        return this.templateLocation;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorldTemplateRequest)) {
            return false;
        }
        CreateWorldTemplateRequest other = (CreateWorldTemplateRequest)((Object)obj);
        return Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.templateBody(), other.templateBody()) && Objects.equals(this.templateLocation(), other.templateLocation()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWorldTemplateRequest").add("ClientRequestToken", (Object)this.clientRequestToken()).add("Name", (Object)this.name()).add("TemplateBody", (Object)this.templateBody()).add("TemplateLocation", (Object)this.templateLocation()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "templateBody": {
                return Optional.ofNullable(clazz.cast(this.templateBody()));
            }
            case "templateLocation": {
                return Optional.ofNullable(clazz.cast(this.templateLocation()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorldTemplateRequest, T> g) {
        return obj -> g.apply((CreateWorldTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RoboMakerRequest.BuilderImpl
    implements Builder {
        private String clientRequestToken;
        private String name;
        private String templateBody;
        private TemplateLocation templateLocation;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorldTemplateRequest model) {
            super(model);
            this.clientRequestToken(model.clientRequestToken);
            this.name(model.name);
            this.templateBody(model.templateBody);
            this.templateLocation(model.templateLocation);
            this.tags(model.tags);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getTemplateBody() {
            return this.templateBody;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final TemplateLocation.Builder getTemplateLocation() {
            return this.templateLocation != null ? this.templateLocation.toBuilder() : null;
        }

        public final void setTemplateLocation(TemplateLocation.BuilderImpl templateLocation) {
            this.templateLocation = templateLocation != null ? templateLocation.build() : null;
        }

        @Override
        public final Builder templateLocation(TemplateLocation templateLocation) {
            this.templateLocation = templateLocation;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorldTemplateRequest build() {
            return new CreateWorldTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RoboMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWorldTemplateRequest> {
        public Builder clientRequestToken(String var1);

        public Builder name(String var1);

        public Builder templateBody(String var1);

        public Builder templateLocation(TemplateLocation var1);

        default public Builder templateLocation(Consumer<TemplateLocation.Builder> templateLocation) {
            return this.templateLocation((TemplateLocation)((TemplateLocation.Builder)TemplateLocation.builder().applyMutation(templateLocation)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

