/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.robomaker.RoboMakerAsyncClient;
import software.amazon.awssdk.services.robomaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.robomaker.model.ListWorldTemplatesRequest;
import software.amazon.awssdk.services.robomaker.model.ListWorldTemplatesResponse;
import software.amazon.awssdk.services.robomaker.model.TemplateSummary;

public class ListWorldTemplatesPublisher
implements SdkPublisher<ListWorldTemplatesResponse> {
    private final RoboMakerAsyncClient client;
    private final ListWorldTemplatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWorldTemplatesPublisher(RoboMakerAsyncClient client, ListWorldTemplatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWorldTemplatesPublisher(RoboMakerAsyncClient client, ListWorldTemplatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWorldTemplatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWorldTemplatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TemplateSummary> templateSummaries() {
        Function<ListWorldTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.templateSummaries() != null) {
                return response.templateSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWorldTemplatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWorldTemplatesResponseFetcher
    implements AsyncPageFetcher<ListWorldTemplatesResponse> {
        private ListWorldTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListWorldTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWorldTemplatesResponse> nextPage(ListWorldTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListWorldTemplatesPublisher.this.client.listWorldTemplates(ListWorldTemplatesPublisher.this.firstRequest);
            }
            return ListWorldTemplatesPublisher.this.client.listWorldTemplates((ListWorldTemplatesRequest)((Object)ListWorldTemplatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

