/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode;
import software.amazon.awssdk.services.robomaker.model.SimulationJobRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FailedCreateSimulationJobRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FailedCreateSimulationJobRequest> {
    private static final SdkField<SimulationJobRequest> REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("request").getter(FailedCreateSimulationJobRequest.getter(FailedCreateSimulationJobRequest::request)).setter(FailedCreateSimulationJobRequest.setter(Builder::request)).constructor(SimulationJobRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("request").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(FailedCreateSimulationJobRequest.getter(FailedCreateSimulationJobRequest::failureReason)).setter(FailedCreateSimulationJobRequest.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureCode").getter(FailedCreateSimulationJobRequest.getter(FailedCreateSimulationJobRequest::failureCodeAsString)).setter(FailedCreateSimulationJobRequest.setter(Builder::failureCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()}).build();
    private static final SdkField<Instant> FAILED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("failedAt").getter(FailedCreateSimulationJobRequest.getter(FailedCreateSimulationJobRequest::failedAt)).setter(FailedCreateSimulationJobRequest.setter(Builder::failedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_FIELD, FAILURE_REASON_FIELD, FAILURE_CODE_FIELD, FAILED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final SimulationJobRequest request;
    private final String failureReason;
    private final String failureCode;
    private final Instant failedAt;

    private FailedCreateSimulationJobRequest(BuilderImpl builder) {
        this.request = builder.request;
        this.failureReason = builder.failureReason;
        this.failureCode = builder.failureCode;
        this.failedAt = builder.failedAt;
    }

    public final SimulationJobRequest request() {
        return this.request;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final SimulationJobErrorCode failureCode() {
        return SimulationJobErrorCode.fromValue(this.failureCode);
    }

    public final String failureCodeAsString() {
        return this.failureCode;
    }

    public final Instant failedAt() {
        return this.failedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.request());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailedCreateSimulationJobRequest)) {
            return false;
        }
        FailedCreateSimulationJobRequest other = (FailedCreateSimulationJobRequest)obj;
        return Objects.equals(this.request(), other.request()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.failureCodeAsString(), other.failureCodeAsString()) && Objects.equals(this.failedAt(), other.failedAt());
    }

    public final String toString() {
        return ToString.builder((String)"FailedCreateSimulationJobRequest").add("Request", (Object)this.request()).add("FailureReason", (Object)this.failureReason()).add("FailureCode", (Object)this.failureCodeAsString()).add("FailedAt", (Object)this.failedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "request": {
                return Optional.ofNullable(clazz.cast(this.request()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "failureCode": {
                return Optional.ofNullable(clazz.cast(this.failureCodeAsString()));
            }
            case "failedAt": {
                return Optional.ofNullable(clazz.cast(this.failedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FailedCreateSimulationJobRequest, T> g) {
        return obj -> g.apply((FailedCreateSimulationJobRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SimulationJobRequest request;
        private String failureReason;
        private String failureCode;
        private Instant failedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(FailedCreateSimulationJobRequest model) {
            this.request(model.request);
            this.failureReason(model.failureReason);
            this.failureCode(model.failureCode);
            this.failedAt(model.failedAt);
        }

        public final SimulationJobRequest.Builder getRequest() {
            return this.request != null ? this.request.toBuilder() : null;
        }

        public final void setRequest(SimulationJobRequest.BuilderImpl request) {
            this.request = request != null ? request.build() : null;
        }

        @Override
        public final Builder request(SimulationJobRequest request) {
            this.request = request;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getFailureCode() {
            return this.failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(SimulationJobErrorCode failureCode) {
            this.failureCode(failureCode == null ? null : failureCode.toString());
            return this;
        }

        public final Instant getFailedAt() {
            return this.failedAt;
        }

        public final void setFailedAt(Instant failedAt) {
            this.failedAt = failedAt;
        }

        @Override
        public final Builder failedAt(Instant failedAt) {
            this.failedAt = failedAt;
            return this;
        }

        public FailedCreateSimulationJobRequest build() {
            return new FailedCreateSimulationJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FailedCreateSimulationJobRequest> {
        public Builder request(SimulationJobRequest var1);

        default public Builder request(Consumer<SimulationJobRequest.Builder> request) {
            return this.request((SimulationJobRequest)((SimulationJobRequest.Builder)SimulationJobRequest.builder().applyMutation(request)).build());
        }

        public Builder failureReason(String var1);

        public Builder failureCode(String var1);

        public Builder failureCode(SimulationJobErrorCode var1);

        public Builder failedAt(Instant var1);
    }
}

