/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.robomaker.RoboMakerAsyncClient;
import software.amazon.awssdk.services.robomaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsRequest;
import software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsResponse;
import software.amazon.awssdk.services.robomaker.model.SimulationApplicationSummary;

public class ListSimulationApplicationsPublisher
implements SdkPublisher<ListSimulationApplicationsResponse> {
    private final RoboMakerAsyncClient client;
    private final ListSimulationApplicationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSimulationApplicationsPublisher(RoboMakerAsyncClient client, ListSimulationApplicationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSimulationApplicationsPublisher(RoboMakerAsyncClient client, ListSimulationApplicationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSimulationApplicationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSimulationApplicationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SimulationApplicationSummary> simulationApplicationSummaries() {
        Function<ListSimulationApplicationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.simulationApplicationSummaries() != null) {
                return response.simulationApplicationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSimulationApplicationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSimulationApplicationsResponseFetcher
    implements AsyncPageFetcher<ListSimulationApplicationsResponse> {
        private ListSimulationApplicationsResponseFetcher() {
        }

        public boolean hasNextPage(ListSimulationApplicationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSimulationApplicationsResponse> nextPage(ListSimulationApplicationsResponse previousPage) {
            if (previousPage == null) {
                return ListSimulationApplicationsPublisher.this.client.listSimulationApplications(ListSimulationApplicationsPublisher.this.firstRequest);
            }
            return ListSimulationApplicationsPublisher.this.client.listSimulationApplications((ListSimulationApplicationsRequest)((Object)ListSimulationApplicationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

