/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.robomaker.model.Architecture;
import software.amazon.awssdk.services.robomaker.model.RoboMakerRequest;
import software.amazon.awssdk.services.robomaker.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRobotRequest
extends RoboMakerRequest
implements ToCopyableBuilder<Builder, CreateRobotRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateRobotRequest.getter(CreateRobotRequest::name)).setter(CreateRobotRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("architecture").getter(CreateRobotRequest.getter(CreateRobotRequest::architectureAsString)).setter(CreateRobotRequest.setter(Builder::architecture)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("architecture").build()}).build();
    private static final SdkField<String> GREENGRASS_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("greengrassGroupId").getter(CreateRobotRequest.getter(CreateRobotRequest::greengrassGroupId)).setter(CreateRobotRequest.setter(Builder::greengrassGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greengrassGroupId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateRobotRequest.getter(CreateRobotRequest::tags)).setter(CreateRobotRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARCHITECTURE_FIELD, GREENGRASS_GROUP_ID_FIELD, TAGS_FIELD));
    private final String name;
    private final String architecture;
    private final String greengrassGroupId;
    private final Map<String, String> tags;

    private CreateRobotRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.architecture = builder.architecture;
        this.greengrassGroupId = builder.greengrassGroupId;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final Architecture architecture() {
        return Architecture.fromValue(this.architecture);
    }

    public final String architectureAsString() {
        return this.architecture;
    }

    public final String greengrassGroupId() {
        return this.greengrassGroupId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.architectureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.greengrassGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRobotRequest)) {
            return false;
        }
        CreateRobotRequest other = (CreateRobotRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.architectureAsString(), other.architectureAsString()) && Objects.equals(this.greengrassGroupId(), other.greengrassGroupId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRobotRequest").add("Name", (Object)this.name()).add("Architecture", (Object)this.architectureAsString()).add("GreengrassGroupId", (Object)this.greengrassGroupId()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "architecture": {
                return Optional.ofNullable(clazz.cast(this.architectureAsString()));
            }
            case "greengrassGroupId": {
                return Optional.ofNullable(clazz.cast(this.greengrassGroupId()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRobotRequest, T> g) {
        return obj -> g.apply((CreateRobotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RoboMakerRequest.BuilderImpl
    implements Builder {
        private String name;
        private String architecture;
        private String greengrassGroupId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRobotRequest model) {
            super(model);
            this.name(model.name);
            this.architecture(model.architecture);
            this.greengrassGroupId(model.greengrassGroupId);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @Override
        @Transient
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        @Transient
        public final Builder architecture(Architecture architecture) {
            this.architecture(architecture == null ? null : architecture.toString());
            return this;
        }

        public final String getGreengrassGroupId() {
            return this.greengrassGroupId;
        }

        public final void setGreengrassGroupId(String greengrassGroupId) {
            this.greengrassGroupId = greengrassGroupId;
        }

        @Override
        @Transient
        public final Builder greengrassGroupId(String greengrassGroupId) {
            this.greengrassGroupId = greengrassGroupId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRobotRequest build() {
            return new CreateRobotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RoboMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRobotRequest> {
        public Builder name(String var1);

        public Builder architecture(String var1);

        public Builder architecture(Architecture var1);

        public Builder greengrassGroupId(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

