/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.robomaker.model.DeploymentStatus;
import software.amazon.awssdk.services.robomaker.model.RoboMakerResponse;
import software.amazon.awssdk.services.robomaker.model.Robot;
import software.amazon.awssdk.services.robomaker.model.RobotsCopier;
import software.amazon.awssdk.services.robomaker.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFleetResponse
extends RoboMakerResponse
implements ToCopyableBuilder<Builder, DescribeFleetResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DescribeFleetResponse.getter(DescribeFleetResponse::name)).setter(DescribeFleetResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(DescribeFleetResponse.getter(DescribeFleetResponse::arn)).setter(DescribeFleetResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<List<Robot>> ROBOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("robots").getter(DescribeFleetResponse.getter(DescribeFleetResponse::robots)).setter(DescribeFleetResponse.setter(Builder::robots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("robots").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Robot::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(DescribeFleetResponse.getter(DescribeFleetResponse::createdAt)).setter(DescribeFleetResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> LAST_DEPLOYMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastDeploymentStatus").getter(DescribeFleetResponse.getter(DescribeFleetResponse::lastDeploymentStatusAsString)).setter(DescribeFleetResponse.setter(Builder::lastDeploymentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDeploymentStatus").build()}).build();
    private static final SdkField<String> LAST_DEPLOYMENT_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastDeploymentJob").getter(DescribeFleetResponse.getter(DescribeFleetResponse::lastDeploymentJob)).setter(DescribeFleetResponse.setter(Builder::lastDeploymentJob)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDeploymentJob").build()}).build();
    private static final SdkField<Instant> LAST_DEPLOYMENT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastDeploymentTime").getter(DescribeFleetResponse.getter(DescribeFleetResponse::lastDeploymentTime)).setter(DescribeFleetResponse.setter(Builder::lastDeploymentTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDeploymentTime").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(DescribeFleetResponse.getter(DescribeFleetResponse::tags)).setter(DescribeFleetResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, ROBOTS_FIELD, CREATED_AT_FIELD, LAST_DEPLOYMENT_STATUS_FIELD, LAST_DEPLOYMENT_JOB_FIELD, LAST_DEPLOYMENT_TIME_FIELD, TAGS_FIELD));
    private final String name;
    private final String arn;
    private final List<Robot> robots;
    private final Instant createdAt;
    private final String lastDeploymentStatus;
    private final String lastDeploymentJob;
    private final Instant lastDeploymentTime;
    private final Map<String, String> tags;

    private DescribeFleetResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.arn = builder.arn;
        this.robots = builder.robots;
        this.createdAt = builder.createdAt;
        this.lastDeploymentStatus = builder.lastDeploymentStatus;
        this.lastDeploymentJob = builder.lastDeploymentJob;
        this.lastDeploymentTime = builder.lastDeploymentTime;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasRobots() {
        return this.robots != null && !(this.robots instanceof SdkAutoConstructList);
    }

    public final List<Robot> robots() {
        return this.robots;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final DeploymentStatus lastDeploymentStatus() {
        return DeploymentStatus.fromValue(this.lastDeploymentStatus);
    }

    public final String lastDeploymentStatusAsString() {
        return this.lastDeploymentStatus;
    }

    public final String lastDeploymentJob() {
        return this.lastDeploymentJob;
    }

    public final Instant lastDeploymentTime() {
        return this.lastDeploymentTime;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRobots() ? this.robots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastDeploymentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastDeploymentJob());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastDeploymentTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetResponse)) {
            return false;
        }
        DescribeFleetResponse other = (DescribeFleetResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && this.hasRobots() == other.hasRobots() && Objects.equals(this.robots(), other.robots()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastDeploymentStatusAsString(), other.lastDeploymentStatusAsString()) && Objects.equals(this.lastDeploymentJob(), other.lastDeploymentJob()) && Objects.equals(this.lastDeploymentTime(), other.lastDeploymentTime()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFleetResponse").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("Robots", this.hasRobots() ? this.robots() : null).add("CreatedAt", (Object)this.createdAt()).add("LastDeploymentStatus", (Object)this.lastDeploymentStatusAsString()).add("LastDeploymentJob", (Object)this.lastDeploymentJob()).add("LastDeploymentTime", (Object)this.lastDeploymentTime()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "robots": {
                return Optional.ofNullable(clazz.cast(this.robots()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "lastDeploymentStatus": {
                return Optional.ofNullable(clazz.cast(this.lastDeploymentStatusAsString()));
            }
            case "lastDeploymentJob": {
                return Optional.ofNullable(clazz.cast(this.lastDeploymentJob()));
            }
            case "lastDeploymentTime": {
                return Optional.ofNullable(clazz.cast(this.lastDeploymentTime()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFleetResponse, T> g) {
        return obj -> g.apply((DescribeFleetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RoboMakerResponse.BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private List<Robot> robots = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private String lastDeploymentStatus;
        private String lastDeploymentJob;
        private Instant lastDeploymentTime;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetResponse model) {
            super(model);
            this.name(model.name);
            this.arn(model.arn);
            this.robots(model.robots);
            this.createdAt(model.createdAt);
            this.lastDeploymentStatus(model.lastDeploymentStatus);
            this.lastDeploymentJob(model.lastDeploymentJob);
            this.lastDeploymentTime(model.lastDeploymentTime);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final List<Robot.Builder> getRobots() {
            List<Robot.Builder> result = RobotsCopier.copyToBuilder(this.robots);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRobots(Collection<Robot.BuilderImpl> robots) {
            this.robots = RobotsCopier.copyFromBuilder(robots);
        }

        @Override
        public final Builder robots(Collection<Robot> robots) {
            this.robots = RobotsCopier.copy(robots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder robots(Robot ... robots) {
            this.robots(Arrays.asList(robots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder robots(Consumer<Robot.Builder> ... robots) {
            this.robots(Stream.of(robots).map(c -> (Robot)((Robot.Builder)Robot.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getLastDeploymentStatus() {
            return this.lastDeploymentStatus;
        }

        public final void setLastDeploymentStatus(String lastDeploymentStatus) {
            this.lastDeploymentStatus = lastDeploymentStatus;
        }

        @Override
        public final Builder lastDeploymentStatus(String lastDeploymentStatus) {
            this.lastDeploymentStatus = lastDeploymentStatus;
            return this;
        }

        @Override
        public final Builder lastDeploymentStatus(DeploymentStatus lastDeploymentStatus) {
            this.lastDeploymentStatus(lastDeploymentStatus == null ? null : lastDeploymentStatus.toString());
            return this;
        }

        public final String getLastDeploymentJob() {
            return this.lastDeploymentJob;
        }

        public final void setLastDeploymentJob(String lastDeploymentJob) {
            this.lastDeploymentJob = lastDeploymentJob;
        }

        @Override
        public final Builder lastDeploymentJob(String lastDeploymentJob) {
            this.lastDeploymentJob = lastDeploymentJob;
            return this;
        }

        public final Instant getLastDeploymentTime() {
            return this.lastDeploymentTime;
        }

        public final void setLastDeploymentTime(Instant lastDeploymentTime) {
            this.lastDeploymentTime = lastDeploymentTime;
        }

        @Override
        public final Builder lastDeploymentTime(Instant lastDeploymentTime) {
            this.lastDeploymentTime = lastDeploymentTime;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public DescribeFleetResponse build() {
            return new DescribeFleetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RoboMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFleetResponse> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder robots(Collection<Robot> var1);

        public Builder robots(Robot ... var1);

        public Builder robots(Consumer<Robot.Builder> ... var1);

        public Builder createdAt(Instant var1);

        public Builder lastDeploymentStatus(String var1);

        public Builder lastDeploymentStatus(DeploymentStatus var1);

        public Builder lastDeploymentJob(String var1);

        public Builder lastDeploymentTime(Instant var1);

        public Builder tags(Map<String, String> var1);
    }
}

