/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.robomaker.model.Compute;
import software.amazon.awssdk.services.robomaker.model.DataSourceConfig;
import software.amazon.awssdk.services.robomaker.model.DataSourceConfigsCopier;
import software.amazon.awssdk.services.robomaker.model.FailureBehavior;
import software.amazon.awssdk.services.robomaker.model.LoggingConfig;
import software.amazon.awssdk.services.robomaker.model.OutputLocation;
import software.amazon.awssdk.services.robomaker.model.RoboMakerRequest;
import software.amazon.awssdk.services.robomaker.model.RobotApplicationConfig;
import software.amazon.awssdk.services.robomaker.model.RobotApplicationConfigsCopier;
import software.amazon.awssdk.services.robomaker.model.SimulationApplicationConfig;
import software.amazon.awssdk.services.robomaker.model.SimulationApplicationConfigsCopier;
import software.amazon.awssdk.services.robomaker.model.TagMapCopier;
import software.amazon.awssdk.services.robomaker.model.VPCConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSimulationJobRequest
extends RoboMakerRequest
implements ToCopyableBuilder<Builder, CreateSimulationJobRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(CreateSimulationJobRequest.getter(CreateSimulationJobRequest::clientRequestToken)).setter(CreateSimulationJobRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<OutputLocation> OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputLocation").getter(CreateSimulationJobRequest.getter(CreateSimulationJobRequest::outputLocation)).setter(CreateSimulationJobRequest.setter(Builder::outputLocation)).constructor(OutputLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputLocation").build()}).build();
    private static final SdkField<LoggingConfig> LOGGING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("loggingConfig").getter(CreateSimulationJobRequest.getter(CreateSimulationJobRequest::loggingConfig)).setter(CreateSimulationJobRequest.setter(Builder::loggingConfig)).constructor(LoggingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingConfig").build()}).build();
    private static final SdkField<Long> MAX_JOB_DURATION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("maxJobDurationInSeconds").getter(CreateSimulationJobRequest.getter(CreateSimulationJobRequest::maxJobDurationInSeconds)).setter(CreateSimulationJobRequest.setter(Builder::maxJobDurationInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxJobDurationInSeconds").build()}).build();
    private static final SdkField<String> IAM_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iamRole").getter(CreateSimulationJobRequest.getter(CreateSimulationJobRequest::iamRole)).setter(CreateSimulationJobRequest.setter(Builder::iamRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRole").build()}).build();
    private static final SdkField<String> FAILURE_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureBehavior").getter(CreateSimulationJobRequest.getter(CreateSimulationJobRequest::failureBehaviorAsString)).setter(CreateSimulationJobRequest.setter(Builder::failureBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureBehavior").build()}).build();
    private static final SdkField<List<RobotApplicationConfig>> ROBOT_APPLICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("robotApplications").getter(CreateSimulationJobRequest.getter(CreateSimulationJobRequest::robotApplications)).setter(CreateSimulationJobRequest.setter(Builder::robotApplications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("robotApplications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RobotApplicationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SimulationApplicationConfig>> SIMULATION_APPLICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("simulationApplications").getter(CreateSimulationJobRequest.getter(CreateSimulationJobRequest::simulationApplications)).setter(CreateSimulationJobRequest.setter(Builder::simulationApplications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("simulationApplications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SimulationApplicationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataSourceConfig>> DATA_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dataSources").getter(CreateSimulationJobRequest.getter(CreateSimulationJobRequest::dataSources)).setter(CreateSimulationJobRequest.setter(Builder::dataSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateSimulationJobRequest.getter(CreateSimulationJobRequest::tags)).setter(CreateSimulationJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<VPCConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vpcConfig").getter(CreateSimulationJobRequest.getter(CreateSimulationJobRequest::vpcConfig)).setter(CreateSimulationJobRequest.setter(Builder::vpcConfig)).constructor(VPCConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()}).build();
    private static final SdkField<Compute> COMPUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("compute").getter(CreateSimulationJobRequest.getter(CreateSimulationJobRequest::compute)).setter(CreateSimulationJobRequest.setter(Builder::compute)).constructor(Compute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compute").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD, OUTPUT_LOCATION_FIELD, LOGGING_CONFIG_FIELD, MAX_JOB_DURATION_IN_SECONDS_FIELD, IAM_ROLE_FIELD, FAILURE_BEHAVIOR_FIELD, ROBOT_APPLICATIONS_FIELD, SIMULATION_APPLICATIONS_FIELD, DATA_SOURCES_FIELD, TAGS_FIELD, VPC_CONFIG_FIELD, COMPUTE_FIELD));
    private final String clientRequestToken;
    private final OutputLocation outputLocation;
    private final LoggingConfig loggingConfig;
    private final Long maxJobDurationInSeconds;
    private final String iamRole;
    private final String failureBehavior;
    private final List<RobotApplicationConfig> robotApplications;
    private final List<SimulationApplicationConfig> simulationApplications;
    private final List<DataSourceConfig> dataSources;
    private final Map<String, String> tags;
    private final VPCConfig vpcConfig;
    private final Compute compute;

    private CreateSimulationJobRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.outputLocation = builder.outputLocation;
        this.loggingConfig = builder.loggingConfig;
        this.maxJobDurationInSeconds = builder.maxJobDurationInSeconds;
        this.iamRole = builder.iamRole;
        this.failureBehavior = builder.failureBehavior;
        this.robotApplications = builder.robotApplications;
        this.simulationApplications = builder.simulationApplications;
        this.dataSources = builder.dataSources;
        this.tags = builder.tags;
        this.vpcConfig = builder.vpcConfig;
        this.compute = builder.compute;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final OutputLocation outputLocation() {
        return this.outputLocation;
    }

    public final LoggingConfig loggingConfig() {
        return this.loggingConfig;
    }

    public final Long maxJobDurationInSeconds() {
        return this.maxJobDurationInSeconds;
    }

    public final String iamRole() {
        return this.iamRole;
    }

    public final FailureBehavior failureBehavior() {
        return FailureBehavior.fromValue(this.failureBehavior);
    }

    public final String failureBehaviorAsString() {
        return this.failureBehavior;
    }

    public final boolean hasRobotApplications() {
        return this.robotApplications != null && !(this.robotApplications instanceof SdkAutoConstructList);
    }

    public final List<RobotApplicationConfig> robotApplications() {
        return this.robotApplications;
    }

    public final boolean hasSimulationApplications() {
        return this.simulationApplications != null && !(this.simulationApplications instanceof SdkAutoConstructList);
    }

    public final List<SimulationApplicationConfig> simulationApplications() {
        return this.simulationApplications;
    }

    public final boolean hasDataSources() {
        return this.dataSources != null && !(this.dataSources instanceof SdkAutoConstructList);
    }

    public final List<DataSourceConfig> dataSources() {
        return this.dataSources;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final VPCConfig vpcConfig() {
        return this.vpcConfig;
    }

    public final Compute compute() {
        return this.compute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxJobDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRobotApplications() ? this.robotApplications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSimulationApplications() ? this.simulationApplications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataSources() ? this.dataSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.compute());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSimulationJobRequest)) {
            return false;
        }
        CreateSimulationJobRequest other = (CreateSimulationJobRequest)((Object)obj);
        return Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.outputLocation(), other.outputLocation()) && Objects.equals(this.loggingConfig(), other.loggingConfig()) && Objects.equals(this.maxJobDurationInSeconds(), other.maxJobDurationInSeconds()) && Objects.equals(this.iamRole(), other.iamRole()) && Objects.equals(this.failureBehaviorAsString(), other.failureBehaviorAsString()) && this.hasRobotApplications() == other.hasRobotApplications() && Objects.equals(this.robotApplications(), other.robotApplications()) && this.hasSimulationApplications() == other.hasSimulationApplications() && Objects.equals(this.simulationApplications(), other.simulationApplications()) && this.hasDataSources() == other.hasDataSources() && Objects.equals(this.dataSources(), other.dataSources()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.compute(), other.compute());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSimulationJobRequest").add("ClientRequestToken", (Object)this.clientRequestToken()).add("OutputLocation", (Object)this.outputLocation()).add("LoggingConfig", (Object)this.loggingConfig()).add("MaxJobDurationInSeconds", (Object)this.maxJobDurationInSeconds()).add("IamRole", (Object)this.iamRole()).add("FailureBehavior", (Object)this.failureBehaviorAsString()).add("RobotApplications", this.hasRobotApplications() ? this.robotApplications() : null).add("SimulationApplications", this.hasSimulationApplications() ? this.simulationApplications() : null).add("DataSources", this.hasDataSources() ? this.dataSources() : null).add("Tags", this.hasTags() ? this.tags() : null).add("VpcConfig", (Object)this.vpcConfig()).add("Compute", (Object)this.compute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "outputLocation": {
                return Optional.ofNullable(clazz.cast(this.outputLocation()));
            }
            case "loggingConfig": {
                return Optional.ofNullable(clazz.cast(this.loggingConfig()));
            }
            case "maxJobDurationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.maxJobDurationInSeconds()));
            }
            case "iamRole": {
                return Optional.ofNullable(clazz.cast(this.iamRole()));
            }
            case "failureBehavior": {
                return Optional.ofNullable(clazz.cast(this.failureBehaviorAsString()));
            }
            case "robotApplications": {
                return Optional.ofNullable(clazz.cast(this.robotApplications()));
            }
            case "simulationApplications": {
                return Optional.ofNullable(clazz.cast(this.simulationApplications()));
            }
            case "dataSources": {
                return Optional.ofNullable(clazz.cast(this.dataSources()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "vpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "compute": {
                return Optional.ofNullable(clazz.cast(this.compute()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSimulationJobRequest, T> g) {
        return obj -> g.apply((CreateSimulationJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RoboMakerRequest.BuilderImpl
    implements Builder {
        private String clientRequestToken;
        private OutputLocation outputLocation;
        private LoggingConfig loggingConfig;
        private Long maxJobDurationInSeconds;
        private String iamRole;
        private String failureBehavior;
        private List<RobotApplicationConfig> robotApplications = DefaultSdkAutoConstructList.getInstance();
        private List<SimulationApplicationConfig> simulationApplications = DefaultSdkAutoConstructList.getInstance();
        private List<DataSourceConfig> dataSources = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private VPCConfig vpcConfig;
        private Compute compute;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSimulationJobRequest model) {
            super(model);
            this.clientRequestToken(model.clientRequestToken);
            this.outputLocation(model.outputLocation);
            this.loggingConfig(model.loggingConfig);
            this.maxJobDurationInSeconds(model.maxJobDurationInSeconds);
            this.iamRole(model.iamRole);
            this.failureBehavior(model.failureBehavior);
            this.robotApplications(model.robotApplications);
            this.simulationApplications(model.simulationApplications);
            this.dataSources(model.dataSources);
            this.tags(model.tags);
            this.vpcConfig(model.vpcConfig);
            this.compute(model.compute);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        @Transient
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final OutputLocation.Builder getOutputLocation() {
            return this.outputLocation != null ? this.outputLocation.toBuilder() : null;
        }

        public final void setOutputLocation(OutputLocation.BuilderImpl outputLocation) {
            this.outputLocation = outputLocation != null ? outputLocation.build() : null;
        }

        @Override
        @Transient
        public final Builder outputLocation(OutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final LoggingConfig.Builder getLoggingConfig() {
            return this.loggingConfig != null ? this.loggingConfig.toBuilder() : null;
        }

        public final void setLoggingConfig(LoggingConfig.BuilderImpl loggingConfig) {
            this.loggingConfig = loggingConfig != null ? loggingConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder loggingConfig(LoggingConfig loggingConfig) {
            this.loggingConfig = loggingConfig;
            return this;
        }

        public final Long getMaxJobDurationInSeconds() {
            return this.maxJobDurationInSeconds;
        }

        public final void setMaxJobDurationInSeconds(Long maxJobDurationInSeconds) {
            this.maxJobDurationInSeconds = maxJobDurationInSeconds;
        }

        @Override
        @Transient
        public final Builder maxJobDurationInSeconds(Long maxJobDurationInSeconds) {
            this.maxJobDurationInSeconds = maxJobDurationInSeconds;
            return this;
        }

        public final String getIamRole() {
            return this.iamRole;
        }

        public final void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        @Override
        @Transient
        public final Builder iamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final String getFailureBehavior() {
            return this.failureBehavior;
        }

        public final void setFailureBehavior(String failureBehavior) {
            this.failureBehavior = failureBehavior;
        }

        @Override
        @Transient
        public final Builder failureBehavior(String failureBehavior) {
            this.failureBehavior = failureBehavior;
            return this;
        }

        @Override
        @Transient
        public final Builder failureBehavior(FailureBehavior failureBehavior) {
            this.failureBehavior(failureBehavior == null ? null : failureBehavior.toString());
            return this;
        }

        public final List<RobotApplicationConfig.Builder> getRobotApplications() {
            List<RobotApplicationConfig.Builder> result = RobotApplicationConfigsCopier.copyToBuilder(this.robotApplications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRobotApplications(Collection<RobotApplicationConfig.BuilderImpl> robotApplications) {
            this.robotApplications = RobotApplicationConfigsCopier.copyFromBuilder(robotApplications);
        }

        @Override
        @Transient
        public final Builder robotApplications(Collection<RobotApplicationConfig> robotApplications) {
            this.robotApplications = RobotApplicationConfigsCopier.copy(robotApplications);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder robotApplications(RobotApplicationConfig ... robotApplications) {
            this.robotApplications(Arrays.asList(robotApplications));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder robotApplications(Consumer<RobotApplicationConfig.Builder> ... robotApplications) {
            this.robotApplications(Stream.of(robotApplications).map(c -> (RobotApplicationConfig)((RobotApplicationConfig.Builder)RobotApplicationConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SimulationApplicationConfig.Builder> getSimulationApplications() {
            List<SimulationApplicationConfig.Builder> result = SimulationApplicationConfigsCopier.copyToBuilder(this.simulationApplications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSimulationApplications(Collection<SimulationApplicationConfig.BuilderImpl> simulationApplications) {
            this.simulationApplications = SimulationApplicationConfigsCopier.copyFromBuilder(simulationApplications);
        }

        @Override
        @Transient
        public final Builder simulationApplications(Collection<SimulationApplicationConfig> simulationApplications) {
            this.simulationApplications = SimulationApplicationConfigsCopier.copy(simulationApplications);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder simulationApplications(SimulationApplicationConfig ... simulationApplications) {
            this.simulationApplications(Arrays.asList(simulationApplications));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder simulationApplications(Consumer<SimulationApplicationConfig.Builder> ... simulationApplications) {
            this.simulationApplications(Stream.of(simulationApplications).map(c -> (SimulationApplicationConfig)((SimulationApplicationConfig.Builder)SimulationApplicationConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataSourceConfig.Builder> getDataSources() {
            List<DataSourceConfig.Builder> result = DataSourceConfigsCopier.copyToBuilder(this.dataSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSources(Collection<DataSourceConfig.BuilderImpl> dataSources) {
            this.dataSources = DataSourceConfigsCopier.copyFromBuilder(dataSources);
        }

        @Override
        @Transient
        public final Builder dataSources(Collection<DataSourceConfig> dataSources) {
            this.dataSources = DataSourceConfigsCopier.copy(dataSources);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dataSources(DataSourceConfig ... dataSources) {
            this.dataSources(Arrays.asList(dataSources));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dataSources(Consumer<DataSourceConfig.Builder> ... dataSources) {
            this.dataSources(Stream.of(dataSources).map(c -> (DataSourceConfig)((DataSourceConfig.Builder)DataSourceConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final VPCConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VPCConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder vpcConfig(VPCConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final Compute.Builder getCompute() {
            return this.compute != null ? this.compute.toBuilder() : null;
        }

        public final void setCompute(Compute.BuilderImpl compute) {
            this.compute = compute != null ? compute.build() : null;
        }

        @Override
        @Transient
        public final Builder compute(Compute compute) {
            this.compute = compute;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSimulationJobRequest build() {
            return new CreateSimulationJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RoboMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSimulationJobRequest> {
        public Builder clientRequestToken(String var1);

        public Builder outputLocation(OutputLocation var1);

        default public Builder outputLocation(Consumer<OutputLocation.Builder> outputLocation) {
            return this.outputLocation((OutputLocation)((OutputLocation.Builder)OutputLocation.builder().applyMutation(outputLocation)).build());
        }

        public Builder loggingConfig(LoggingConfig var1);

        default public Builder loggingConfig(Consumer<LoggingConfig.Builder> loggingConfig) {
            return this.loggingConfig((LoggingConfig)((LoggingConfig.Builder)LoggingConfig.builder().applyMutation(loggingConfig)).build());
        }

        public Builder maxJobDurationInSeconds(Long var1);

        public Builder iamRole(String var1);

        public Builder failureBehavior(String var1);

        public Builder failureBehavior(FailureBehavior var1);

        public Builder robotApplications(Collection<RobotApplicationConfig> var1);

        public Builder robotApplications(RobotApplicationConfig ... var1);

        public Builder robotApplications(Consumer<RobotApplicationConfig.Builder> ... var1);

        public Builder simulationApplications(Collection<SimulationApplicationConfig> var1);

        public Builder simulationApplications(SimulationApplicationConfig ... var1);

        public Builder simulationApplications(Consumer<SimulationApplicationConfig.Builder> ... var1);

        public Builder dataSources(Collection<DataSourceConfig> var1);

        public Builder dataSources(DataSourceConfig ... var1);

        public Builder dataSources(Consumer<DataSourceConfig.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder vpcConfig(VPCConfig var1);

        default public Builder vpcConfig(Consumer<VPCConfig.Builder> vpcConfig) {
            return this.vpcConfig((VPCConfig)((VPCConfig.Builder)VPCConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder compute(Compute var1);

        default public Builder compute(Consumer<Compute.Builder> compute) {
            return this.compute((Compute)((Compute.Builder)Compute.builder().applyMutation(compute)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

