/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ExitBehavior {
    FAIL("FAIL"),
    RESTART("RESTART"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ExitBehavior(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExitBehavior fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ExitBehavior.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExitBehavior> knownValues() {
        return Stream.of(ExitBehavior.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

