/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.robomaker.model.RoboMakerResponse;
import software.amazon.awssdk.services.robomaker.model.SimulationJobSummariesCopier;
import software.amazon.awssdk.services.robomaker.model.SimulationJobSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSimulationJobsResponse
extends RoboMakerResponse
implements ToCopyableBuilder<Builder, ListSimulationJobsResponse> {
    private static final SdkField<List<SimulationJobSummary>> SIMULATION_JOB_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("simulationJobSummaries").getter(ListSimulationJobsResponse.getter(ListSimulationJobsResponse::simulationJobSummaries)).setter(ListSimulationJobsResponse.setter(Builder::simulationJobSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("simulationJobSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SimulationJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSimulationJobsResponse.getter(ListSimulationJobsResponse::nextToken)).setter(ListSimulationJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIMULATION_JOB_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<SimulationJobSummary> simulationJobSummaries;
    private final String nextToken;

    private ListSimulationJobsResponse(BuilderImpl builder) {
        super(builder);
        this.simulationJobSummaries = builder.simulationJobSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSimulationJobSummaries() {
        return this.simulationJobSummaries != null && !(this.simulationJobSummaries instanceof SdkAutoConstructList);
    }

    public final List<SimulationJobSummary> simulationJobSummaries() {
        return this.simulationJobSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSimulationJobSummaries() ? this.simulationJobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSimulationJobsResponse)) {
            return false;
        }
        ListSimulationJobsResponse other = (ListSimulationJobsResponse)((Object)obj);
        return this.hasSimulationJobSummaries() == other.hasSimulationJobSummaries() && Objects.equals(this.simulationJobSummaries(), other.simulationJobSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSimulationJobsResponse").add("SimulationJobSummaries", this.hasSimulationJobSummaries() ? this.simulationJobSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "simulationJobSummaries": {
                return Optional.ofNullable(clazz.cast(this.simulationJobSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSimulationJobsResponse, T> g) {
        return obj -> g.apply((ListSimulationJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RoboMakerResponse.BuilderImpl
    implements Builder {
        private List<SimulationJobSummary> simulationJobSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSimulationJobsResponse model) {
            super(model);
            this.simulationJobSummaries(model.simulationJobSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<SimulationJobSummary.Builder> getSimulationJobSummaries() {
            if (this.simulationJobSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.simulationJobSummaries != null ? (Collection)this.simulationJobSummaries.stream().map(SimulationJobSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder simulationJobSummaries(Collection<SimulationJobSummary> simulationJobSummaries) {
            this.simulationJobSummaries = SimulationJobSummariesCopier.copy(simulationJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder simulationJobSummaries(SimulationJobSummary ... simulationJobSummaries) {
            this.simulationJobSummaries(Arrays.asList(simulationJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder simulationJobSummaries(Consumer<SimulationJobSummary.Builder> ... simulationJobSummaries) {
            this.simulationJobSummaries(Stream.of(simulationJobSummaries).map(c -> (SimulationJobSummary)((SimulationJobSummary.Builder)SimulationJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSimulationJobSummaries(Collection<SimulationJobSummary.BuilderImpl> simulationJobSummaries) {
            this.simulationJobSummaries = SimulationJobSummariesCopier.copyFromBuilder(simulationJobSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSimulationJobsResponse build() {
            return new ListSimulationJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RoboMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSimulationJobsResponse> {
        public Builder simulationJobSummaries(Collection<SimulationJobSummary> var1);

        public Builder simulationJobSummaries(SimulationJobSummary ... var1);

        public Builder simulationJobSummaries(Consumer<SimulationJobSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

