/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.robomaker.model.LaunchConfig;
import software.amazon.awssdk.services.robomaker.model.WorldConfig;
import software.amazon.awssdk.services.robomaker.model.WorldConfigsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SimulationApplicationConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SimulationApplicationConfig> {
    private static final SdkField<String> APPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("application").getter(SimulationApplicationConfig.getter(SimulationApplicationConfig::application)).setter(SimulationApplicationConfig.setter(Builder::application)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("application").build()}).build();
    private static final SdkField<String> APPLICATION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationVersion").getter(SimulationApplicationConfig.getter(SimulationApplicationConfig::applicationVersion)).setter(SimulationApplicationConfig.setter(Builder::applicationVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationVersion").build()}).build();
    private static final SdkField<LaunchConfig> LAUNCH_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("launchConfig").getter(SimulationApplicationConfig.getter(SimulationApplicationConfig::launchConfig)).setter(SimulationApplicationConfig.setter(Builder::launchConfig)).constructor(LaunchConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchConfig").build()}).build();
    private static final SdkField<List<WorldConfig>> WORLD_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("worldConfigs").getter(SimulationApplicationConfig.getter(SimulationApplicationConfig::worldConfigs)).setter(SimulationApplicationConfig.setter(Builder::worldConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("worldConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorldConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_FIELD, APPLICATION_VERSION_FIELD, LAUNCH_CONFIG_FIELD, WORLD_CONFIGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String application;
    private final String applicationVersion;
    private final LaunchConfig launchConfig;
    private final List<WorldConfig> worldConfigs;

    private SimulationApplicationConfig(BuilderImpl builder) {
        this.application = builder.application;
        this.applicationVersion = builder.applicationVersion;
        this.launchConfig = builder.launchConfig;
        this.worldConfigs = builder.worldConfigs;
    }

    public String application() {
        return this.application;
    }

    public String applicationVersion() {
        return this.applicationVersion;
    }

    public LaunchConfig launchConfig() {
        return this.launchConfig;
    }

    public boolean hasWorldConfigs() {
        return this.worldConfigs != null && !(this.worldConfigs instanceof SdkAutoConstructList);
    }

    public List<WorldConfig> worldConfigs() {
        return this.worldConfigs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.application());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.worldConfigs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimulationApplicationConfig)) {
            return false;
        }
        SimulationApplicationConfig other = (SimulationApplicationConfig)obj;
        return Objects.equals(this.application(), other.application()) && Objects.equals(this.applicationVersion(), other.applicationVersion()) && Objects.equals(this.launchConfig(), other.launchConfig()) && Objects.equals(this.worldConfigs(), other.worldConfigs());
    }

    public String toString() {
        return ToString.builder((String)"SimulationApplicationConfig").add("Application", (Object)this.application()).add("ApplicationVersion", (Object)this.applicationVersion()).add("LaunchConfig", (Object)this.launchConfig()).add("WorldConfigs", this.worldConfigs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "application": {
                return Optional.ofNullable(clazz.cast(this.application()));
            }
            case "applicationVersion": {
                return Optional.ofNullable(clazz.cast(this.applicationVersion()));
            }
            case "launchConfig": {
                return Optional.ofNullable(clazz.cast(this.launchConfig()));
            }
            case "worldConfigs": {
                return Optional.ofNullable(clazz.cast(this.worldConfigs()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SimulationApplicationConfig, T> g) {
        return obj -> g.apply((SimulationApplicationConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String application;
        private String applicationVersion;
        private LaunchConfig launchConfig;
        private List<WorldConfig> worldConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SimulationApplicationConfig model) {
            this.application(model.application);
            this.applicationVersion(model.applicationVersion);
            this.launchConfig(model.launchConfig);
            this.worldConfigs(model.worldConfigs);
        }

        public final String getApplication() {
            return this.application;
        }

        @Override
        public final Builder application(String application) {
            this.application = application;
            return this;
        }

        public final void setApplication(String application) {
            this.application = application;
        }

        public final String getApplicationVersion() {
            return this.applicationVersion;
        }

        @Override
        public final Builder applicationVersion(String applicationVersion) {
            this.applicationVersion = applicationVersion;
            return this;
        }

        public final void setApplicationVersion(String applicationVersion) {
            this.applicationVersion = applicationVersion;
        }

        public final LaunchConfig.Builder getLaunchConfig() {
            return this.launchConfig != null ? this.launchConfig.toBuilder() : null;
        }

        @Override
        public final Builder launchConfig(LaunchConfig launchConfig) {
            this.launchConfig = launchConfig;
            return this;
        }

        public final void setLaunchConfig(LaunchConfig.BuilderImpl launchConfig) {
            this.launchConfig = launchConfig != null ? launchConfig.build() : null;
        }

        public final Collection<WorldConfig.Builder> getWorldConfigs() {
            return this.worldConfigs != null ? (Collection)this.worldConfigs.stream().map(WorldConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder worldConfigs(Collection<WorldConfig> worldConfigs) {
            this.worldConfigs = WorldConfigsCopier.copy(worldConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder worldConfigs(WorldConfig ... worldConfigs) {
            this.worldConfigs(Arrays.asList(worldConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder worldConfigs(Consumer<WorldConfig.Builder> ... worldConfigs) {
            this.worldConfigs(Stream.of(worldConfigs).map(c -> (WorldConfig)((WorldConfig.Builder)WorldConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setWorldConfigs(Collection<WorldConfig.BuilderImpl> worldConfigs) {
            this.worldConfigs = WorldConfigsCopier.copyFromBuilder(worldConfigs);
        }

        public SimulationApplicationConfig build() {
            return new SimulationApplicationConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SimulationApplicationConfig> {
        public Builder application(String var1);

        public Builder applicationVersion(String var1);

        public Builder launchConfig(LaunchConfig var1);

        default public Builder launchConfig(Consumer<LaunchConfig.Builder> launchConfig) {
            return this.launchConfig((LaunchConfig)((LaunchConfig.Builder)LaunchConfig.builder().applyMutation(launchConfig)).build());
        }

        public Builder worldConfigs(Collection<WorldConfig> var1);

        public Builder worldConfigs(WorldConfig ... var1);

        public Builder worldConfigs(Consumer<WorldConfig.Builder> ... var1);
    }
}

