/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.robomaker.model.RoboMakerRequest;
import software.amazon.awssdk.services.robomaker.model.TagMapCopier;
import software.amazon.awssdk.services.robomaker.model.WorldCount;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWorldGenerationJobRequest
extends RoboMakerRequest
implements ToCopyableBuilder<Builder, CreateWorldGenerationJobRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(CreateWorldGenerationJobRequest.getter(CreateWorldGenerationJobRequest::clientRequestToken)).setter(CreateWorldGenerationJobRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("template").getter(CreateWorldGenerationJobRequest.getter(CreateWorldGenerationJobRequest::template)).setter(CreateWorldGenerationJobRequest.setter(Builder::template)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("template").build()}).build();
    private static final SdkField<WorldCount> WORLD_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("worldCount").getter(CreateWorldGenerationJobRequest.getter(CreateWorldGenerationJobRequest::worldCount)).setter(CreateWorldGenerationJobRequest.setter(Builder::worldCount)).constructor(WorldCount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("worldCount").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateWorldGenerationJobRequest.getter(CreateWorldGenerationJobRequest::tags)).setter(CreateWorldGenerationJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> WORLD_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("worldTags").getter(CreateWorldGenerationJobRequest.getter(CreateWorldGenerationJobRequest::worldTags)).setter(CreateWorldGenerationJobRequest.setter(Builder::worldTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("worldTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD, TEMPLATE_FIELD, WORLD_COUNT_FIELD, TAGS_FIELD, WORLD_TAGS_FIELD));
    private final String clientRequestToken;
    private final String template;
    private final WorldCount worldCount;
    private final Map<String, String> tags;
    private final Map<String, String> worldTags;

    private CreateWorldGenerationJobRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.template = builder.template;
        this.worldCount = builder.worldCount;
        this.tags = builder.tags;
        this.worldTags = builder.worldTags;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public String template() {
        return this.template;
    }

    public WorldCount worldCount() {
        return this.worldCount;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public boolean hasWorldTags() {
        return this.worldTags != null && !(this.worldTags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> worldTags() {
        return this.worldTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.template());
        hashCode = 31 * hashCode + Objects.hashCode(this.worldCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorldTags() ? this.worldTags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorldGenerationJobRequest)) {
            return false;
        }
        CreateWorldGenerationJobRequest other = (CreateWorldGenerationJobRequest)((Object)obj);
        return Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.template(), other.template()) && Objects.equals(this.worldCount(), other.worldCount()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasWorldTags() == other.hasWorldTags() && Objects.equals(this.worldTags(), other.worldTags());
    }

    public String toString() {
        return ToString.builder((String)"CreateWorldGenerationJobRequest").add("ClientRequestToken", (Object)this.clientRequestToken()).add("Template", (Object)this.template()).add("WorldCount", (Object)this.worldCount()).add("Tags", this.hasTags() ? this.tags() : null).add("WorldTags", this.hasWorldTags() ? this.worldTags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "template": {
                return Optional.ofNullable(clazz.cast(this.template()));
            }
            case "worldCount": {
                return Optional.ofNullable(clazz.cast(this.worldCount()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "worldTags": {
                return Optional.ofNullable(clazz.cast(this.worldTags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorldGenerationJobRequest, T> g) {
        return obj -> g.apply((CreateWorldGenerationJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RoboMakerRequest.BuilderImpl
    implements Builder {
        private String clientRequestToken;
        private String template;
        private WorldCount worldCount;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> worldTags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorldGenerationJobRequest model) {
            super(model);
            this.clientRequestToken(model.clientRequestToken);
            this.template(model.template);
            this.worldCount(model.worldCount);
            this.tags(model.tags);
            this.worldTags(model.worldTags);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final String getTemplate() {
            return this.template;
        }

        @Override
        public final Builder template(String template) {
            this.template = template;
            return this;
        }

        public final void setTemplate(String template) {
            this.template = template;
        }

        public final WorldCount.Builder getWorldCount() {
            return this.worldCount != null ? this.worldCount.toBuilder() : null;
        }

        @Override
        public final Builder worldCount(WorldCount worldCount) {
            this.worldCount = worldCount;
            return this;
        }

        public final void setWorldCount(WorldCount.BuilderImpl worldCount) {
            this.worldCount = worldCount != null ? worldCount.build() : null;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public final Map<String, String> getWorldTags() {
            if (this.worldTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.worldTags;
        }

        @Override
        public final Builder worldTags(Map<String, String> worldTags) {
            this.worldTags = TagMapCopier.copy(worldTags);
            return this;
        }

        public final void setWorldTags(Map<String, String> worldTags) {
            this.worldTags = TagMapCopier.copy(worldTags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorldGenerationJobRequest build() {
            return new CreateWorldGenerationJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RoboMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWorldGenerationJobRequest> {
        public Builder clientRequestToken(String var1);

        public Builder template(String var1);

        public Builder worldCount(WorldCount var1);

        default public Builder worldCount(Consumer<WorldCount.Builder> worldCount) {
            return this.worldCount((WorldCount)((WorldCount.Builder)WorldCount.builder().applyMutation(worldCount)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder worldTags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

