/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.robomaker.model.RoboMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRobotApplicationVersionRequest
extends RoboMakerRequest
implements ToCopyableBuilder<Builder, CreateRobotApplicationVersionRequest> {
    private static final SdkField<String> APPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("application").getter(CreateRobotApplicationVersionRequest.getter(CreateRobotApplicationVersionRequest::application)).setter(CreateRobotApplicationVersionRequest.setter(Builder::application)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("application").build()}).build();
    private static final SdkField<String> CURRENT_REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currentRevisionId").getter(CreateRobotApplicationVersionRequest.getter(CreateRobotApplicationVersionRequest::currentRevisionId)).setter(CreateRobotApplicationVersionRequest.setter(Builder::currentRevisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentRevisionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_FIELD, CURRENT_REVISION_ID_FIELD));
    private final String application;
    private final String currentRevisionId;

    private CreateRobotApplicationVersionRequest(BuilderImpl builder) {
        super(builder);
        this.application = builder.application;
        this.currentRevisionId = builder.currentRevisionId;
    }

    public String application() {
        return this.application;
    }

    public String currentRevisionId() {
        return this.currentRevisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.application());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentRevisionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRobotApplicationVersionRequest)) {
            return false;
        }
        CreateRobotApplicationVersionRequest other = (CreateRobotApplicationVersionRequest)((Object)obj);
        return Objects.equals(this.application(), other.application()) && Objects.equals(this.currentRevisionId(), other.currentRevisionId());
    }

    public String toString() {
        return ToString.builder((String)"CreateRobotApplicationVersionRequest").add("Application", (Object)this.application()).add("CurrentRevisionId", (Object)this.currentRevisionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "application": {
                return Optional.ofNullable(clazz.cast(this.application()));
            }
            case "currentRevisionId": {
                return Optional.ofNullable(clazz.cast(this.currentRevisionId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRobotApplicationVersionRequest, T> g) {
        return obj -> g.apply((CreateRobotApplicationVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RoboMakerRequest.BuilderImpl
    implements Builder {
        private String application;
        private String currentRevisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRobotApplicationVersionRequest model) {
            super(model);
            this.application(model.application);
            this.currentRevisionId(model.currentRevisionId);
        }

        public final String getApplication() {
            return this.application;
        }

        @Override
        public final Builder application(String application) {
            this.application = application;
            return this;
        }

        public final void setApplication(String application) {
            this.application = application;
        }

        public final String getCurrentRevisionId() {
            return this.currentRevisionId;
        }

        @Override
        public final Builder currentRevisionId(String currentRevisionId) {
            this.currentRevisionId = currentRevisionId;
            return this;
        }

        public final void setCurrentRevisionId(String currentRevisionId) {
            this.currentRevisionId = currentRevisionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRobotApplicationVersionRequest build() {
            return new CreateRobotApplicationVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RoboMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRobotApplicationVersionRequest> {
        public Builder application(String var1);

        public Builder currentRevisionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

