/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.robomaker.RoboMakerClient;
import software.amazon.awssdk.services.robomaker.model.BatchDeleteWorldsRequest;
import software.amazon.awssdk.services.robomaker.model.BatchDeleteWorldsResponse;
import software.amazon.awssdk.services.robomaker.model.BatchDescribeSimulationJobRequest;
import software.amazon.awssdk.services.robomaker.model.BatchDescribeSimulationJobResponse;
import software.amazon.awssdk.services.robomaker.model.CancelDeploymentJobRequest;
import software.amazon.awssdk.services.robomaker.model.CancelDeploymentJobResponse;
import software.amazon.awssdk.services.robomaker.model.CancelSimulationJobBatchRequest;
import software.amazon.awssdk.services.robomaker.model.CancelSimulationJobBatchResponse;
import software.amazon.awssdk.services.robomaker.model.CancelSimulationJobRequest;
import software.amazon.awssdk.services.robomaker.model.CancelSimulationJobResponse;
import software.amazon.awssdk.services.robomaker.model.CancelWorldExportJobRequest;
import software.amazon.awssdk.services.robomaker.model.CancelWorldExportJobResponse;
import software.amazon.awssdk.services.robomaker.model.CancelWorldGenerationJobRequest;
import software.amazon.awssdk.services.robomaker.model.CancelWorldGenerationJobResponse;
import software.amazon.awssdk.services.robomaker.model.ConcurrentDeploymentException;
import software.amazon.awssdk.services.robomaker.model.CreateDeploymentJobRequest;
import software.amazon.awssdk.services.robomaker.model.CreateDeploymentJobResponse;
import software.amazon.awssdk.services.robomaker.model.CreateFleetRequest;
import software.amazon.awssdk.services.robomaker.model.CreateFleetResponse;
import software.amazon.awssdk.services.robomaker.model.CreateRobotApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.CreateRobotApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.CreateRobotApplicationVersionRequest;
import software.amazon.awssdk.services.robomaker.model.CreateRobotApplicationVersionResponse;
import software.amazon.awssdk.services.robomaker.model.CreateRobotRequest;
import software.amazon.awssdk.services.robomaker.model.CreateRobotResponse;
import software.amazon.awssdk.services.robomaker.model.CreateSimulationApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.CreateSimulationApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.CreateSimulationApplicationVersionRequest;
import software.amazon.awssdk.services.robomaker.model.CreateSimulationApplicationVersionResponse;
import software.amazon.awssdk.services.robomaker.model.CreateSimulationJobRequest;
import software.amazon.awssdk.services.robomaker.model.CreateSimulationJobResponse;
import software.amazon.awssdk.services.robomaker.model.CreateWorldExportJobRequest;
import software.amazon.awssdk.services.robomaker.model.CreateWorldExportJobResponse;
import software.amazon.awssdk.services.robomaker.model.CreateWorldGenerationJobRequest;
import software.amazon.awssdk.services.robomaker.model.CreateWorldGenerationJobResponse;
import software.amazon.awssdk.services.robomaker.model.CreateWorldTemplateRequest;
import software.amazon.awssdk.services.robomaker.model.CreateWorldTemplateResponse;
import software.amazon.awssdk.services.robomaker.model.DeleteFleetRequest;
import software.amazon.awssdk.services.robomaker.model.DeleteFleetResponse;
import software.amazon.awssdk.services.robomaker.model.DeleteRobotApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.DeleteRobotApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.DeleteRobotRequest;
import software.amazon.awssdk.services.robomaker.model.DeleteRobotResponse;
import software.amazon.awssdk.services.robomaker.model.DeleteSimulationApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.DeleteSimulationApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.DeleteWorldTemplateRequest;
import software.amazon.awssdk.services.robomaker.model.DeleteWorldTemplateResponse;
import software.amazon.awssdk.services.robomaker.model.DeregisterRobotRequest;
import software.amazon.awssdk.services.robomaker.model.DeregisterRobotResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeDeploymentJobRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeDeploymentJobResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeFleetRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeFleetResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeRobotApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeRobotApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeRobotRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeRobotResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeSimulationApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeSimulationApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobBatchRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobBatchResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeWorldExportJobRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeWorldExportJobResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeWorldGenerationJobRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeWorldGenerationJobResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeWorldRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeWorldResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeWorldTemplateRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeWorldTemplateResponse;
import software.amazon.awssdk.services.robomaker.model.GetWorldTemplateBodyRequest;
import software.amazon.awssdk.services.robomaker.model.GetWorldTemplateBodyResponse;
import software.amazon.awssdk.services.robomaker.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.robomaker.model.InternalServerException;
import software.amazon.awssdk.services.robomaker.model.InvalidParameterException;
import software.amazon.awssdk.services.robomaker.model.LimitExceededException;
import software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsRequest;
import software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsResponse;
import software.amazon.awssdk.services.robomaker.model.ListFleetsRequest;
import software.amazon.awssdk.services.robomaker.model.ListFleetsResponse;
import software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsRequest;
import software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsResponse;
import software.amazon.awssdk.services.robomaker.model.ListRobotsRequest;
import software.amazon.awssdk.services.robomaker.model.ListRobotsResponse;
import software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsRequest;
import software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsResponse;
import software.amazon.awssdk.services.robomaker.model.ListSimulationJobBatchesRequest;
import software.amazon.awssdk.services.robomaker.model.ListSimulationJobBatchesResponse;
import software.amazon.awssdk.services.robomaker.model.ListSimulationJobsRequest;
import software.amazon.awssdk.services.robomaker.model.ListSimulationJobsResponse;
import software.amazon.awssdk.services.robomaker.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.robomaker.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.robomaker.model.ListWorldExportJobsRequest;
import software.amazon.awssdk.services.robomaker.model.ListWorldExportJobsResponse;
import software.amazon.awssdk.services.robomaker.model.ListWorldGenerationJobsRequest;
import software.amazon.awssdk.services.robomaker.model.ListWorldGenerationJobsResponse;
import software.amazon.awssdk.services.robomaker.model.ListWorldTemplatesRequest;
import software.amazon.awssdk.services.robomaker.model.ListWorldTemplatesResponse;
import software.amazon.awssdk.services.robomaker.model.ListWorldsRequest;
import software.amazon.awssdk.services.robomaker.model.ListWorldsResponse;
import software.amazon.awssdk.services.robomaker.model.RegisterRobotRequest;
import software.amazon.awssdk.services.robomaker.model.RegisterRobotResponse;
import software.amazon.awssdk.services.robomaker.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.robomaker.model.ResourceNotFoundException;
import software.amazon.awssdk.services.robomaker.model.RestartSimulationJobRequest;
import software.amazon.awssdk.services.robomaker.model.RestartSimulationJobResponse;
import software.amazon.awssdk.services.robomaker.model.RoboMakerException;
import software.amazon.awssdk.services.robomaker.model.RoboMakerRequest;
import software.amazon.awssdk.services.robomaker.model.ServiceUnavailableException;
import software.amazon.awssdk.services.robomaker.model.StartSimulationJobBatchRequest;
import software.amazon.awssdk.services.robomaker.model.StartSimulationJobBatchResponse;
import software.amazon.awssdk.services.robomaker.model.SyncDeploymentJobRequest;
import software.amazon.awssdk.services.robomaker.model.SyncDeploymentJobResponse;
import software.amazon.awssdk.services.robomaker.model.TagResourceRequest;
import software.amazon.awssdk.services.robomaker.model.TagResourceResponse;
import software.amazon.awssdk.services.robomaker.model.ThrottlingException;
import software.amazon.awssdk.services.robomaker.model.UntagResourceRequest;
import software.amazon.awssdk.services.robomaker.model.UntagResourceResponse;
import software.amazon.awssdk.services.robomaker.model.UpdateRobotApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.UpdateRobotApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.UpdateSimulationApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.UpdateSimulationApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.UpdateWorldTemplateRequest;
import software.amazon.awssdk.services.robomaker.model.UpdateWorldTemplateResponse;
import software.amazon.awssdk.services.robomaker.paginators.ListDeploymentJobsIterable;
import software.amazon.awssdk.services.robomaker.paginators.ListFleetsIterable;
import software.amazon.awssdk.services.robomaker.paginators.ListRobotApplicationsIterable;
import software.amazon.awssdk.services.robomaker.paginators.ListRobotsIterable;
import software.amazon.awssdk.services.robomaker.paginators.ListSimulationApplicationsIterable;
import software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobBatchesIterable;
import software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobsIterable;
import software.amazon.awssdk.services.robomaker.paginators.ListWorldExportJobsIterable;
import software.amazon.awssdk.services.robomaker.paginators.ListWorldGenerationJobsIterable;
import software.amazon.awssdk.services.robomaker.paginators.ListWorldTemplatesIterable;
import software.amazon.awssdk.services.robomaker.paginators.ListWorldsIterable;
import software.amazon.awssdk.services.robomaker.transform.BatchDeleteWorldsRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.BatchDescribeSimulationJobRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.CancelDeploymentJobRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.CancelSimulationJobBatchRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.CancelSimulationJobRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.CancelWorldExportJobRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.CancelWorldGenerationJobRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.CreateDeploymentJobRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.CreateFleetRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.CreateRobotApplicationRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.CreateRobotApplicationVersionRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.CreateRobotRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.CreateSimulationApplicationRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.CreateSimulationApplicationVersionRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.CreateSimulationJobRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.CreateWorldExportJobRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.CreateWorldGenerationJobRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.CreateWorldTemplateRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.DeleteFleetRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.DeleteRobotApplicationRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.DeleteRobotRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.DeleteSimulationApplicationRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.DeleteWorldTemplateRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.DeregisterRobotRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.DescribeDeploymentJobRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.DescribeFleetRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.DescribeRobotApplicationRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.DescribeRobotRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.DescribeSimulationApplicationRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.DescribeSimulationJobBatchRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.DescribeSimulationJobRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.DescribeWorldExportJobRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.DescribeWorldGenerationJobRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.DescribeWorldRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.DescribeWorldTemplateRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.GetWorldTemplateBodyRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.ListDeploymentJobsRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.ListFleetsRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.ListRobotApplicationsRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.ListRobotsRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.ListSimulationApplicationsRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.ListSimulationJobBatchesRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.ListSimulationJobsRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.ListWorldExportJobsRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.ListWorldGenerationJobsRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.ListWorldTemplatesRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.ListWorldsRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.RegisterRobotRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.RestartSimulationJobRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.StartSimulationJobBatchRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.SyncDeploymentJobRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.UpdateRobotApplicationRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.UpdateSimulationApplicationRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.UpdateWorldTemplateRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultRoboMakerClient
implements RoboMakerClient {
    private static final Logger log = Logger.loggerFor(DefaultRoboMakerClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultRoboMakerClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "robomaker";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchDeleteWorldsResponse batchDeleteWorlds(BatchDeleteWorldsRequest batchDeleteWorldsRequest) throws InvalidParameterException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDeleteWorldsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, batchDeleteWorldsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDeleteWorlds");
            BatchDeleteWorldsResponse batchDeleteWorldsResponse = (BatchDeleteWorldsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDeleteWorlds").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchDeleteWorldsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchDeleteWorldsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchDeleteWorldsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$batchDeleteWorlds$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchDescribeSimulationJobResponse batchDescribeSimulationJob(BatchDescribeSimulationJobRequest batchDescribeSimulationJobRequest) throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDescribeSimulationJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, batchDescribeSimulationJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDescribeSimulationJob");
            BatchDescribeSimulationJobResponse batchDescribeSimulationJobResponse = (BatchDescribeSimulationJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDescribeSimulationJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchDescribeSimulationJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchDescribeSimulationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchDescribeSimulationJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$batchDescribeSimulationJob$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelDeploymentJobResponse cancelDeploymentJob(CancelDeploymentJobRequest cancelDeploymentJobRequest) throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelDeploymentJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, cancelDeploymentJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelDeploymentJob");
            CancelDeploymentJobResponse cancelDeploymentJobResponse = (CancelDeploymentJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelDeploymentJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelDeploymentJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelDeploymentJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelDeploymentJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$cancelDeploymentJob$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelSimulationJobResponse cancelSimulationJob(CancelSimulationJobRequest cancelSimulationJobRequest) throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelSimulationJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, cancelSimulationJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelSimulationJob");
            CancelSimulationJobResponse cancelSimulationJobResponse = (CancelSimulationJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelSimulationJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelSimulationJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelSimulationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelSimulationJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$cancelSimulationJob$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelSimulationJobBatchResponse cancelSimulationJobBatch(CancelSimulationJobBatchRequest cancelSimulationJobBatchRequest) throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelSimulationJobBatchResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, cancelSimulationJobBatchRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelSimulationJobBatch");
            CancelSimulationJobBatchResponse cancelSimulationJobBatchResponse = (CancelSimulationJobBatchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelSimulationJobBatch").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelSimulationJobBatchRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelSimulationJobBatchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelSimulationJobBatchResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$cancelSimulationJobBatch$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelWorldExportJobResponse cancelWorldExportJob(CancelWorldExportJobRequest cancelWorldExportJobRequest) throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelWorldExportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, cancelWorldExportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelWorldExportJob");
            CancelWorldExportJobResponse cancelWorldExportJobResponse = (CancelWorldExportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelWorldExportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelWorldExportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelWorldExportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelWorldExportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$cancelWorldExportJob$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelWorldGenerationJobResponse cancelWorldGenerationJob(CancelWorldGenerationJobRequest cancelWorldGenerationJobRequest) throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelWorldGenerationJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, cancelWorldGenerationJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelWorldGenerationJob");
            CancelWorldGenerationJobResponse cancelWorldGenerationJobResponse = (CancelWorldGenerationJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelWorldGenerationJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelWorldGenerationJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelWorldGenerationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelWorldGenerationJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$cancelWorldGenerationJob$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDeploymentJobResponse createDeploymentJob(CreateDeploymentJobRequest createDeploymentJobRequest) throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException, LimitExceededException, ConcurrentDeploymentException, IdempotentParameterMismatchException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDeploymentJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, createDeploymentJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDeploymentJob");
            CreateDeploymentJobResponse createDeploymentJobResponse = (CreateDeploymentJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDeploymentJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDeploymentJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDeploymentJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDeploymentJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$createDeploymentJob$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFleetResponse createFleet(CreateFleetRequest createFleetRequest) throws InvalidParameterException, InternalServerException, ThrottlingException, LimitExceededException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFleetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, createFleetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFleet");
            CreateFleetResponse createFleetResponse = (CreateFleetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFleet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createFleetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateFleetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createFleetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$createFleet$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateRobotResponse createRobot(CreateRobotRequest createRobotRequest) throws InvalidParameterException, InternalServerException, ThrottlingException, LimitExceededException, ResourceAlreadyExistsException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRobotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, createRobotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRobot");
            CreateRobotResponse createRobotResponse = (CreateRobotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRobot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createRobotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateRobotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createRobotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$createRobot$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateRobotApplicationResponse createRobotApplication(CreateRobotApplicationRequest createRobotApplicationRequest) throws InvalidParameterException, ResourceAlreadyExistsException, LimitExceededException, ThrottlingException, InternalServerException, IdempotentParameterMismatchException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRobotApplicationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, createRobotApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRobotApplication");
            CreateRobotApplicationResponse createRobotApplicationResponse = (CreateRobotApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRobotApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createRobotApplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateRobotApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createRobotApplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$createRobotApplication$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateRobotApplicationVersionResponse createRobotApplicationVersion(CreateRobotApplicationVersionRequest createRobotApplicationVersionRequest) throws InvalidParameterException, IdempotentParameterMismatchException, LimitExceededException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRobotApplicationVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, createRobotApplicationVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRobotApplicationVersion");
            CreateRobotApplicationVersionResponse createRobotApplicationVersionResponse = (CreateRobotApplicationVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRobotApplicationVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createRobotApplicationVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateRobotApplicationVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createRobotApplicationVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$createRobotApplicationVersion$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSimulationApplicationResponse createSimulationApplication(CreateSimulationApplicationRequest createSimulationApplicationRequest) throws InvalidParameterException, ResourceAlreadyExistsException, LimitExceededException, ThrottlingException, InternalServerException, IdempotentParameterMismatchException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSimulationApplicationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, createSimulationApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSimulationApplication");
            CreateSimulationApplicationResponse createSimulationApplicationResponse = (CreateSimulationApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSimulationApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSimulationApplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSimulationApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSimulationApplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$createSimulationApplication$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSimulationApplicationVersionResponse createSimulationApplicationVersion(CreateSimulationApplicationVersionRequest createSimulationApplicationVersionRequest) throws InvalidParameterException, IdempotentParameterMismatchException, LimitExceededException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSimulationApplicationVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, createSimulationApplicationVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSimulationApplicationVersion");
            CreateSimulationApplicationVersionResponse createSimulationApplicationVersionResponse = (CreateSimulationApplicationVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSimulationApplicationVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSimulationApplicationVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSimulationApplicationVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSimulationApplicationVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$createSimulationApplicationVersion$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSimulationJobResponse createSimulationJob(CreateSimulationJobRequest createSimulationJobRequest) throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException, LimitExceededException, IdempotentParameterMismatchException, ServiceUnavailableException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSimulationJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, createSimulationJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSimulationJob");
            CreateSimulationJobResponse createSimulationJobResponse = (CreateSimulationJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSimulationJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSimulationJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSimulationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSimulationJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$createSimulationJob$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateWorldExportJobResponse createWorldExportJob(CreateWorldExportJobRequest createWorldExportJobRequest) throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException, IdempotentParameterMismatchException, ServiceUnavailableException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWorldExportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, createWorldExportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateWorldExportJob");
            CreateWorldExportJobResponse createWorldExportJobResponse = (CreateWorldExportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWorldExportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createWorldExportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateWorldExportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createWorldExportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$createWorldExportJob$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateWorldGenerationJobResponse createWorldGenerationJob(CreateWorldGenerationJobRequest createWorldGenerationJobRequest) throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException, LimitExceededException, IdempotentParameterMismatchException, ServiceUnavailableException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWorldGenerationJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, createWorldGenerationJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateWorldGenerationJob");
            CreateWorldGenerationJobResponse createWorldGenerationJobResponse = (CreateWorldGenerationJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWorldGenerationJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createWorldGenerationJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateWorldGenerationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createWorldGenerationJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$createWorldGenerationJob$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateWorldTemplateResponse createWorldTemplate(CreateWorldTemplateRequest createWorldTemplateRequest) throws InvalidParameterException, ResourceAlreadyExistsException, ResourceNotFoundException, LimitExceededException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWorldTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, createWorldTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateWorldTemplate");
            CreateWorldTemplateResponse createWorldTemplateResponse = (CreateWorldTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWorldTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createWorldTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateWorldTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createWorldTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$createWorldTemplate$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFleetResponse deleteFleet(DeleteFleetRequest deleteFleetRequest) throws InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFleetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, deleteFleetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFleet");
            DeleteFleetResponse deleteFleetResponse = (DeleteFleetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFleet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteFleetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteFleetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteFleetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$deleteFleet$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRobotResponse deleteRobot(DeleteRobotRequest deleteRobotRequest) throws InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRobotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, deleteRobotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRobot");
            DeleteRobotResponse deleteRobotResponse = (DeleteRobotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRobot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteRobotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteRobotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteRobotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$deleteRobot$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRobotApplicationResponse deleteRobotApplication(DeleteRobotApplicationRequest deleteRobotApplicationRequest) throws InvalidParameterException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRobotApplicationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, deleteRobotApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRobotApplication");
            DeleteRobotApplicationResponse deleteRobotApplicationResponse = (DeleteRobotApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRobotApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteRobotApplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteRobotApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteRobotApplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$deleteRobotApplication$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSimulationApplicationResponse deleteSimulationApplication(DeleteSimulationApplicationRequest deleteSimulationApplicationRequest) throws InvalidParameterException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSimulationApplicationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, deleteSimulationApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSimulationApplication");
            DeleteSimulationApplicationResponse deleteSimulationApplicationResponse = (DeleteSimulationApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSimulationApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSimulationApplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSimulationApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSimulationApplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$deleteSimulationApplication$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteWorldTemplateResponse deleteWorldTemplate(DeleteWorldTemplateRequest deleteWorldTemplateRequest) throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWorldTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, deleteWorldTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteWorldTemplate");
            DeleteWorldTemplateResponse deleteWorldTemplateResponse = (DeleteWorldTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWorldTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteWorldTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteWorldTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteWorldTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$deleteWorldTemplate$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeregisterRobotResponse deregisterRobot(DeregisterRobotRequest deregisterRobotRequest) throws InvalidParameterException, InternalServerException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterRobotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, deregisterRobotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterRobot");
            DeregisterRobotResponse deregisterRobotResponse = (DeregisterRobotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterRobot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deregisterRobotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeregisterRobotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deregisterRobotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$deregisterRobot$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDeploymentJobResponse describeDeploymentJob(DescribeDeploymentJobRequest describeDeploymentJobRequest) throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDeploymentJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, describeDeploymentJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDeploymentJob");
            DescribeDeploymentJobResponse describeDeploymentJobResponse = (DescribeDeploymentJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDeploymentJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDeploymentJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDeploymentJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDeploymentJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$describeDeploymentJob$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFleetResponse describeFleet(DescribeFleetRequest describeFleetRequest) throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFleetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, describeFleetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFleet");
            DescribeFleetResponse describeFleetResponse = (DescribeFleetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFleet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeFleetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFleetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFleetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$describeFleet$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRobotResponse describeRobot(DescribeRobotRequest describeRobotRequest) throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRobotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, describeRobotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRobot");
            DescribeRobotResponse describeRobotResponse = (DescribeRobotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRobot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeRobotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeRobotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeRobotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$describeRobot$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRobotApplicationResponse describeRobotApplication(DescribeRobotApplicationRequest describeRobotApplicationRequest) throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRobotApplicationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, describeRobotApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRobotApplication");
            DescribeRobotApplicationResponse describeRobotApplicationResponse = (DescribeRobotApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRobotApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeRobotApplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeRobotApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeRobotApplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$describeRobotApplication$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSimulationApplicationResponse describeSimulationApplication(DescribeSimulationApplicationRequest describeSimulationApplicationRequest) throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSimulationApplicationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, describeSimulationApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSimulationApplication");
            DescribeSimulationApplicationResponse describeSimulationApplicationResponse = (DescribeSimulationApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSimulationApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSimulationApplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSimulationApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSimulationApplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$describeSimulationApplication$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSimulationJobResponse describeSimulationJob(DescribeSimulationJobRequest describeSimulationJobRequest) throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSimulationJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, describeSimulationJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSimulationJob");
            DescribeSimulationJobResponse describeSimulationJobResponse = (DescribeSimulationJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSimulationJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSimulationJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSimulationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSimulationJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$describeSimulationJob$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSimulationJobBatchResponse describeSimulationJobBatch(DescribeSimulationJobBatchRequest describeSimulationJobBatchRequest) throws ResourceNotFoundException, InvalidParameterException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSimulationJobBatchResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, describeSimulationJobBatchRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSimulationJobBatch");
            DescribeSimulationJobBatchResponse describeSimulationJobBatchResponse = (DescribeSimulationJobBatchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSimulationJobBatch").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSimulationJobBatchRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSimulationJobBatchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSimulationJobBatchResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$describeSimulationJobBatch$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeWorldResponse describeWorld(DescribeWorldRequest describeWorldRequest) throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeWorldResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, describeWorldRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeWorld");
            DescribeWorldResponse describeWorldResponse = (DescribeWorldResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeWorld").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeWorldRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeWorldRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeWorldResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$describeWorld$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeWorldExportJobResponse describeWorldExportJob(DescribeWorldExportJobRequest describeWorldExportJobRequest) throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeWorldExportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, describeWorldExportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeWorldExportJob");
            DescribeWorldExportJobResponse describeWorldExportJobResponse = (DescribeWorldExportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeWorldExportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeWorldExportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeWorldExportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeWorldExportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$describeWorldExportJob$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeWorldGenerationJobResponse describeWorldGenerationJob(DescribeWorldGenerationJobRequest describeWorldGenerationJobRequest) throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeWorldGenerationJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, describeWorldGenerationJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeWorldGenerationJob");
            DescribeWorldGenerationJobResponse describeWorldGenerationJobResponse = (DescribeWorldGenerationJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeWorldGenerationJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeWorldGenerationJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeWorldGenerationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeWorldGenerationJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$describeWorldGenerationJob$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeWorldTemplateResponse describeWorldTemplate(DescribeWorldTemplateRequest describeWorldTemplateRequest) throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeWorldTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, describeWorldTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeWorldTemplate");
            DescribeWorldTemplateResponse describeWorldTemplateResponse = (DescribeWorldTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeWorldTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeWorldTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeWorldTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeWorldTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$describeWorldTemplate$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetWorldTemplateBodyResponse getWorldTemplateBody(GetWorldTemplateBodyRequest getWorldTemplateBodyRequest) throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWorldTemplateBodyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, getWorldTemplateBodyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetWorldTemplateBody");
            GetWorldTemplateBodyResponse getWorldTemplateBodyResponse = (GetWorldTemplateBodyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWorldTemplateBody").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getWorldTemplateBodyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetWorldTemplateBodyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getWorldTemplateBodyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$getWorldTemplateBody$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDeploymentJobsResponse listDeploymentJobs(ListDeploymentJobsRequest listDeploymentJobsRequest) throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDeploymentJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, listDeploymentJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDeploymentJobs");
            ListDeploymentJobsResponse listDeploymentJobsResponse = (ListDeploymentJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDeploymentJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDeploymentJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDeploymentJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDeploymentJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$listDeploymentJobs$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListDeploymentJobsIterable listDeploymentJobsPaginator(ListDeploymentJobsRequest listDeploymentJobsRequest) throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        return new ListDeploymentJobsIterable(this, this.applyPaginatorUserAgent(listDeploymentJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFleetsResponse listFleets(ListFleetsRequest listFleetsRequest) throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFleetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, listFleetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFleets");
            ListFleetsResponse listFleetsResponse = (ListFleetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFleets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listFleetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListFleetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listFleetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$listFleets$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListFleetsIterable listFleetsPaginator(ListFleetsRequest listFleetsRequest) throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        return new ListFleetsIterable(this, this.applyPaginatorUserAgent(listFleetsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRobotApplicationsResponse listRobotApplications(ListRobotApplicationsRequest listRobotApplicationsRequest) throws InvalidParameterException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRobotApplicationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, listRobotApplicationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRobotApplications");
            ListRobotApplicationsResponse listRobotApplicationsResponse = (ListRobotApplicationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRobotApplications").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRobotApplicationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRobotApplicationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRobotApplicationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$listRobotApplications$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListRobotApplicationsIterable listRobotApplicationsPaginator(ListRobotApplicationsRequest listRobotApplicationsRequest) throws InvalidParameterException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        return new ListRobotApplicationsIterable(this, this.applyPaginatorUserAgent(listRobotApplicationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRobotsResponse listRobots(ListRobotsRequest listRobotsRequest) throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRobotsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, listRobotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRobots");
            ListRobotsResponse listRobotsResponse = (ListRobotsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRobots").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRobotsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRobotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRobotsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$listRobots$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListRobotsIterable listRobotsPaginator(ListRobotsRequest listRobotsRequest) throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        return new ListRobotsIterable(this, this.applyPaginatorUserAgent(listRobotsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSimulationApplicationsResponse listSimulationApplications(ListSimulationApplicationsRequest listSimulationApplicationsRequest) throws InvalidParameterException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSimulationApplicationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, listSimulationApplicationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSimulationApplications");
            ListSimulationApplicationsResponse listSimulationApplicationsResponse = (ListSimulationApplicationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSimulationApplications").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSimulationApplicationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSimulationApplicationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSimulationApplicationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$listSimulationApplications$40((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListSimulationApplicationsIterable listSimulationApplicationsPaginator(ListSimulationApplicationsRequest listSimulationApplicationsRequest) throws InvalidParameterException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        return new ListSimulationApplicationsIterable(this, this.applyPaginatorUserAgent(listSimulationApplicationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSimulationJobBatchesResponse listSimulationJobBatches(ListSimulationJobBatchesRequest listSimulationJobBatchesRequest) throws InvalidParameterException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSimulationJobBatchesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, listSimulationJobBatchesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSimulationJobBatches");
            ListSimulationJobBatchesResponse listSimulationJobBatchesResponse = (ListSimulationJobBatchesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSimulationJobBatches").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSimulationJobBatchesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSimulationJobBatchesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSimulationJobBatchesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$listSimulationJobBatches$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListSimulationJobBatchesIterable listSimulationJobBatchesPaginator(ListSimulationJobBatchesRequest listSimulationJobBatchesRequest) throws InvalidParameterException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        return new ListSimulationJobBatchesIterable(this, this.applyPaginatorUserAgent(listSimulationJobBatchesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSimulationJobsResponse listSimulationJobs(ListSimulationJobsRequest listSimulationJobsRequest) throws InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSimulationJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, listSimulationJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSimulationJobs");
            ListSimulationJobsResponse listSimulationJobsResponse = (ListSimulationJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSimulationJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSimulationJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSimulationJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSimulationJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$listSimulationJobs$42((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListSimulationJobsIterable listSimulationJobsPaginator(ListSimulationJobsRequest listSimulationJobsRequest) throws InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        return new ListSimulationJobsIterable(this, this.applyPaginatorUserAgent(listSimulationJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InternalServerException, ResourceNotFoundException, InvalidParameterException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$listTagsForResource$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListWorldExportJobsResponse listWorldExportJobs(ListWorldExportJobsRequest listWorldExportJobsRequest) throws InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWorldExportJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, listWorldExportJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWorldExportJobs");
            ListWorldExportJobsResponse listWorldExportJobsResponse = (ListWorldExportJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWorldExportJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listWorldExportJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListWorldExportJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listWorldExportJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$listWorldExportJobs$44((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListWorldExportJobsIterable listWorldExportJobsPaginator(ListWorldExportJobsRequest listWorldExportJobsRequest) throws InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        return new ListWorldExportJobsIterable(this, this.applyPaginatorUserAgent(listWorldExportJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListWorldGenerationJobsResponse listWorldGenerationJobs(ListWorldGenerationJobsRequest listWorldGenerationJobsRequest) throws InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWorldGenerationJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, listWorldGenerationJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWorldGenerationJobs");
            ListWorldGenerationJobsResponse listWorldGenerationJobsResponse = (ListWorldGenerationJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWorldGenerationJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listWorldGenerationJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListWorldGenerationJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listWorldGenerationJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$listWorldGenerationJobs$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListWorldGenerationJobsIterable listWorldGenerationJobsPaginator(ListWorldGenerationJobsRequest listWorldGenerationJobsRequest) throws InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        return new ListWorldGenerationJobsIterable(this, this.applyPaginatorUserAgent(listWorldGenerationJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListWorldTemplatesResponse listWorldTemplates(ListWorldTemplatesRequest listWorldTemplatesRequest) throws InvalidParameterException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWorldTemplatesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, listWorldTemplatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWorldTemplates");
            ListWorldTemplatesResponse listWorldTemplatesResponse = (ListWorldTemplatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWorldTemplates").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listWorldTemplatesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListWorldTemplatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listWorldTemplatesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$listWorldTemplates$46((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListWorldTemplatesIterable listWorldTemplatesPaginator(ListWorldTemplatesRequest listWorldTemplatesRequest) throws InvalidParameterException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        return new ListWorldTemplatesIterable(this, this.applyPaginatorUserAgent(listWorldTemplatesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListWorldsResponse listWorlds(ListWorldsRequest listWorldsRequest) throws InvalidParameterException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWorldsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, listWorldsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWorlds");
            ListWorldsResponse listWorldsResponse = (ListWorldsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWorlds").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listWorldsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListWorldsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listWorldsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$listWorlds$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListWorldsIterable listWorldsPaginator(ListWorldsRequest listWorldsRequest) throws InvalidParameterException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        return new ListWorldsIterable(this, this.applyPaginatorUserAgent(listWorldsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterRobotResponse registerRobot(RegisterRobotRequest registerRobotRequest) throws InvalidParameterException, InternalServerException, ThrottlingException, LimitExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterRobotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, registerRobotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterRobot");
            RegisterRobotResponse registerRobotResponse = (RegisterRobotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterRobot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)registerRobotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RegisterRobotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return registerRobotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$registerRobot$48((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestartSimulationJobResponse restartSimulationJob(RestartSimulationJobRequest restartSimulationJobRequest) throws ResourceNotFoundException, ThrottlingException, LimitExceededException, InvalidParameterException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestartSimulationJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, restartSimulationJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestartSimulationJob");
            RestartSimulationJobResponse restartSimulationJobResponse = (RestartSimulationJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestartSimulationJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)restartSimulationJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RestartSimulationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return restartSimulationJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$restartSimulationJob$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartSimulationJobBatchResponse startSimulationJobBatch(StartSimulationJobBatchRequest startSimulationJobBatchRequest) throws InvalidParameterException, LimitExceededException, ThrottlingException, IdempotentParameterMismatchException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartSimulationJobBatchResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, startSimulationJobBatchRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartSimulationJobBatch");
            StartSimulationJobBatchResponse startSimulationJobBatchResponse = (StartSimulationJobBatchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartSimulationJobBatch").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startSimulationJobBatchRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartSimulationJobBatchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startSimulationJobBatchResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$startSimulationJobBatch$50((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SyncDeploymentJobResponse syncDeploymentJob(SyncDeploymentJobRequest syncDeploymentJobRequest) throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException, LimitExceededException, ConcurrentDeploymentException, IdempotentParameterMismatchException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SyncDeploymentJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, syncDeploymentJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SyncDeploymentJob");
            SyncDeploymentJobResponse syncDeploymentJobResponse = (SyncDeploymentJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SyncDeploymentJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)syncDeploymentJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SyncDeploymentJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return syncDeploymentJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$syncDeploymentJob$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException, ResourceNotFoundException, InvalidParameterException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$tagResource$52((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException, ResourceNotFoundException, InvalidParameterException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$untagResource$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateRobotApplicationResponse updateRobotApplication(UpdateRobotApplicationRequest updateRobotApplicationRequest) throws InvalidParameterException, ResourceNotFoundException, LimitExceededException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRobotApplicationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, updateRobotApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRobotApplication");
            UpdateRobotApplicationResponse updateRobotApplicationResponse = (UpdateRobotApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRobotApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateRobotApplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateRobotApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateRobotApplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$updateRobotApplication$54((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSimulationApplicationResponse updateSimulationApplication(UpdateSimulationApplicationRequest updateSimulationApplicationRequest) throws InvalidParameterException, ResourceNotFoundException, LimitExceededException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSimulationApplicationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, updateSimulationApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSimulationApplication");
            UpdateSimulationApplicationResponse updateSimulationApplicationResponse = (UpdateSimulationApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSimulationApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateSimulationApplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateSimulationApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateSimulationApplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$updateSimulationApplication$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateWorldTemplateResponse updateWorldTemplate(UpdateWorldTemplateRequest updateWorldTemplateRequest) throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateWorldTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoboMakerClient.resolveMetricPublishers(this.clientConfiguration, updateWorldTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateWorldTemplate");
            UpdateWorldTemplateResponse updateWorldTemplateResponse = (UpdateWorldTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateWorldTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateWorldTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateWorldTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateWorldTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoboMakerClient.lambda$updateWorldTemplate$56((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(RoboMakerException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterException").exceptionBuilderSupplier(InvalidParameterException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentDeploymentException").exceptionBuilderSupplier(ConcurrentDeploymentException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").exceptionBuilderSupplier(ServiceUnavailableException::builder).httpStatusCode(Integer.valueOf(503)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends RoboMakerRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.15.37").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((RoboMakerRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updateWorldTemplate$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSimulationApplication$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRobotApplication$54(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$52(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$syncDeploymentJob$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startSimulationJobBatch$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restartSimulationJob$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerRobot$48(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listWorlds$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listWorldTemplates$46(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listWorldGenerationJobs$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listWorldExportJobs$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSimulationJobs$42(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSimulationJobBatches$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSimulationApplications$40(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRobots$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRobotApplications$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFleets$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDeploymentJobs$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getWorldTemplateBody$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeWorldTemplate$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeWorldGenerationJob$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeWorldExportJob$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeWorld$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSimulationJobBatch$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSimulationJob$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSimulationApplication$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeRobotApplication$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeRobot$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFleet$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDeploymentJob$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deregisterRobot$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteWorldTemplate$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSimulationApplication$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRobotApplication$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRobot$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFleet$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createWorldTemplate$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createWorldGenerationJob$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createWorldExportJob$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSimulationJob$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSimulationApplicationVersion$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSimulationApplication$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRobotApplicationVersion$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRobotApplication$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRobot$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFleet$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDeploymentJob$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelWorldGenerationJob$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelWorldExportJob$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelSimulationJobBatch$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelSimulationJob$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelDeploymentJob$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDescribeSimulationJob$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDeleteWorlds$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

