/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.robomaker.model.Architecture;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Source
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Source> {
    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Source.getter(Source::s3Bucket)).setter(Source.setter(Builder::s3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Bucket").build()}).build();
    private static final SdkField<String> S3_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Source.getter(Source::s3Key)).setter(Source.setter(Builder::s3Key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Key").build()}).build();
    private static final SdkField<String> ETAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Source.getter(Source::etag)).setter(Source.setter(Builder::etag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("etag").build()}).build();
    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Source.getter(Source::architectureAsString)).setter(Source.setter(Builder::architecture)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("architecture").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_FIELD, S3_KEY_FIELD, ETAG_FIELD, ARCHITECTURE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String s3Bucket;
    private final String s3Key;
    private final String etag;
    private final String architecture;

    private Source(BuilderImpl builder) {
        this.s3Bucket = builder.s3Bucket;
        this.s3Key = builder.s3Key;
        this.etag = builder.etag;
        this.architecture = builder.architecture;
    }

    public String s3Bucket() {
        return this.s3Bucket;
    }

    public String s3Key() {
        return this.s3Key;
    }

    public String etag() {
        return this.etag;
    }

    public Architecture architecture() {
        return Architecture.fromValue(this.architecture);
    }

    public String architectureAsString() {
        return this.architecture;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Key());
        hashCode = 31 * hashCode + Objects.hashCode(this.etag());
        hashCode = 31 * hashCode + Objects.hashCode(this.architectureAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Source)) {
            return false;
        }
        Source other = (Source)obj;
        return Objects.equals(this.s3Bucket(), other.s3Bucket()) && Objects.equals(this.s3Key(), other.s3Key()) && Objects.equals(this.etag(), other.etag()) && Objects.equals(this.architectureAsString(), other.architectureAsString());
    }

    public String toString() {
        return ToString.builder((String)"Source").add("S3Bucket", (Object)this.s3Bucket()).add("S3Key", (Object)this.s3Key()).add("Etag", (Object)this.etag()).add("Architecture", (Object)this.architectureAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3Bucket": {
                return Optional.ofNullable(clazz.cast(this.s3Bucket()));
            }
            case "s3Key": {
                return Optional.ofNullable(clazz.cast(this.s3Key()));
            }
            case "etag": {
                return Optional.ofNullable(clazz.cast(this.etag()));
            }
            case "architecture": {
                return Optional.ofNullable(clazz.cast(this.architectureAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Source, T> g) {
        return obj -> g.apply((Source)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3Bucket;
        private String s3Key;
        private String etag;
        private String architecture;

        private BuilderImpl() {
        }

        private BuilderImpl(Source model) {
            this.s3Bucket(model.s3Bucket);
            this.s3Key(model.s3Key);
            this.etag(model.etag);
            this.architecture(model.architecture);
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        public final String getS3Key() {
            return this.s3Key;
        }

        @Override
        public final Builder s3Key(String s3Key) {
            this.s3Key = s3Key;
            return this;
        }

        public final void setS3Key(String s3Key) {
            this.s3Key = s3Key;
        }

        public final String getEtag() {
            return this.etag;
        }

        @Override
        public final Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public final void setEtag(String etag) {
            this.etag = etag;
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(Architecture architecture) {
            this.architecture(architecture == null ? null : architecture.toString());
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public Source build() {
            return new Source(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Source> {
        public Builder s3Bucket(String var1);

        public Builder s3Key(String var1);

        public Builder etag(String var1);

        public Builder architecture(String var1);

        public Builder architecture(Architecture var1);
    }
}

