/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * VPC configuration associated with your simulation job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VPCConfigResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<VPCConfigResponse.Builder, VPCConfigResponse> {
    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(VPCConfigResponse::subnets))
            .setter(setter(Builder::subnets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(VPCConfigResponse::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VPCConfigResponse::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcId").build()).build();

    private static final SdkField<Boolean> ASSIGN_PUBLIC_IP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(VPCConfigResponse::assignPublicIp)).setter(setter(Builder::assignPublicIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assignPublicIp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNETS_FIELD,
            SECURITY_GROUPS_FIELD, VPC_ID_FIELD, ASSIGN_PUBLIC_IP_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> subnets;

    private final List<String> securityGroups;

    private final String vpcId;

    private final Boolean assignPublicIp;

    private VPCConfigResponse(BuilderImpl builder) {
        this.subnets = builder.subnets;
        this.securityGroups = builder.securityGroups;
        this.vpcId = builder.vpcId;
        this.assignPublicIp = builder.assignPublicIp;
    }

    /**
     * Returns true if the Subnets property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSubnets() {
        return subnets != null && !(subnets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of subnet IDs associated with the simulation job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubnets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of subnet IDs associated with the simulation job.
     */
    public List<String> subnets() {
        return subnets;
    }

    /**
     * Returns true if the SecurityGroups property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of security group IDs associated with the simulation job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of security group IDs associated with the simulation job.
     */
    public List<String> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * The VPC ID associated with your simulation job.
     * </p>
     * 
     * @return The VPC ID associated with your simulation job.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * A boolean indicating if a public IP was assigned.
     * </p>
     * 
     * @return A boolean indicating if a public IP was assigned.
     */
    public Boolean assignPublicIp() {
        return assignPublicIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subnets());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(assignPublicIp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VPCConfigResponse)) {
            return false;
        }
        VPCConfigResponse other = (VPCConfigResponse) obj;
        return Objects.equals(subnets(), other.subnets()) && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(vpcId(), other.vpcId()) && Objects.equals(assignPublicIp(), other.assignPublicIp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VPCConfigResponse").add("Subnets", subnets()).add("SecurityGroups", securityGroups())
                .add("VpcId", vpcId()).add("AssignPublicIp", assignPublicIp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "subnets":
            return Optional.ofNullable(clazz.cast(subnets()));
        case "securityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "vpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "assignPublicIp":
            return Optional.ofNullable(clazz.cast(assignPublicIp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VPCConfigResponse, T> g) {
        return obj -> g.apply((VPCConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VPCConfigResponse> {
        /**
         * <p>
         * A list of subnet IDs associated with the simulation job.
         * </p>
         * 
         * @param subnets
         *        A list of subnet IDs associated with the simulation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(Collection<String> subnets);

        /**
         * <p>
         * A list of subnet IDs associated with the simulation job.
         * </p>
         * 
         * @param subnets
         *        A list of subnet IDs associated with the simulation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(String... subnets);

        /**
         * <p>
         * A list of security group IDs associated with the simulation job.
         * </p>
         * 
         * @param securityGroups
         *        A list of security group IDs associated with the simulation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * A list of security group IDs associated with the simulation job.
         * </p>
         * 
         * @param securityGroups
         *        A list of security group IDs associated with the simulation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         * <p>
         * The VPC ID associated with your simulation job.
         * </p>
         * 
         * @param vpcId
         *        The VPC ID associated with your simulation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * A boolean indicating if a public IP was assigned.
         * </p>
         * 
         * @param assignPublicIp
         *        A boolean indicating if a public IP was assigned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignPublicIp(Boolean assignPublicIp);
    }

    static final class BuilderImpl implements Builder {
        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private String vpcId;

        private Boolean assignPublicIp;

        private BuilderImpl() {
        }

        private BuilderImpl(VPCConfigResponse model) {
            subnets(model.subnets);
            securityGroups(model.securityGroups);
            vpcId(model.vpcId);
            assignPublicIp(model.assignPublicIp);
        }

        public final Collection<String> getSubnets() {
            return subnets;
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String... subnets) {
            subnets(Arrays.asList(subnets));
            return this;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
        }

        public final Collection<String> getSecurityGroups() {
            return securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Boolean getAssignPublicIp() {
            return assignPublicIp;
        }

        @Override
        public final Builder assignPublicIp(Boolean assignPublicIp) {
            this.assignPublicIp = assignPublicIp;
            return this;
        }

        public final void setAssignPublicIp(Boolean assignPublicIp) {
            this.assignPublicIp = assignPublicIp;
        }

        @Override
        public VPCConfigResponse build() {
            return new VPCConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
