/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a fleet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Fleet implements SdkPojo, Serializable, ToCopyableBuilder<Fleet.Builder, Fleet> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Fleet::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Fleet::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Fleet::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> LAST_DEPLOYMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Fleet::lastDeploymentStatusAsString)).setter(setter(Builder::lastDeploymentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDeploymentStatus").build())
            .build();

    private static final SdkField<String> LAST_DEPLOYMENT_JOB_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Fleet::lastDeploymentJob)).setter(setter(Builder::lastDeploymentJob))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDeploymentJob").build()).build();

    private static final SdkField<Instant> LAST_DEPLOYMENT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Fleet::lastDeploymentTime)).setter(setter(Builder::lastDeploymentTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDeploymentTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            CREATED_AT_FIELD, LAST_DEPLOYMENT_STATUS_FIELD, LAST_DEPLOYMENT_JOB_FIELD, LAST_DEPLOYMENT_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String arn;

    private final Instant createdAt;

    private final String lastDeploymentStatus;

    private final String lastDeploymentJob;

    private final Instant lastDeploymentTime;

    private Fleet(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.lastDeploymentStatus = builder.lastDeploymentStatus;
        this.lastDeploymentJob = builder.lastDeploymentJob;
        this.lastDeploymentTime = builder.lastDeploymentTime;
    }

    /**
     * <p>
     * The name of the fleet.
     * </p>
     * 
     * @return The name of the fleet.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the fleet.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the fleet.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the fleet was created.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the fleet was created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The status of the last fleet deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lastDeploymentStatus} will return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #lastDeploymentStatusAsString}.
     * </p>
     * 
     * @return The status of the last fleet deployment.
     * @see DeploymentStatus
     */
    public DeploymentStatus lastDeploymentStatus() {
        return DeploymentStatus.fromValue(lastDeploymentStatus);
    }

    /**
     * <p>
     * The status of the last fleet deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lastDeploymentStatus} will return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #lastDeploymentStatusAsString}.
     * </p>
     * 
     * @return The status of the last fleet deployment.
     * @see DeploymentStatus
     */
    public String lastDeploymentStatusAsString() {
        return lastDeploymentStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the last deployment job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the last deployment job.
     */
    public String lastDeploymentJob() {
        return lastDeploymentJob;
    }

    /**
     * <p>
     * The time of the last deployment.
     * </p>
     * 
     * @return The time of the last deployment.
     */
    public Instant lastDeploymentTime() {
        return lastDeploymentTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastDeploymentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastDeploymentJob());
        hashCode = 31 * hashCode + Objects.hashCode(lastDeploymentTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Fleet)) {
            return false;
        }
        Fleet other = (Fleet) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(lastDeploymentStatusAsString(), other.lastDeploymentStatusAsString())
                && Objects.equals(lastDeploymentJob(), other.lastDeploymentJob())
                && Objects.equals(lastDeploymentTime(), other.lastDeploymentTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Fleet").add("Name", name()).add("Arn", arn()).add("CreatedAt", createdAt())
                .add("LastDeploymentStatus", lastDeploymentStatusAsString()).add("LastDeploymentJob", lastDeploymentJob())
                .add("LastDeploymentTime", lastDeploymentTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastDeploymentStatus":
            return Optional.ofNullable(clazz.cast(lastDeploymentStatusAsString()));
        case "lastDeploymentJob":
            return Optional.ofNullable(clazz.cast(lastDeploymentJob()));
        case "lastDeploymentTime":
            return Optional.ofNullable(clazz.cast(lastDeploymentTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Fleet, T> g) {
        return obj -> g.apply((Fleet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Fleet> {
        /**
         * <p>
         * The name of the fleet.
         * </p>
         * 
         * @param name
         *        The name of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the fleet.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the fleet was created.
         * </p>
         * 
         * @param createdAt
         *        The time, in milliseconds since the epoch, when the fleet was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The status of the last fleet deployment.
         * </p>
         * 
         * @param lastDeploymentStatus
         *        The status of the last fleet deployment.
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder lastDeploymentStatus(String lastDeploymentStatus);

        /**
         * <p>
         * The status of the last fleet deployment.
         * </p>
         * 
         * @param lastDeploymentStatus
         *        The status of the last fleet deployment.
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder lastDeploymentStatus(DeploymentStatus lastDeploymentStatus);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the last deployment job.
         * </p>
         * 
         * @param lastDeploymentJob
         *        The Amazon Resource Name (ARN) of the last deployment job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDeploymentJob(String lastDeploymentJob);

        /**
         * <p>
         * The time of the last deployment.
         * </p>
         * 
         * @param lastDeploymentTime
         *        The time of the last deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDeploymentTime(Instant lastDeploymentTime);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private Instant createdAt;

        private String lastDeploymentStatus;

        private String lastDeploymentJob;

        private Instant lastDeploymentTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Fleet model) {
            name(model.name);
            arn(model.arn);
            createdAt(model.createdAt);
            lastDeploymentStatus(model.lastDeploymentStatus);
            lastDeploymentJob(model.lastDeploymentJob);
            lastDeploymentTime(model.lastDeploymentTime);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getLastDeploymentStatus() {
            return lastDeploymentStatus;
        }

        @Override
        public final Builder lastDeploymentStatus(String lastDeploymentStatus) {
            this.lastDeploymentStatus = lastDeploymentStatus;
            return this;
        }

        @Override
        public final Builder lastDeploymentStatus(DeploymentStatus lastDeploymentStatus) {
            this.lastDeploymentStatus(lastDeploymentStatus == null ? null : lastDeploymentStatus.toString());
            return this;
        }

        public final void setLastDeploymentStatus(String lastDeploymentStatus) {
            this.lastDeploymentStatus = lastDeploymentStatus;
        }

        public final String getLastDeploymentJob() {
            return lastDeploymentJob;
        }

        @Override
        public final Builder lastDeploymentJob(String lastDeploymentJob) {
            this.lastDeploymentJob = lastDeploymentJob;
            return this;
        }

        public final void setLastDeploymentJob(String lastDeploymentJob) {
            this.lastDeploymentJob = lastDeploymentJob;
        }

        public final Instant getLastDeploymentTime() {
            return lastDeploymentTime;
        }

        @Override
        public final Builder lastDeploymentTime(Instant lastDeploymentTime) {
            this.lastDeploymentTime = lastDeploymentTime;
            return this;
        }

        public final void setLastDeploymentTime(Instant lastDeploymentTime) {
            this.lastDeploymentTime = lastDeploymentTime;
        }

        @Override
        public Fleet build() {
            return new Fleet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
