/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum SimulationJobErrorCode {
    INTERNAL_SERVICE_ERROR("InternalServiceError"),

    ROBOT_APPLICATION_CRASH("RobotApplicationCrash"),

    SIMULATION_APPLICATION_CRASH("SimulationApplicationCrash"),

    BAD_PERMISSIONS_ROBOT_APPLICATION("BadPermissionsRobotApplication"),

    BAD_PERMISSIONS_SIMULATION_APPLICATION("BadPermissionsSimulationApplication"),

    BAD_PERMISSIONS_S3_OBJECT("BadPermissionsS3Object"),

    BAD_PERMISSIONS_S3_OUTPUT("BadPermissionsS3Output"),

    BAD_PERMISSIONS_CLOUDWATCH_LOGS("BadPermissionsCloudwatchLogs"),

    SUBNET_IP_LIMIT_EXCEEDED("SubnetIpLimitExceeded"),

    ENI_LIMIT_EXCEEDED("ENILimitExceeded"),

    BAD_PERMISSIONS_USER_CREDENTIALS("BadPermissionsUserCredentials"),

    INVALID_BUNDLE_ROBOT_APPLICATION("InvalidBundleRobotApplication"),

    INVALID_BUNDLE_SIMULATION_APPLICATION("InvalidBundleSimulationApplication"),

    INVALID_S3_RESOURCE("InvalidS3Resource"),

    MISMATCHED_ETAG("MismatchedEtag"),

    ROBOT_APPLICATION_VERSION_MISMATCHED_ETAG("RobotApplicationVersionMismatchedEtag"),

    SIMULATION_APPLICATION_VERSION_MISMATCHED_ETAG("SimulationApplicationVersionMismatchedEtag"),

    RESOURCE_NOT_FOUND("ResourceNotFound"),

    INVALID_INPUT("InvalidInput"),

    WRONG_REGION_S3_BUCKET("WrongRegionS3Bucket"),

    WRONG_REGION_S3_OUTPUT("WrongRegionS3Output"),

    WRONG_REGION_ROBOT_APPLICATION("WrongRegionRobotApplication"),

    WRONG_REGION_SIMULATION_APPLICATION("WrongRegionSimulationApplication"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private SimulationJobErrorCode(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return SimulationJobErrorCode corresponding to the value
     */
    public static SimulationJobErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(SimulationJobErrorCode.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link SimulationJobErrorCode}s
     */
    public static Set<SimulationJobErrorCode> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
