/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSimulationApplicationVersionResponse extends RoboMakerResponse implements
        ToCopyableBuilder<CreateSimulationApplicationVersionResponse.Builder, CreateSimulationApplicationVersionResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSimulationApplicationVersionResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSimulationApplicationVersionResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSimulationApplicationVersionResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<List<Source>> SOURCES_FIELD = SdkField
            .<List<Source>> builder(MarshallingType.LIST)
            .getter(getter(CreateSimulationApplicationVersionResponse::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Source> builder(MarshallingType.SDK_POJO)
                                            .constructor(Source::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SimulationSoftwareSuite> SIMULATION_SOFTWARE_SUITE_FIELD = SdkField
            .<SimulationSoftwareSuite> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateSimulationApplicationVersionResponse::simulationSoftwareSuite))
            .setter(setter(Builder::simulationSoftwareSuite)).constructor(SimulationSoftwareSuite::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("simulationSoftwareSuite").build())
            .build();

    private static final SdkField<RobotSoftwareSuite> ROBOT_SOFTWARE_SUITE_FIELD = SdkField
            .<RobotSoftwareSuite> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateSimulationApplicationVersionResponse::robotSoftwareSuite))
            .setter(setter(Builder::robotSoftwareSuite)).constructor(RobotSoftwareSuite::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("robotSoftwareSuite").build())
            .build();

    private static final SdkField<RenderingEngine> RENDERING_ENGINE_FIELD = SdkField
            .<RenderingEngine> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateSimulationApplicationVersionResponse::renderingEngine)).setter(setter(Builder::renderingEngine))
            .constructor(RenderingEngine::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renderingEngine").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(CreateSimulationApplicationVersionResponse::lastUpdatedAt)).setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSimulationApplicationVersionResponse::revisionId)).setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            VERSION_FIELD, SOURCES_FIELD, SIMULATION_SOFTWARE_SUITE_FIELD, ROBOT_SOFTWARE_SUITE_FIELD, RENDERING_ENGINE_FIELD,
            LAST_UPDATED_AT_FIELD, REVISION_ID_FIELD));

    private final String arn;

    private final String name;

    private final String version;

    private final List<Source> sources;

    private final SimulationSoftwareSuite simulationSoftwareSuite;

    private final RobotSoftwareSuite robotSoftwareSuite;

    private final RenderingEngine renderingEngine;

    private final Instant lastUpdatedAt;

    private final String revisionId;

    private CreateSimulationApplicationVersionResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.version = builder.version;
        this.sources = builder.sources;
        this.simulationSoftwareSuite = builder.simulationSoftwareSuite;
        this.robotSoftwareSuite = builder.robotSoftwareSuite;
        this.renderingEngine = builder.renderingEngine;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.revisionId = builder.revisionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the simulation application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the simulation application.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the simulation application.
     * </p>
     * 
     * @return The name of the simulation application.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The version of the simulation application.
     * </p>
     * 
     * @return The version of the simulation application.
     */
    public String version() {
        return version;
    }

    /**
     * Returns true if the Sources property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The sources of the simulation application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSources()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The sources of the simulation application.
     */
    public List<Source> sources() {
        return sources;
    }

    /**
     * <p>
     * The simulation software suite used by the simulation application.
     * </p>
     * 
     * @return The simulation software suite used by the simulation application.
     */
    public SimulationSoftwareSuite simulationSoftwareSuite() {
        return simulationSoftwareSuite;
    }

    /**
     * <p>
     * Information about the robot software suite.
     * </p>
     * 
     * @return Information about the robot software suite.
     */
    public RobotSoftwareSuite robotSoftwareSuite() {
        return robotSoftwareSuite;
    }

    /**
     * <p>
     * The rendering engine for the simulation application.
     * </p>
     * 
     * @return The rendering engine for the simulation application.
     */
    public RenderingEngine renderingEngine() {
        return renderingEngine;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the simulation application was last updated.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the simulation application was last updated.
     */
    public Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The revision ID of the simulation application.
     * </p>
     * 
     * @return The revision ID of the simulation application.
     */
    public String revisionId() {
        return revisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(sources());
        hashCode = 31 * hashCode + Objects.hashCode(simulationSoftwareSuite());
        hashCode = 31 * hashCode + Objects.hashCode(robotSoftwareSuite());
        hashCode = 31 * hashCode + Objects.hashCode(renderingEngine());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSimulationApplicationVersionResponse)) {
            return false;
        }
        CreateSimulationApplicationVersionResponse other = (CreateSimulationApplicationVersionResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(version(), other.version()) && Objects.equals(sources(), other.sources())
                && Objects.equals(simulationSoftwareSuite(), other.simulationSoftwareSuite())
                && Objects.equals(robotSoftwareSuite(), other.robotSoftwareSuite())
                && Objects.equals(renderingEngine(), other.renderingEngine())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(revisionId(), other.revisionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateSimulationApplicationVersionResponse").add("Arn", arn()).add("Name", name())
                .add("Version", version()).add("Sources", sources()).add("SimulationSoftwareSuite", simulationSoftwareSuite())
                .add("RobotSoftwareSuite", robotSoftwareSuite()).add("RenderingEngine", renderingEngine())
                .add("LastUpdatedAt", lastUpdatedAt()).add("RevisionId", revisionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "sources":
            return Optional.ofNullable(clazz.cast(sources()));
        case "simulationSoftwareSuite":
            return Optional.ofNullable(clazz.cast(simulationSoftwareSuite()));
        case "robotSoftwareSuite":
            return Optional.ofNullable(clazz.cast(robotSoftwareSuite()));
        case "renderingEngine":
            return Optional.ofNullable(clazz.cast(renderingEngine()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "revisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSimulationApplicationVersionResponse, T> g) {
        return obj -> g.apply((CreateSimulationApplicationVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RoboMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateSimulationApplicationVersionResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the simulation application.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the simulation application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the simulation application.
         * </p>
         * 
         * @param name
         *        The name of the simulation application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The version of the simulation application.
         * </p>
         * 
         * @param version
         *        The version of the simulation application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The sources of the simulation application.
         * </p>
         * 
         * @param sources
         *        The sources of the simulation application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<Source> sources);

        /**
         * <p>
         * The sources of the simulation application.
         * </p>
         * 
         * @param sources
         *        The sources of the simulation application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Source... sources);

        /**
         * <p>
         * The sources of the simulation application.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Source>.Builder} avoiding the need to
         * create one manually via {@link List<Source>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Source>.Builder#build()} is called immediately and its
         * result is passed to {@link #sources(List<Source>)}.
         * 
         * @param sources
         *        a consumer that will call methods on {@link List<Source>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sources(List<Source>)
         */
        Builder sources(Consumer<Source.Builder>... sources);

        /**
         * <p>
         * The simulation software suite used by the simulation application.
         * </p>
         * 
         * @param simulationSoftwareSuite
         *        The simulation software suite used by the simulation application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simulationSoftwareSuite(SimulationSoftwareSuite simulationSoftwareSuite);

        /**
         * <p>
         * The simulation software suite used by the simulation application.
         * </p>
         * This is a convenience that creates an instance of the {@link SimulationSoftwareSuite.Builder} avoiding the
         * need to create one manually via {@link SimulationSoftwareSuite#builder()}.
         *
         * When the {@link Consumer} completes, {@link SimulationSoftwareSuite.Builder#build()} is called immediately
         * and its result is passed to {@link #simulationSoftwareSuite(SimulationSoftwareSuite)}.
         * 
         * @param simulationSoftwareSuite
         *        a consumer that will call methods on {@link SimulationSoftwareSuite.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #simulationSoftwareSuite(SimulationSoftwareSuite)
         */
        default Builder simulationSoftwareSuite(Consumer<SimulationSoftwareSuite.Builder> simulationSoftwareSuite) {
            return simulationSoftwareSuite(SimulationSoftwareSuite.builder().applyMutation(simulationSoftwareSuite).build());
        }

        /**
         * <p>
         * Information about the robot software suite.
         * </p>
         * 
         * @param robotSoftwareSuite
         *        Information about the robot software suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder robotSoftwareSuite(RobotSoftwareSuite robotSoftwareSuite);

        /**
         * <p>
         * Information about the robot software suite.
         * </p>
         * This is a convenience that creates an instance of the {@link RobotSoftwareSuite.Builder} avoiding the need to
         * create one manually via {@link RobotSoftwareSuite#builder()}.
         *
         * When the {@link Consumer} completes, {@link RobotSoftwareSuite.Builder#build()} is called immediately and its
         * result is passed to {@link #robotSoftwareSuite(RobotSoftwareSuite)}.
         * 
         * @param robotSoftwareSuite
         *        a consumer that will call methods on {@link RobotSoftwareSuite.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #robotSoftwareSuite(RobotSoftwareSuite)
         */
        default Builder robotSoftwareSuite(Consumer<RobotSoftwareSuite.Builder> robotSoftwareSuite) {
            return robotSoftwareSuite(RobotSoftwareSuite.builder().applyMutation(robotSoftwareSuite).build());
        }

        /**
         * <p>
         * The rendering engine for the simulation application.
         * </p>
         * 
         * @param renderingEngine
         *        The rendering engine for the simulation application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renderingEngine(RenderingEngine renderingEngine);

        /**
         * <p>
         * The rendering engine for the simulation application.
         * </p>
         * This is a convenience that creates an instance of the {@link RenderingEngine.Builder} avoiding the need to
         * create one manually via {@link RenderingEngine#builder()}.
         *
         * When the {@link Consumer} completes, {@link RenderingEngine.Builder#build()} is called immediately and its
         * result is passed to {@link #renderingEngine(RenderingEngine)}.
         * 
         * @param renderingEngine
         *        a consumer that will call methods on {@link RenderingEngine.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #renderingEngine(RenderingEngine)
         */
        default Builder renderingEngine(Consumer<RenderingEngine.Builder> renderingEngine) {
            return renderingEngine(RenderingEngine.builder().applyMutation(renderingEngine).build());
        }

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the simulation application was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The time, in milliseconds since the epoch, when the simulation application was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The revision ID of the simulation application.
         * </p>
         * 
         * @param revisionId
         *        The revision ID of the simulation application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);
    }

    static final class BuilderImpl extends RoboMakerResponse.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String version;

        private List<Source> sources = DefaultSdkAutoConstructList.getInstance();

        private SimulationSoftwareSuite simulationSoftwareSuite;

        private RobotSoftwareSuite robotSoftwareSuite;

        private RenderingEngine renderingEngine;

        private Instant lastUpdatedAt;

        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSimulationApplicationVersionResponse model) {
            super(model);
            arn(model.arn);
            name(model.name);
            version(model.version);
            sources(model.sources);
            simulationSoftwareSuite(model.simulationSoftwareSuite);
            robotSoftwareSuite(model.robotSoftwareSuite);
            renderingEngine(model.renderingEngine);
            lastUpdatedAt(model.lastUpdatedAt);
            revisionId(model.revisionId);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final Collection<Source.Builder> getSources() {
            return sources != null ? sources.stream().map(Source::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sources(Collection<Source> sources) {
            this.sources = SourcesCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Source... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<Source.Builder>... sources) {
            sources(Stream.of(sources).map(c -> Source.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSources(Collection<Source.BuilderImpl> sources) {
            this.sources = SourcesCopier.copyFromBuilder(sources);
        }

        public final SimulationSoftwareSuite.Builder getSimulationSoftwareSuite() {
            return simulationSoftwareSuite != null ? simulationSoftwareSuite.toBuilder() : null;
        }

        @Override
        public final Builder simulationSoftwareSuite(SimulationSoftwareSuite simulationSoftwareSuite) {
            this.simulationSoftwareSuite = simulationSoftwareSuite;
            return this;
        }

        public final void setSimulationSoftwareSuite(SimulationSoftwareSuite.BuilderImpl simulationSoftwareSuite) {
            this.simulationSoftwareSuite = simulationSoftwareSuite != null ? simulationSoftwareSuite.build() : null;
        }

        public final RobotSoftwareSuite.Builder getRobotSoftwareSuite() {
            return robotSoftwareSuite != null ? robotSoftwareSuite.toBuilder() : null;
        }

        @Override
        public final Builder robotSoftwareSuite(RobotSoftwareSuite robotSoftwareSuite) {
            this.robotSoftwareSuite = robotSoftwareSuite;
            return this;
        }

        public final void setRobotSoftwareSuite(RobotSoftwareSuite.BuilderImpl robotSoftwareSuite) {
            this.robotSoftwareSuite = robotSoftwareSuite != null ? robotSoftwareSuite.build() : null;
        }

        public final RenderingEngine.Builder getRenderingEngine() {
            return renderingEngine != null ? renderingEngine.toBuilder() : null;
        }

        @Override
        public final Builder renderingEngine(RenderingEngine renderingEngine) {
            this.renderingEngine = renderingEngine;
            return this;
        }

        public final void setRenderingEngine(RenderingEngine.BuilderImpl renderingEngine) {
            this.renderingEngine = renderingEngine != null ? renderingEngine.build() : null;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public CreateSimulationApplicationVersionResponse build() {
            return new CreateSimulationApplicationVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
