/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuiteType;
import software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuiteVersionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RobotSoftwareSuite
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RobotSoftwareSuite> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RobotSoftwareSuite.getter(RobotSoftwareSuite::nameAsString)).setter(RobotSoftwareSuite.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RobotSoftwareSuite.getter(RobotSoftwareSuite::versionAsString)).setter(RobotSoftwareSuite.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String version;

    private RobotSoftwareSuite(BuilderImpl builder) {
        this.name = builder.name;
        this.version = builder.version;
    }

    public RobotSoftwareSuiteType name() {
        return RobotSoftwareSuiteType.fromValue(this.name);
    }

    public String nameAsString() {
        return this.name;
    }

    public RobotSoftwareSuiteVersionType version() {
        return RobotSoftwareSuiteVersionType.fromValue(this.version);
    }

    public String versionAsString() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RobotSoftwareSuite)) {
            return false;
        }
        RobotSoftwareSuite other = (RobotSoftwareSuite)obj;
        return Objects.equals(this.nameAsString(), other.nameAsString()) && Objects.equals(this.versionAsString(), other.versionAsString());
    }

    public String toString() {
        return ToString.builder((String)"RobotSoftwareSuite").add("Name", (Object)this.nameAsString()).add("Version", (Object)this.versionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.nameAsString()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.versionAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RobotSoftwareSuite, T> g) {
        return obj -> g.apply((RobotSoftwareSuite)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(RobotSoftwareSuite model) {
            this.name(model.name);
            this.version(model.version);
        }

        public final String getNameAsString() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(RobotSoftwareSuiteType name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersionAsString() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public final Builder version(RobotSoftwareSuiteVersionType version) {
            this.version(version == null ? null : version.toString());
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public RobotSoftwareSuite build() {
            return new RobotSoftwareSuite(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RobotSoftwareSuite> {
        public Builder name(String var1);

        public Builder name(RobotSoftwareSuiteType var1);

        public Builder version(String var1);

        public Builder version(RobotSoftwareSuiteVersionType var1);
    }
}

