/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGroupQueryRequest extends ResourceGroupsRequest implements
        ToCopyableBuilder<UpdateGroupQueryRequest.Builder, UpdateGroupQueryRequest> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupName").getter(getter(UpdateGroupQueryRequest::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()).build();

    private static final SdkField<String> GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Group")
            .getter(getter(UpdateGroupQueryRequest::group)).setter(setter(Builder::group))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Group").build()).build();

    private static final SdkField<ResourceQuery> RESOURCE_QUERY_FIELD = SdkField
            .<ResourceQuery> builder(MarshallingType.SDK_POJO).memberName("ResourceQuery")
            .getter(getter(UpdateGroupQueryRequest::resourceQuery)).setter(setter(Builder::resourceQuery))
            .constructor(ResourceQuery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceQuery").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD, GROUP_FIELD,
            RESOURCE_QUERY_FIELD));

    private final String groupName;

    private final String group;

    private final ResourceQuery resourceQuery;

    private UpdateGroupQueryRequest(BuilderImpl builder) {
        super(builder);
        this.groupName = builder.groupName;
        this.group = builder.group;
        this.resourceQuery = builder.resourceQuery;
    }

    /**
     * <p>
     * Don't use this parameter. Use <code>Group</code> instead.
     * </p>
     * 
     * @return Don't use this parameter. Use <code>Group</code> instead.
     * @deprecated This field is deprecated, use Group instead.
     */
    @Deprecated
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The name or the ARN of the resource group to query.
     * </p>
     * 
     * @return The name or the ARN of the resource group to query.
     */
    public final String group() {
        return group;
    }

    /**
     * <p>
     * The resource query to determine which Amazon Web Services resources are members of this resource group.
     * </p>
     * <note>
     * <p>
     * A resource group can contain either a <code>Configuration</code> or a <code>ResourceQuery</code>, but not both.
     * </p>
     * </note>
     * 
     * @return The resource query to determine which Amazon Web Services resources are members of this resource
     *         group.</p> <note>
     *         <p>
     *         A resource group can contain either a <code>Configuration</code> or a <code>ResourceQuery</code>, but not
     *         both.
     *         </p>
     */
    public final ResourceQuery resourceQuery() {
        return resourceQuery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(group());
        hashCode = 31 * hashCode + Objects.hashCode(resourceQuery());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGroupQueryRequest)) {
            return false;
        }
        UpdateGroupQueryRequest other = (UpdateGroupQueryRequest) obj;
        return Objects.equals(groupName(), other.groupName()) && Objects.equals(group(), other.group())
                && Objects.equals(resourceQuery(), other.resourceQuery());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateGroupQueryRequest").add("GroupName", groupName()).add("Group", group())
                .add("ResourceQuery", resourceQuery()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "Group":
            return Optional.ofNullable(clazz.cast(group()));
        case "ResourceQuery":
            return Optional.ofNullable(clazz.cast(resourceQuery()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGroupQueryRequest, T> g) {
        return obj -> g.apply((UpdateGroupQueryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResourceGroupsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateGroupQueryRequest> {
        /**
         * <p>
         * Don't use this parameter. Use <code>Group</code> instead.
         * </p>
         * 
         * @param groupName
         *        Don't use this parameter. Use <code>Group</code> instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This field is deprecated, use Group instead.
         */
        @Deprecated
        Builder groupName(String groupName);

        /**
         * <p>
         * The name or the ARN of the resource group to query.
         * </p>
         * 
         * @param group
         *        The name or the ARN of the resource group to query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder group(String group);

        /**
         * <p>
         * The resource query to determine which Amazon Web Services resources are members of this resource group.
         * </p>
         * <note>
         * <p>
         * A resource group can contain either a <code>Configuration</code> or a <code>ResourceQuery</code>, but not
         * both.
         * </p>
         * </note>
         * 
         * @param resourceQuery
         *        The resource query to determine which Amazon Web Services resources are members of this resource
         *        group.</p> <note>
         *        <p>
         *        A resource group can contain either a <code>Configuration</code> or a <code>ResourceQuery</code>, but
         *        not both.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceQuery(ResourceQuery resourceQuery);

        /**
         * <p>
         * The resource query to determine which Amazon Web Services resources are members of this resource group.
         * </p>
         * <note>
         * <p>
         * A resource group can contain either a <code>Configuration</code> or a <code>ResourceQuery</code>, but not
         * both.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link ResourceQuery.Builder} avoiding
         * the need to create one manually via {@link ResourceQuery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceQuery.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceQuery(ResourceQuery)}.
         * 
         * @param resourceQuery
         *        a consumer that will call methods on {@link ResourceQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceQuery(ResourceQuery)
         */
        default Builder resourceQuery(Consumer<ResourceQuery.Builder> resourceQuery) {
            return resourceQuery(ResourceQuery.builder().applyMutation(resourceQuery).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResourceGroupsRequest.BuilderImpl implements Builder {
        private String groupName;

        private String group;

        private ResourceQuery resourceQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGroupQueryRequest model) {
            super(model);
            groupName(model.groupName);
            group(model.group);
            resourceQuery(model.resourceQuery);
        }

        @Deprecated
        public final String getGroupName() {
            return groupName;
        }

        @Deprecated
        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        @Deprecated
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getGroup() {
            return group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final ResourceQuery.Builder getResourceQuery() {
            return resourceQuery != null ? resourceQuery.toBuilder() : null;
        }

        public final void setResourceQuery(ResourceQuery.BuilderImpl resourceQuery) {
            this.resourceQuery = resourceQuery != null ? resourceQuery.build() : null;
        }

        @Override
        public final Builder resourceQuery(ResourceQuery resourceQuery) {
            this.resourceQuery = resourceQuery;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGroupQueryRequest build() {
            return new UpdateGroupQueryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
