/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resourcegroups.model.ResourceIdentifier;
import software.amazon.awssdk.services.resourcegroups.model.ResourceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGroupResourcesItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListGroupResourcesItem> {
    private static final SdkField<ResourceIdentifier> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Identifier").getter(ListGroupResourcesItem.getter(ListGroupResourcesItem::identifier)).setter(ListGroupResourcesItem.setter(Builder::identifier)).constructor(ResourceIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()}).build();
    private static final SdkField<ResourceStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(ListGroupResourcesItem.getter(ListGroupResourcesItem::status)).setter(ListGroupResourcesItem.setter(Builder::status)).constructor(ResourceStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final ResourceIdentifier identifier;
    private final ResourceStatus status;

    private ListGroupResourcesItem(BuilderImpl builder) {
        this.identifier = builder.identifier;
        this.status = builder.status;
    }

    public final ResourceIdentifier identifier() {
        return this.identifier;
    }

    public final ResourceStatus status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupResourcesItem)) {
            return false;
        }
        ListGroupResourcesItem other = (ListGroupResourcesItem)obj;
        return Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"ListGroupResourcesItem").add("Identifier", (Object)this.identifier()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGroupResourcesItem, T> g) {
        return obj -> g.apply((ListGroupResourcesItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ResourceIdentifier identifier;
        private ResourceStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupResourcesItem model) {
            this.identifier(model.identifier);
            this.status(model.status);
        }

        public final ResourceIdentifier.Builder getIdentifier() {
            return this.identifier != null ? this.identifier.toBuilder() : null;
        }

        public final void setIdentifier(ResourceIdentifier.BuilderImpl identifier) {
            this.identifier = identifier != null ? identifier.build() : null;
        }

        @Override
        public final Builder identifier(ResourceIdentifier identifier) {
            this.identifier = identifier;
            return this;
        }

        public final ResourceStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(ResourceStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(ResourceStatus status) {
            this.status = status;
            return this;
        }

        public ListGroupResourcesItem build() {
            return new ListGroupResourcesItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListGroupResourcesItem> {
        public Builder identifier(ResourceIdentifier var1);

        default public Builder identifier(Consumer<ResourceIdentifier.Builder> identifier) {
            return this.identifier((ResourceIdentifier)((ResourceIdentifier.Builder)ResourceIdentifier.builder().applyMutation(identifier)).build());
        }

        public Builder status(ResourceStatus var1);

        default public Builder status(Consumer<ResourceStatus.Builder> status) {
            return this.status((ResourceStatus)((ResourceStatus.Builder)ResourceStatus.builder().applyMutation(status)).build());
        }
    }
}

