/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationItem;
import software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationListCopier;
import software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GroupConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GroupConfiguration> {
    private static final SdkField<List<GroupConfigurationItem>> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Configuration").getter(GroupConfiguration.getter(GroupConfiguration::configuration)).setter(GroupConfiguration.setter(Builder::configuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupConfigurationItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<GroupConfigurationItem>> PROPOSED_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProposedConfiguration").getter(GroupConfiguration.getter(GroupConfiguration::proposedConfiguration)).setter(GroupConfiguration.setter(Builder::proposedConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProposedConfiguration").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupConfigurationItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GroupConfiguration.getter(GroupConfiguration::statusAsString)).setter(GroupConfiguration.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(GroupConfiguration.getter(GroupConfiguration::failureReason)).setter(GroupConfiguration.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD, PROPOSED_CONFIGURATION_FIELD, STATUS_FIELD, FAILURE_REASON_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<GroupConfigurationItem> configuration;
    private final List<GroupConfigurationItem> proposedConfiguration;
    private final String status;
    private final String failureReason;

    private GroupConfiguration(BuilderImpl builder) {
        this.configuration = builder.configuration;
        this.proposedConfiguration = builder.proposedConfiguration;
        this.status = builder.status;
        this.failureReason = builder.failureReason;
    }

    public final boolean hasConfiguration() {
        return this.configuration != null && !(this.configuration instanceof SdkAutoConstructList);
    }

    public final List<GroupConfigurationItem> configuration() {
        return this.configuration;
    }

    public final boolean hasProposedConfiguration() {
        return this.proposedConfiguration != null && !(this.proposedConfiguration instanceof SdkAutoConstructList);
    }

    public final List<GroupConfigurationItem> proposedConfiguration() {
        return this.proposedConfiguration;
    }

    public final GroupConfigurationStatus status() {
        return GroupConfigurationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfiguration() ? this.configuration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProposedConfiguration() ? this.proposedConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupConfiguration)) {
            return false;
        }
        GroupConfiguration other = (GroupConfiguration)obj;
        return this.hasConfiguration() == other.hasConfiguration() && Objects.equals(this.configuration(), other.configuration()) && this.hasProposedConfiguration() == other.hasProposedConfiguration() && Objects.equals(this.proposedConfiguration(), other.proposedConfiguration()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.failureReason(), other.failureReason());
    }

    public final String toString() {
        return ToString.builder((String)"GroupConfiguration").add("Configuration", this.hasConfiguration() ? this.configuration() : null).add("ProposedConfiguration", this.hasProposedConfiguration() ? this.proposedConfiguration() : null).add("Status", (Object)this.statusAsString()).add("FailureReason", (Object)this.failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "ProposedConfiguration": {
                return Optional.ofNullable(clazz.cast(this.proposedConfiguration()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GroupConfiguration, T> g) {
        return obj -> g.apply((GroupConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<GroupConfigurationItem> configuration = DefaultSdkAutoConstructList.getInstance();
        private List<GroupConfigurationItem> proposedConfiguration = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(GroupConfiguration model) {
            this.configuration(model.configuration);
            this.proposedConfiguration(model.proposedConfiguration);
            this.status(model.status);
            this.failureReason(model.failureReason);
        }

        public final Collection<GroupConfigurationItem.Builder> getConfiguration() {
            if (this.configuration instanceof SdkAutoConstructList) {
                return null;
            }
            return this.configuration != null ? (Collection)this.configuration.stream().map(GroupConfigurationItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configuration(Collection<GroupConfigurationItem> configuration) {
            this.configuration = GroupConfigurationListCopier.copy(configuration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configuration(GroupConfigurationItem ... configuration) {
            this.configuration(Arrays.asList(configuration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configuration(Consumer<GroupConfigurationItem.Builder> ... configuration) {
            this.configuration(Stream.of(configuration).map(c -> (GroupConfigurationItem)((GroupConfigurationItem.Builder)GroupConfigurationItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConfiguration(Collection<GroupConfigurationItem.BuilderImpl> configuration) {
            this.configuration = GroupConfigurationListCopier.copyFromBuilder(configuration);
        }

        public final Collection<GroupConfigurationItem.Builder> getProposedConfiguration() {
            if (this.proposedConfiguration instanceof SdkAutoConstructList) {
                return null;
            }
            return this.proposedConfiguration != null ? (Collection)this.proposedConfiguration.stream().map(GroupConfigurationItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder proposedConfiguration(Collection<GroupConfigurationItem> proposedConfiguration) {
            this.proposedConfiguration = GroupConfigurationListCopier.copy(proposedConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder proposedConfiguration(GroupConfigurationItem ... proposedConfiguration) {
            this.proposedConfiguration(Arrays.asList(proposedConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder proposedConfiguration(Consumer<GroupConfigurationItem.Builder> ... proposedConfiguration) {
            this.proposedConfiguration(Stream.of(proposedConfiguration).map(c -> (GroupConfigurationItem)((GroupConfigurationItem.Builder)GroupConfigurationItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProposedConfiguration(Collection<GroupConfigurationItem.BuilderImpl> proposedConfiguration) {
            this.proposedConfiguration = GroupConfigurationListCopier.copyFromBuilder(proposedConfiguration);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GroupConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public GroupConfiguration build() {
            return new GroupConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GroupConfiguration> {
        public Builder configuration(Collection<GroupConfigurationItem> var1);

        public Builder configuration(GroupConfigurationItem ... var1);

        public Builder configuration(Consumer<GroupConfigurationItem.Builder> ... var1);

        public Builder proposedConfiguration(Collection<GroupConfigurationItem> var1);

        public Builder proposedConfiguration(GroupConfigurationItem ... var1);

        public Builder proposedConfiguration(Consumer<GroupConfigurationItem.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(GroupConfigurationStatus var1);

        public Builder failureReason(String var1);
    }
}

