/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.resourcegroups.model.UntagRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UntagRequestModelMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("Arn").isBinary(false).build();
    private static final MarshallingInfo<List> KEYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Keys").isBinary(false).build();
    private static final UntagRequestModelMarshaller INSTANCE = new UntagRequestModelMarshaller();

    private UntagRequestModelMarshaller() {
    }

    public static UntagRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UntagRequest untagRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)untagRequest), (String)"untagRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)untagRequest.arn(), ARN_BINDING);
            protocolMarshaller.marshall(untagRequest.keys(), KEYS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

