/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.resourcegroups.model.ResourceIdentifier;

public class ResourceIdentifierUnmarshaller
implements Unmarshaller<ResourceIdentifier, JsonUnmarshallerContext> {
    private static final ResourceIdentifierUnmarshaller INSTANCE = new ResourceIdentifierUnmarshaller();

    public ResourceIdentifier unmarshall(JsonUnmarshallerContext context) throws Exception {
        ResourceIdentifier.Builder resourceIdentifierBuilder = ResourceIdentifier.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ResourceArn", targetDepth)) {
                    context.nextToken();
                    resourceIdentifierBuilder.resourceArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ResourceType", targetDepth)) {
                    context.nextToken();
                    resourceIdentifierBuilder.resourceType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ResourceIdentifier)resourceIdentifierBuilder.build();
    }

    public static ResourceIdentifierUnmarshaller getInstance() {
        return INSTANCE;
    }
}

