/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.resourcegroups.model.ResourceFilter;

public class ResourceFilterUnmarshaller
implements Unmarshaller<ResourceFilter, JsonUnmarshallerContext> {
    private static final ResourceFilterUnmarshaller INSTANCE = new ResourceFilterUnmarshaller();

    public ResourceFilter unmarshall(JsonUnmarshallerContext context) throws Exception {
        ResourceFilter.Builder resourceFilterBuilder = ResourceFilter.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    resourceFilterBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Values", targetDepth)) {
                    context.nextToken();
                    resourceFilterBuilder.values(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ResourceFilter)resourceFilterBuilder.build();
    }

    public static ResourceFilterUnmarshaller getInstance() {
        return INSTANCE;
    }
}

