/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.resourcegroups.model.ResourceFilter;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResourceFilterMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<List> VALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Values").isBinary(false).build();
    private static final ResourceFilterMarshaller INSTANCE = new ResourceFilterMarshaller();

    private ResourceFilterMarshaller() {
    }

    public static ResourceFilterMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResourceFilter resourceFilter, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)resourceFilter, (String)"resourceFilter");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)resourceFilter.nameAsString(), NAME_BINDING);
            protocolMarshaller.marshall(resourceFilter.values(), VALUES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

