/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.resourcegroups.model.GroupQuery;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GroupQueryMarshaller {
    private static final MarshallingInfo<String> GROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GroupName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> RESOURCEQUERY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceQuery").isBinary(false).build();
    private static final GroupQueryMarshaller INSTANCE = new GroupQueryMarshaller();

    private GroupQueryMarshaller() {
    }

    public static GroupQueryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GroupQuery groupQuery, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)groupQuery, (String)"groupQuery");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)groupQuery.groupName(), GROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)groupQuery.resourceQuery(), RESOURCEQUERY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

