/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourcegroups.ResourceGroupsClient;
import software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesRequest;
import software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesResponse;

public class ListGroupResourcesIterable
implements SdkIterable<ListGroupResourcesResponse> {
    private final ResourceGroupsClient client;
    private final ListGroupResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGroupResourcesIterable(ResourceGroupsClient client, ListGroupResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListGroupResourcesResponseFetcher();
    }

    public Iterator<ListGroupResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListGroupResourcesIterable resume(ListGroupResourcesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListGroupResourcesIterable(this.client, (ListGroupResourcesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListGroupResourcesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListGroupResourcesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListGroupResourcesResponseFetcher
    implements SyncPageFetcher<ListGroupResourcesResponse> {
        private ListGroupResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListGroupResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListGroupResourcesResponse nextPage(ListGroupResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListGroupResourcesIterable.this.client.listGroupResources(ListGroupResourcesIterable.this.firstRequest);
            }
            return ListGroupResourcesIterable.this.client.listGroupResources((ListGroupResourcesRequest)((Object)ListGroupResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

