/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.resourcegroups.model.ResourceGroupsRequest;
import software.amazon.awssdk.services.resourcegroups.model.TagKeyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UntagRequest
extends ResourceGroupsRequest
implements ToCopyableBuilder<Builder, UntagRequest> {
    private final String arn;
    private final List<String> keys;

    private UntagRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.keys = builder.keys;
    }

    public String arn() {
        return this.arn;
    }

    public List<String> keys() {
        return this.keys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.keys());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UntagRequest)) {
            return false;
        }
        UntagRequest other = (UntagRequest)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.keys(), other.keys());
    }

    public String toString() {
        return ToString.builder((String)"UntagRequest").add("Arn", (Object)this.arn()).add("Keys", this.keys()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Keys": {
                return Optional.ofNullable(clazz.cast(this.keys()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ResourceGroupsRequest.BuilderImpl
    implements Builder {
        private String arn;
        private List<String> keys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UntagRequest model) {
            super(model);
            this.arn(model.arn);
            this.keys(model.keys);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Collection<String> getKeys() {
            return this.keys;
        }

        @Override
        public final Builder keys(Collection<String> keys) {
            this.keys = TagKeyListCopier.copy(keys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keys(String ... keys) {
            this.keys(Arrays.asList(keys));
            return this;
        }

        public final void setKeys(Collection<String> keys) {
            this.keys = TagKeyListCopier.copy(keys);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UntagRequest build() {
            return new UntagRequest(this);
        }
    }

    public static interface Builder
    extends ResourceGroupsRequest.Builder,
    CopyableBuilder<Builder, UntagRequest> {
        public Builder arn(String var1);

        public Builder keys(Collection<String> var1);

        public Builder keys(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

