/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourceexplorer2.ResourceExplorer2AsyncClient;
import software.amazon.awssdk.services.resourceexplorer2.internal.UserAgentUtils;
import software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.SupportedResourceType;

public class ListSupportedResourceTypesPublisher
implements SdkPublisher<ListSupportedResourceTypesResponse> {
    private final ResourceExplorer2AsyncClient client;
    private final ListSupportedResourceTypesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSupportedResourceTypesPublisher(ResourceExplorer2AsyncClient client, ListSupportedResourceTypesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSupportedResourceTypesPublisher(ResourceExplorer2AsyncClient client, ListSupportedResourceTypesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSupportedResourceTypesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSupportedResourceTypesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SupportedResourceType> resourceTypes() {
        Function<ListSupportedResourceTypesResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceTypes() != null) {
                return response.resourceTypes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSupportedResourceTypesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSupportedResourceTypesResponseFetcher
    implements AsyncPageFetcher<ListSupportedResourceTypesResponse> {
        private ListSupportedResourceTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListSupportedResourceTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSupportedResourceTypesResponse> nextPage(ListSupportedResourceTypesResponse previousPage) {
            if (previousPage == null) {
                return ListSupportedResourceTypesPublisher.this.client.listSupportedResourceTypes(ListSupportedResourceTypesPublisher.this.firstRequest);
            }
            return ListSupportedResourceTypesPublisher.this.client.listSupportedResourceTypes((ListSupportedResourceTypesRequest)((Object)ListSupportedResourceTypesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

