/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourceexplorer2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the status of Resource Explorer configuration in a specific Amazon Web Services Region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegionStatus implements SdkPojo, Serializable, ToCopyableBuilder<RegionStatus.Builder, RegionStatus> {
    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(RegionStatus::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<IndexStatus> INDEX_FIELD = SdkField.<IndexStatus> builder(MarshallingType.SDK_POJO)
            .memberName("Index").getter(getter(RegionStatus::index)).setter(setter(Builder::index))
            .constructor(IndexStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Index").build()).build();

    private static final SdkField<ViewStatus> VIEW_FIELD = SdkField.<ViewStatus> builder(MarshallingType.SDK_POJO)
            .memberName("View").getter(getter(RegionStatus::view)).setter(setter(Builder::view)).constructor(ViewStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("View").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD, INDEX_FIELD,
            VIEW_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String region;

    private final IndexStatus index;

    private final ViewStatus view;

    private RegionStatus(BuilderImpl builder) {
        this.region = builder.region;
        this.index = builder.index;
        this.view = builder.view;
    }

    /**
     * <p>
     * The Amazon Web Services Region for which this status information applies.
     * </p>
     * 
     * @return The Amazon Web Services Region for which this status information applies.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The status information for the Resource Explorer index in this Region.
     * </p>
     * 
     * @return The status information for the Resource Explorer index in this Region.
     */
    public final IndexStatus index() {
        return index;
    }

    /**
     * <p>
     * The status information for the Resource Explorer view in this Region.
     * </p>
     * 
     * @return The status information for the Resource Explorer view in this Region.
     */
    public final ViewStatus view() {
        return view;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(index());
        hashCode = 31 * hashCode + Objects.hashCode(view());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegionStatus)) {
            return false;
        }
        RegionStatus other = (RegionStatus) obj;
        return Objects.equals(region(), other.region()) && Objects.equals(index(), other.index())
                && Objects.equals(view(), other.view());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegionStatus").add("Region", region()).add("Index", index()).add("View", view()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "Index":
            return Optional.ofNullable(clazz.cast(index()));
        case "View":
            return Optional.ofNullable(clazz.cast(view()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Region", REGION_FIELD);
        map.put("Index", INDEX_FIELD);
        map.put("View", VIEW_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegionStatus, T> g) {
        return obj -> g.apply((RegionStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegionStatus> {
        /**
         * <p>
         * The Amazon Web Services Region for which this status information applies.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Region for which this status information applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The status information for the Resource Explorer index in this Region.
         * </p>
         * 
         * @param index
         *        The status information for the Resource Explorer index in this Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder index(IndexStatus index);

        /**
         * <p>
         * The status information for the Resource Explorer index in this Region.
         * </p>
         * This is a convenience method that creates an instance of the {@link IndexStatus.Builder} avoiding the need to
         * create one manually via {@link IndexStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IndexStatus.Builder#build()} is called immediately and its result
         * is passed to {@link #index(IndexStatus)}.
         * 
         * @param index
         *        a consumer that will call methods on {@link IndexStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #index(IndexStatus)
         */
        default Builder index(Consumer<IndexStatus.Builder> index) {
            return index(IndexStatus.builder().applyMutation(index).build());
        }

        /**
         * <p>
         * The status information for the Resource Explorer view in this Region.
         * </p>
         * 
         * @param view
         *        The status information for the Resource Explorer view in this Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder view(ViewStatus view);

        /**
         * <p>
         * The status information for the Resource Explorer view in this Region.
         * </p>
         * This is a convenience method that creates an instance of the {@link ViewStatus.Builder} avoiding the need to
         * create one manually via {@link ViewStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ViewStatus.Builder#build()} is called immediately and its result
         * is passed to {@link #view(ViewStatus)}.
         * 
         * @param view
         *        a consumer that will call methods on {@link ViewStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #view(ViewStatus)
         */
        default Builder view(Consumer<ViewStatus.Builder> view) {
            return view(ViewStatus.builder().applyMutation(view).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String region;

        private IndexStatus index;

        private ViewStatus view;

        private BuilderImpl() {
        }

        private BuilderImpl(RegionStatus model) {
            region(model.region);
            index(model.index);
            view(model.view);
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final IndexStatus.Builder getIndex() {
            return index != null ? index.toBuilder() : null;
        }

        public final void setIndex(IndexStatus.BuilderImpl index) {
            this.index = index != null ? index.build() : null;
        }

        @Override
        public final Builder index(IndexStatus index) {
            this.index = index;
            return this;
        }

        public final ViewStatus.Builder getView() {
            return view != null ? view.toBuilder() : null;
        }

        public final void setView(ViewStatus.BuilderImpl view) {
            this.view = view != null ? view.build() : null;
        }

        @Override
        public final Builder view(ViewStatus view) {
            this.view = view;
            return this;
        }

        @Override
        public RegionStatus build() {
            return new RegionStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
