/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourceexplorer2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourceExplorerSetupResponse extends ResourceExplorer2Response implements
        ToCopyableBuilder<GetResourceExplorerSetupResponse.Builder, GetResourceExplorerSetupResponse> {
    private static final SdkField<List<RegionStatus>> REGIONS_FIELD = SdkField
            .<List<RegionStatus>> builder(MarshallingType.LIST)
            .memberName("Regions")
            .getter(getter(GetResourceExplorerSetupResponse::regions))
            .setter(setter(Builder::regions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Regions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RegionStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(RegionStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetResourceExplorerSetupResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<RegionStatus> regions;

    private final String nextToken;

    private GetResourceExplorerSetupResponse(BuilderImpl builder) {
        super(builder);
        this.regions = builder.regions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Regions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRegions() {
        return regions != null && !(regions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Region status objects that describe the current state of Resource Explorer configuration in each
     * Region.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegions} method.
     * </p>
     * 
     * @return A list of Region status objects that describe the current state of Resource Explorer configuration in
     *         each Region.
     */
    public final List<RegionStatus> regions() {
        return regions;
    }

    /**
     * <p>
     * The pagination token to use in a subsequent <code>GetResourceExplorerSetup</code> request to retrieve the next
     * set of results.
     * </p>
     * 
     * @return The pagination token to use in a subsequent <code>GetResourceExplorerSetup</code> request to retrieve the
     *         next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRegions() ? regions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceExplorerSetupResponse)) {
            return false;
        }
        GetResourceExplorerSetupResponse other = (GetResourceExplorerSetupResponse) obj;
        return hasRegions() == other.hasRegions() && Objects.equals(regions(), other.regions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResourceExplorerSetupResponse").add("Regions", hasRegions() ? regions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Regions":
            return Optional.ofNullable(clazz.cast(regions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Regions", REGIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResourceExplorerSetupResponse, T> g) {
        return obj -> g.apply((GetResourceExplorerSetupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ResourceExplorer2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetResourceExplorerSetupResponse> {
        /**
         * <p>
         * A list of Region status objects that describe the current state of Resource Explorer configuration in each
         * Region.
         * </p>
         * 
         * @param regions
         *        A list of Region status objects that describe the current state of Resource Explorer configuration in
         *        each Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(Collection<RegionStatus> regions);

        /**
         * <p>
         * A list of Region status objects that describe the current state of Resource Explorer configuration in each
         * Region.
         * </p>
         * 
         * @param regions
         *        A list of Region status objects that describe the current state of Resource Explorer configuration in
         *        each Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(RegionStatus... regions);

        /**
         * <p>
         * A list of Region status objects that describe the current state of Resource Explorer configuration in each
         * Region.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resourceexplorer2.model.RegionStatus.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.resourceexplorer2.model.RegionStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resourceexplorer2.model.RegionStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #regions(List<RegionStatus>)}.
         * 
         * @param regions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resourceexplorer2.model.RegionStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #regions(java.util.Collection<RegionStatus>)
         */
        Builder regions(Consumer<RegionStatus.Builder>... regions);

        /**
         * <p>
         * The pagination token to use in a subsequent <code>GetResourceExplorerSetup</code> request to retrieve the
         * next set of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use in a subsequent <code>GetResourceExplorerSetup</code> request to retrieve
         *        the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ResourceExplorer2Response.BuilderImpl implements Builder {
        private List<RegionStatus> regions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceExplorerSetupResponse model) {
            super(model);
            regions(model.regions);
            nextToken(model.nextToken);
        }

        public final List<RegionStatus.Builder> getRegions() {
            List<RegionStatus.Builder> result = RegionStatusListCopier.copyToBuilder(this.regions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegions(Collection<RegionStatus.BuilderImpl> regions) {
            this.regions = RegionStatusListCopier.copyFromBuilder(regions);
        }

        @Override
        public final Builder regions(Collection<RegionStatus> regions) {
            this.regions = RegionStatusListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(RegionStatus... regions) {
            regions(Arrays.asList(regions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(Consumer<RegionStatus.Builder>... regions) {
            regions(Stream.of(regions).map(c -> RegionStatus.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetResourceExplorerSetupResponse build() {
            return new GetResourceExplorerSetupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
