/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourceexplorer2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAccountLevelServiceConfigurationResponse extends ResourceExplorer2Response implements
        ToCopyableBuilder<GetAccountLevelServiceConfigurationResponse.Builder, GetAccountLevelServiceConfigurationResponse> {
    private static final SdkField<OrgConfiguration> ORG_CONFIGURATION_FIELD = SdkField
            .<OrgConfiguration> builder(MarshallingType.SDK_POJO).memberName("OrgConfiguration")
            .getter(getter(GetAccountLevelServiceConfigurationResponse::orgConfiguration))
            .setter(setter(Builder::orgConfiguration)).constructor(OrgConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrgConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORG_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final OrgConfiguration orgConfiguration;

    private GetAccountLevelServiceConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.orgConfiguration = builder.orgConfiguration;
    }

    /**
     * <p>
     * Details about the organization, and whether configuration is <code>ENABLED</code> or <code>DISABLED</code>.
     * </p>
     * 
     * @return Details about the organization, and whether configuration is <code>ENABLED</code> or
     *         <code>DISABLED</code>.
     */
    public final OrgConfiguration orgConfiguration() {
        return orgConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(orgConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountLevelServiceConfigurationResponse)) {
            return false;
        }
        GetAccountLevelServiceConfigurationResponse other = (GetAccountLevelServiceConfigurationResponse) obj;
        return Objects.equals(orgConfiguration(), other.orgConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAccountLevelServiceConfigurationResponse").add("OrgConfiguration", orgConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrgConfiguration":
            return Optional.ofNullable(clazz.cast(orgConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OrgConfiguration", ORG_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAccountLevelServiceConfigurationResponse, T> g) {
        return obj -> g.apply((GetAccountLevelServiceConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ResourceExplorer2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAccountLevelServiceConfigurationResponse> {
        /**
         * <p>
         * Details about the organization, and whether configuration is <code>ENABLED</code> or <code>DISABLED</code>.
         * </p>
         * 
         * @param orgConfiguration
         *        Details about the organization, and whether configuration is <code>ENABLED</code> or
         *        <code>DISABLED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orgConfiguration(OrgConfiguration orgConfiguration);

        /**
         * <p>
         * Details about the organization, and whether configuration is <code>ENABLED</code> or <code>DISABLED</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link OrgConfiguration.Builder} avoiding the
         * need to create one manually via {@link OrgConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OrgConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #orgConfiguration(OrgConfiguration)}.
         * 
         * @param orgConfiguration
         *        a consumer that will call methods on {@link OrgConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orgConfiguration(OrgConfiguration)
         */
        default Builder orgConfiguration(Consumer<OrgConfiguration.Builder> orgConfiguration) {
            return orgConfiguration(OrgConfiguration.builder().applyMutation(orgConfiguration).build());
        }
    }

    static final class BuilderImpl extends ResourceExplorer2Response.BuilderImpl implements Builder {
        private OrgConfiguration orgConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountLevelServiceConfigurationResponse model) {
            super(model);
            orgConfiguration(model.orgConfiguration);
        }

        public final OrgConfiguration.Builder getOrgConfiguration() {
            return orgConfiguration != null ? orgConfiguration.toBuilder() : null;
        }

        public final void setOrgConfiguration(OrgConfiguration.BuilderImpl orgConfiguration) {
            this.orgConfiguration = orgConfiguration != null ? orgConfiguration.build() : null;
        }

        @Override
        public final Builder orgConfiguration(OrgConfiguration orgConfiguration) {
            this.orgConfiguration = orgConfiguration;
            return this;
        }

        @Override
        public GetAccountLevelServiceConfigurationResponse build() {
            return new GetAccountLevelServiceConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
