/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourceexplorer2.ResourceExplorer2Client;
import software.amazon.awssdk.services.resourceexplorer2.internal.UserAgentUtils;
import software.amazon.awssdk.services.resourceexplorer2.model.ListServiceViewsRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListServiceViewsResponse;

public class ListServiceViewsIterable
implements SdkIterable<ListServiceViewsResponse> {
    private final ResourceExplorer2Client client;
    private final ListServiceViewsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListServiceViewsIterable(ResourceExplorer2Client client, ListServiceViewsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListServiceViewsResponseFetcher();
    }

    public Iterator<ListServiceViewsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> serviceViews() {
        Function<ListServiceViewsResponse, Iterator> getIterator = response -> {
            if (response != null && response.serviceViews() != null) {
                return response.serviceViews().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListServiceViewsResponseFetcher
    implements SyncPageFetcher<ListServiceViewsResponse> {
        private ListServiceViewsResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceViewsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListServiceViewsResponse nextPage(ListServiceViewsResponse previousPage) {
            if (previousPage == null) {
                return ListServiceViewsIterable.this.client.listServiceViews(ListServiceViewsIterable.this.firstRequest);
            }
            return ListServiceViewsIterable.this.client.listServiceViews((ListServiceViewsRequest)((Object)ListServiceViewsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

