/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.resourceexplorer2.DefaultResourceExplorer2BaseClientBuilder;
import software.amazon.awssdk.services.resourceexplorer2.DefaultResourceExplorer2Client;
import software.amazon.awssdk.services.resourceexplorer2.ResourceExplorer2Client;
import software.amazon.awssdk.services.resourceexplorer2.ResourceExplorer2ClientBuilder;
import software.amazon.awssdk.services.resourceexplorer2.ResourceExplorer2ServiceClientConfiguration;
import software.amazon.awssdk.services.resourceexplorer2.endpoints.ResourceExplorer2EndpointProvider;

@SdkInternalApi
final class DefaultResourceExplorer2ClientBuilder
extends DefaultResourceExplorer2BaseClientBuilder<ResourceExplorer2ClientBuilder, ResourceExplorer2Client>
implements ResourceExplorer2ClientBuilder {
    DefaultResourceExplorer2ClientBuilder() {
    }

    @Override
    public DefaultResourceExplorer2ClientBuilder endpointProvider(ResourceExplorer2EndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ResourceExplorer2Client buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultResourceExplorer2ClientBuilder.validateClientOptions(clientConfiguration);
        ResourceExplorer2ServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultResourceExplorer2Client client = new DefaultResourceExplorer2Client(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ResourceExplorer2ServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ResourceExplorer2ServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

